/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model latency threshold.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelLatencyThreshold implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelLatencyThreshold.Builder, ModelLatencyThreshold> {
    private static final SdkField<String> PERCENTILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Percentile").getter(getter(ModelLatencyThreshold::percentile)).setter(setter(Builder::percentile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentile").build()).build();

    private static final SdkField<Integer> VALUE_IN_MILLISECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValueInMilliseconds").getter(getter(ModelLatencyThreshold::valueInMilliseconds))
            .setter(setter(Builder::valueInMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueInMilliseconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTILE_FIELD,
            VALUE_IN_MILLISECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String percentile;

    private final Integer valueInMilliseconds;

    private ModelLatencyThreshold(BuilderImpl builder) {
        this.percentile = builder.percentile;
        this.valueInMilliseconds = builder.valueInMilliseconds;
    }

    /**
     * <p>
     * The model latency percentile threshold.
     * </p>
     * 
     * @return The model latency percentile threshold.
     */
    public final String percentile() {
        return percentile;
    }

    /**
     * <p>
     * The model latency percentile value in milliseconds.
     * </p>
     * 
     * @return The model latency percentile value in milliseconds.
     */
    public final Integer valueInMilliseconds() {
        return valueInMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentile());
        hashCode = 31 * hashCode + Objects.hashCode(valueInMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelLatencyThreshold)) {
            return false;
        }
        ModelLatencyThreshold other = (ModelLatencyThreshold) obj;
        return Objects.equals(percentile(), other.percentile())
                && Objects.equals(valueInMilliseconds(), other.valueInMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelLatencyThreshold").add("Percentile", percentile())
                .add("ValueInMilliseconds", valueInMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Percentile":
            return Optional.ofNullable(clazz.cast(percentile()));
        case "ValueInMilliseconds":
            return Optional.ofNullable(clazz.cast(valueInMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelLatencyThreshold, T> g) {
        return obj -> g.apply((ModelLatencyThreshold) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelLatencyThreshold> {
        /**
         * <p>
         * The model latency percentile threshold.
         * </p>
         * 
         * @param percentile
         *        The model latency percentile threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentile(String percentile);

        /**
         * <p>
         * The model latency percentile value in milliseconds.
         * </p>
         * 
         * @param valueInMilliseconds
         *        The model latency percentile value in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueInMilliseconds(Integer valueInMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private String percentile;

        private Integer valueInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelLatencyThreshold model) {
            percentile(model.percentile);
            valueInMilliseconds(model.valueInMilliseconds);
        }

        public final String getPercentile() {
            return percentile;
        }

        public final void setPercentile(String percentile) {
            this.percentile = percentile;
        }

        @Override
        public final Builder percentile(String percentile) {
            this.percentile = percentile;
            return this;
        }

        public final Integer getValueInMilliseconds() {
            return valueInMilliseconds;
        }

        public final void setValueInMilliseconds(Integer valueInMilliseconds) {
            this.valueInMilliseconds = valueInMilliseconds;
        }

        @Override
        public final Builder valueInMilliseconds(Integer valueInMilliseconds) {
            this.valueInMilliseconds = valueInMilliseconds;
            return this;
        }

        @Override
        public ModelLatencyThreshold build() {
            return new ModelLatencyThreshold(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
