/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a candidate produced by an AutoML training job, including its status, steps, and other properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLCandidate implements SdkPojo, Serializable, ToCopyableBuilder<AutoMLCandidate.Builder, AutoMLCandidate> {
    private static final SdkField<String> CANDIDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateName").getter(getter(AutoMLCandidate::candidateName)).setter(setter(Builder::candidateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateName").build()).build();

    private static final SdkField<FinalAutoMLJobObjectiveMetric> FINAL_AUTO_ML_JOB_OBJECTIVE_METRIC_FIELD = SdkField
            .<FinalAutoMLJobObjectiveMetric> builder(MarshallingType.SDK_POJO)
            .memberName("FinalAutoMLJobObjectiveMetric")
            .getter(getter(AutoMLCandidate::finalAutoMLJobObjectiveMetric))
            .setter(setter(Builder::finalAutoMLJobObjectiveMetric))
            .constructor(FinalAutoMLJobObjectiveMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalAutoMLJobObjectiveMetric")
                    .build()).build();

    private static final SdkField<String> OBJECTIVE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectiveStatus").getter(getter(AutoMLCandidate::objectiveStatusAsString))
            .setter(setter(Builder::objectiveStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatus").build()).build();

    private static final SdkField<List<AutoMLCandidateStep>> CANDIDATE_STEPS_FIELD = SdkField
            .<List<AutoMLCandidateStep>> builder(MarshallingType.LIST)
            .memberName("CandidateSteps")
            .getter(getter(AutoMLCandidate::candidateSteps))
            .setter(setter(Builder::candidateSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLCandidateStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLCandidateStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CANDIDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CandidateStatus").getter(getter(AutoMLCandidate::candidateStatusAsString))
            .setter(setter(Builder::candidateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateStatus").build()).build();

    private static final SdkField<List<AutoMLContainerDefinition>> INFERENCE_CONTAINERS_FIELD = SdkField
            .<List<AutoMLContainerDefinition>> builder(MarshallingType.LIST)
            .memberName("InferenceContainers")
            .getter(getter(AutoMLCandidate::inferenceContainers))
            .setter(setter(Builder::inferenceContainers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceContainers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLContainerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLContainerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AutoMLCandidate::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(AutoMLCandidate::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(AutoMLCandidate::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(AutoMLCandidate::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<CandidateProperties> CANDIDATE_PROPERTIES_FIELD = SdkField
            .<CandidateProperties> builder(MarshallingType.SDK_POJO).memberName("CandidateProperties")
            .getter(getter(AutoMLCandidate::candidateProperties)).setter(setter(Builder::candidateProperties))
            .constructor(CandidateProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateProperties").build())
            .build();

    private static final SdkField<Map<String, List<AutoMLContainerDefinition>>> INFERENCE_CONTAINER_DEFINITIONS_FIELD = SdkField
            .<Map<String, List<AutoMLContainerDefinition>>> builder(MarshallingType.MAP)
            .memberName("InferenceContainerDefinitions")
            .getter(getter(AutoMLCandidate::inferenceContainerDefinitionsAsStrings))
            .setter(setter(Builder::inferenceContainerDefinitionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceContainerDefinitions")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<AutoMLContainerDefinition>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<AutoMLContainerDefinition> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(AutoMLContainerDefinition::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_NAME_FIELD,
            FINAL_AUTO_ML_JOB_OBJECTIVE_METRIC_FIELD, OBJECTIVE_STATUS_FIELD, CANDIDATE_STEPS_FIELD, CANDIDATE_STATUS_FIELD,
            INFERENCE_CONTAINERS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD,
            CANDIDATE_PROPERTIES_FIELD, INFERENCE_CONTAINER_DEFINITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String candidateName;

    private final FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric;

    private final String objectiveStatus;

    private final List<AutoMLCandidateStep> candidateSteps;

    private final String candidateStatus;

    private final List<AutoMLContainerDefinition> inferenceContainers;

    private final Instant creationTime;

    private final Instant endTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final CandidateProperties candidateProperties;

    private final Map<String, List<AutoMLContainerDefinition>> inferenceContainerDefinitions;

    private AutoMLCandidate(BuilderImpl builder) {
        this.candidateName = builder.candidateName;
        this.finalAutoMLJobObjectiveMetric = builder.finalAutoMLJobObjectiveMetric;
        this.objectiveStatus = builder.objectiveStatus;
        this.candidateSteps = builder.candidateSteps;
        this.candidateStatus = builder.candidateStatus;
        this.inferenceContainers = builder.inferenceContainers;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.candidateProperties = builder.candidateProperties;
        this.inferenceContainerDefinitions = builder.inferenceContainerDefinitions;
    }

    /**
     * <p>
     * The name of the candidate.
     * </p>
     * 
     * @return The name of the candidate.
     */
    public final String candidateName() {
        return candidateName;
    }

    /**
     * Returns the value of the FinalAutoMLJobObjectiveMetric property for this object.
     * 
     * @return The value of the FinalAutoMLJobObjectiveMetric property for this object.
     */
    public final FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric() {
        return finalAutoMLJobObjectiveMetric;
    }

    /**
     * <p>
     * The objective's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectiveStatus}
     * will return {@link ObjectiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectiveStatusAsString}.
     * </p>
     * 
     * @return The objective's status.
     * @see ObjectiveStatus
     */
    public final ObjectiveStatus objectiveStatus() {
        return ObjectiveStatus.fromValue(objectiveStatus);
    }

    /**
     * <p>
     * The objective's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectiveStatus}
     * will return {@link ObjectiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #objectiveStatusAsString}.
     * </p>
     * 
     * @return The objective's status.
     * @see ObjectiveStatus
     */
    public final String objectiveStatusAsString() {
        return objectiveStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the CandidateSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCandidateSteps() {
        return candidateSteps != null && !(candidateSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the candidate's steps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCandidateSteps} method.
     * </p>
     * 
     * @return Information about the candidate's steps.
     */
    public final List<AutoMLCandidateStep> candidateSteps() {
        return candidateSteps;
    }

    /**
     * <p>
     * The candidate's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #candidateStatus}
     * will return {@link CandidateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #candidateStatusAsString}.
     * </p>
     * 
     * @return The candidate's status.
     * @see CandidateStatus
     */
    public final CandidateStatus candidateStatus() {
        return CandidateStatus.fromValue(candidateStatus);
    }

    /**
     * <p>
     * The candidate's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #candidateStatus}
     * will return {@link CandidateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #candidateStatusAsString}.
     * </p>
     * 
     * @return The candidate's status.
     * @see CandidateStatus
     */
    public final String candidateStatusAsString() {
        return candidateStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceContainers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInferenceContainers() {
        return inferenceContainers != null && !(inferenceContainers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the recommended inference container definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceContainers} method.
     * </p>
     * 
     * @return Information about the recommended inference container definitions.
     */
    public final List<AutoMLContainerDefinition> inferenceContainers() {
        return inferenceContainers;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The end time.
     * </p>
     * 
     * @return The end time.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The last modified time.
     * </p>
     * 
     * @return The last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The failure reason.
     * </p>
     * 
     * @return The failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The properties of an AutoML candidate job.
     * </p>
     * 
     * @return The properties of an AutoML candidate job.
     */
    public final CandidateProperties candidateProperties() {
        return candidateProperties;
    }

    /**
     * <p>
     * The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for the
     * candidate. This field is populated for the V2 API only (for example, for jobs created by calling
     * <code>CreateAutoMLJobV2</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceContainerDefinitions} method.
     * </p>
     * 
     * @return The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for
     *         the candidate. This field is populated for the V2 API only (for example, for jobs created by calling
     *         <code>CreateAutoMLJobV2</code>).
     */
    public final Map<AutoMLProcessingUnit, List<AutoMLContainerDefinition>> inferenceContainerDefinitions() {
        return AutoMLInferenceContainerDefinitionsCopier.copyStringToEnum(inferenceContainerDefinitions);
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceContainerDefinitions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceContainerDefinitions() {
        return inferenceContainerDefinitions != null && !(inferenceContainerDefinitions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for the
     * candidate. This field is populated for the V2 API only (for example, for jobs created by calling
     * <code>CreateAutoMLJobV2</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceContainerDefinitions} method.
     * </p>
     * 
     * @return The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for
     *         the candidate. This field is populated for the V2 API only (for example, for jobs created by calling
     *         <code>CreateAutoMLJobV2</code>).
     */
    public final Map<String, List<AutoMLContainerDefinition>> inferenceContainerDefinitionsAsStrings() {
        return inferenceContainerDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(candidateName());
        hashCode = 31 * hashCode + Objects.hashCode(finalAutoMLJobObjectiveMetric());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCandidateSteps() ? candidateSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(candidateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceContainers() ? inferenceContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(candidateProperties());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasInferenceContainerDefinitions() ? inferenceContainerDefinitionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLCandidate)) {
            return false;
        }
        AutoMLCandidate other = (AutoMLCandidate) obj;
        return Objects.equals(candidateName(), other.candidateName())
                && Objects.equals(finalAutoMLJobObjectiveMetric(), other.finalAutoMLJobObjectiveMetric())
                && Objects.equals(objectiveStatusAsString(), other.objectiveStatusAsString())
                && hasCandidateSteps() == other.hasCandidateSteps() && Objects.equals(candidateSteps(), other.candidateSteps())
                && Objects.equals(candidateStatusAsString(), other.candidateStatusAsString())
                && hasInferenceContainers() == other.hasInferenceContainers()
                && Objects.equals(inferenceContainers(), other.inferenceContainers())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(candidateProperties(), other.candidateProperties())
                && hasInferenceContainerDefinitions() == other.hasInferenceContainerDefinitions()
                && Objects.equals(inferenceContainerDefinitionsAsStrings(), other.inferenceContainerDefinitionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AutoMLCandidate")
                .add("CandidateName", candidateName())
                .add("FinalAutoMLJobObjectiveMetric", finalAutoMLJobObjectiveMetric())
                .add("ObjectiveStatus", objectiveStatusAsString())
                .add("CandidateSteps", hasCandidateSteps() ? candidateSteps() : null)
                .add("CandidateStatus", candidateStatusAsString())
                .add("InferenceContainers", hasInferenceContainers() ? inferenceContainers() : null)
                .add("CreationTime", creationTime())
                .add("EndTime", endTime())
                .add("LastModifiedTime", lastModifiedTime())
                .add("FailureReason", failureReason())
                .add("CandidateProperties", candidateProperties())
                .add("InferenceContainerDefinitions",
                        hasInferenceContainerDefinitions() ? inferenceContainerDefinitionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CandidateName":
            return Optional.ofNullable(clazz.cast(candidateName()));
        case "FinalAutoMLJobObjectiveMetric":
            return Optional.ofNullable(clazz.cast(finalAutoMLJobObjectiveMetric()));
        case "ObjectiveStatus":
            return Optional.ofNullable(clazz.cast(objectiveStatusAsString()));
        case "CandidateSteps":
            return Optional.ofNullable(clazz.cast(candidateSteps()));
        case "CandidateStatus":
            return Optional.ofNullable(clazz.cast(candidateStatusAsString()));
        case "InferenceContainers":
            return Optional.ofNullable(clazz.cast(inferenceContainers()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CandidateProperties":
            return Optional.ofNullable(clazz.cast(candidateProperties()));
        case "InferenceContainerDefinitions":
            return Optional.ofNullable(clazz.cast(inferenceContainerDefinitionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLCandidate, T> g) {
        return obj -> g.apply((AutoMLCandidate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLCandidate> {
        /**
         * <p>
         * The name of the candidate.
         * </p>
         * 
         * @param candidateName
         *        The name of the candidate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateName(String candidateName);

        /**
         * Sets the value of the FinalAutoMLJobObjectiveMetric property for this object.
         *
         * @param finalAutoMLJobObjectiveMetric
         *        The new value for the FinalAutoMLJobObjectiveMetric property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric);

        /**
         * Sets the value of the FinalAutoMLJobObjectiveMetric property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FinalAutoMLJobObjectiveMetric.Builder}
         * avoiding the need to create one manually via {@link FinalAutoMLJobObjectiveMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FinalAutoMLJobObjectiveMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric)}.
         * 
         * @param finalAutoMLJobObjectiveMetric
         *        a consumer that will call methods on {@link FinalAutoMLJobObjectiveMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric)
         */
        default Builder finalAutoMLJobObjectiveMetric(
                Consumer<FinalAutoMLJobObjectiveMetric.Builder> finalAutoMLJobObjectiveMetric) {
            return finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric.builder()
                    .applyMutation(finalAutoMLJobObjectiveMetric).build());
        }

        /**
         * <p>
         * The objective's status.
         * </p>
         * 
         * @param objectiveStatus
         *        The objective's status.
         * @see ObjectiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveStatus
         */
        Builder objectiveStatus(String objectiveStatus);

        /**
         * <p>
         * The objective's status.
         * </p>
         * 
         * @param objectiveStatus
         *        The objective's status.
         * @see ObjectiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveStatus
         */
        Builder objectiveStatus(ObjectiveStatus objectiveStatus);

        /**
         * <p>
         * Information about the candidate's steps.
         * </p>
         * 
         * @param candidateSteps
         *        Information about the candidate's steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateSteps(Collection<AutoMLCandidateStep> candidateSteps);

        /**
         * <p>
         * Information about the candidate's steps.
         * </p>
         * 
         * @param candidateSteps
         *        Information about the candidate's steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateSteps(AutoMLCandidateStep... candidateSteps);

        /**
         * <p>
         * Information about the candidate's steps.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep.Builder#build()} is called
         * immediately and its result is passed to {@link #candidateSteps(List<AutoMLCandidateStep>)}.
         * 
         * @param candidateSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateSteps(java.util.Collection<AutoMLCandidateStep>)
         */
        Builder candidateSteps(Consumer<AutoMLCandidateStep.Builder>... candidateSteps);

        /**
         * <p>
         * The candidate's status.
         * </p>
         * 
         * @param candidateStatus
         *        The candidate's status.
         * @see CandidateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStatus
         */
        Builder candidateStatus(String candidateStatus);

        /**
         * <p>
         * The candidate's status.
         * </p>
         * 
         * @param candidateStatus
         *        The candidate's status.
         * @see CandidateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CandidateStatus
         */
        Builder candidateStatus(CandidateStatus candidateStatus);

        /**
         * <p>
         * Information about the recommended inference container definitions.
         * </p>
         * 
         * @param inferenceContainers
         *        Information about the recommended inference container definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainers(Collection<AutoMLContainerDefinition> inferenceContainers);

        /**
         * <p>
         * Information about the recommended inference container definitions.
         * </p>
         * 
         * @param inferenceContainers
         *        Information about the recommended inference container definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainers(AutoMLContainerDefinition... inferenceContainers);

        /**
         * <p>
         * Information about the recommended inference container definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceContainers(List<AutoMLContainerDefinition>)}.
         * 
         * @param inferenceContainers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLContainerDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceContainers(java.util.Collection<AutoMLContainerDefinition>)
         */
        Builder inferenceContainers(Consumer<AutoMLContainerDefinition.Builder>... inferenceContainers);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The end time.
         * </p>
         * 
         * @param endTime
         *        The end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The failure reason.
         * </p>
         * 
         * @param failureReason
         *        The failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The properties of an AutoML candidate job.
         * </p>
         * 
         * @param candidateProperties
         *        The properties of an AutoML candidate job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateProperties(CandidateProperties candidateProperties);

        /**
         * <p>
         * The properties of an AutoML candidate job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CandidateProperties.Builder} avoiding the
         * need to create one manually via {@link CandidateProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CandidateProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #candidateProperties(CandidateProperties)}.
         * 
         * @param candidateProperties
         *        a consumer that will call methods on {@link CandidateProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateProperties(CandidateProperties)
         */
        default Builder candidateProperties(Consumer<CandidateProperties.Builder> candidateProperties) {
            return candidateProperties(CandidateProperties.builder().applyMutation(candidateProperties).build());
        }

        /**
         * <p>
         * The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for the
         * candidate. This field is populated for the V2 API only (for example, for jobs created by calling
         * <code>CreateAutoMLJobV2</code>).
         * </p>
         * 
         * @param inferenceContainerDefinitions
         *        The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for
         *        the candidate. This field is populated for the V2 API only (for example, for jobs created by calling
         *        <code>CreateAutoMLJobV2</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainerDefinitionsWithStrings(
                Map<String, ? extends Collection<AutoMLContainerDefinition>> inferenceContainerDefinitions);

        /**
         * <p>
         * The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for the
         * candidate. This field is populated for the V2 API only (for example, for jobs created by calling
         * <code>CreateAutoMLJobV2</code>).
         * </p>
         * 
         * @param inferenceContainerDefinitions
         *        The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for
         *        the candidate. This field is populated for the V2 API only (for example, for jobs created by calling
         *        <code>CreateAutoMLJobV2</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainerDefinitions(
                Map<AutoMLProcessingUnit, ? extends Collection<AutoMLContainerDefinition>> inferenceContainerDefinitions);
    }

    static final class BuilderImpl implements Builder {
        private String candidateName;

        private FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric;

        private String objectiveStatus;

        private List<AutoMLCandidateStep> candidateSteps = DefaultSdkAutoConstructList.getInstance();

        private String candidateStatus;

        private List<AutoMLContainerDefinition> inferenceContainers = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant endTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private CandidateProperties candidateProperties;

        private Map<String, List<AutoMLContainerDefinition>> inferenceContainerDefinitions = DefaultSdkAutoConstructMap
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLCandidate model) {
            candidateName(model.candidateName);
            finalAutoMLJobObjectiveMetric(model.finalAutoMLJobObjectiveMetric);
            objectiveStatus(model.objectiveStatus);
            candidateSteps(model.candidateSteps);
            candidateStatus(model.candidateStatus);
            inferenceContainers(model.inferenceContainers);
            creationTime(model.creationTime);
            endTime(model.endTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            candidateProperties(model.candidateProperties);
            inferenceContainerDefinitionsWithStrings(model.inferenceContainerDefinitions);
        }

        public final String getCandidateName() {
            return candidateName;
        }

        public final void setCandidateName(String candidateName) {
            this.candidateName = candidateName;
        }

        @Override
        public final Builder candidateName(String candidateName) {
            this.candidateName = candidateName;
            return this;
        }

        public final FinalAutoMLJobObjectiveMetric.Builder getFinalAutoMLJobObjectiveMetric() {
            return finalAutoMLJobObjectiveMetric != null ? finalAutoMLJobObjectiveMetric.toBuilder() : null;
        }

        public final void setFinalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric.BuilderImpl finalAutoMLJobObjectiveMetric) {
            this.finalAutoMLJobObjectiveMetric = finalAutoMLJobObjectiveMetric != null ? finalAutoMLJobObjectiveMetric.build()
                    : null;
        }

        @Override
        public final Builder finalAutoMLJobObjectiveMetric(FinalAutoMLJobObjectiveMetric finalAutoMLJobObjectiveMetric) {
            this.finalAutoMLJobObjectiveMetric = finalAutoMLJobObjectiveMetric;
            return this;
        }

        public final String getObjectiveStatus() {
            return objectiveStatus;
        }

        public final void setObjectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
        }

        @Override
        public final Builder objectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
            return this;
        }

        @Override
        public final Builder objectiveStatus(ObjectiveStatus objectiveStatus) {
            this.objectiveStatus(objectiveStatus == null ? null : objectiveStatus.toString());
            return this;
        }

        public final List<AutoMLCandidateStep.Builder> getCandidateSteps() {
            List<AutoMLCandidateStep.Builder> result = CandidateStepsCopier.copyToBuilder(this.candidateSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCandidateSteps(Collection<AutoMLCandidateStep.BuilderImpl> candidateSteps) {
            this.candidateSteps = CandidateStepsCopier.copyFromBuilder(candidateSteps);
        }

        @Override
        public final Builder candidateSteps(Collection<AutoMLCandidateStep> candidateSteps) {
            this.candidateSteps = CandidateStepsCopier.copy(candidateSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateSteps(AutoMLCandidateStep... candidateSteps) {
            candidateSteps(Arrays.asList(candidateSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateSteps(Consumer<AutoMLCandidateStep.Builder>... candidateSteps) {
            candidateSteps(Stream.of(candidateSteps).map(c -> AutoMLCandidateStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCandidateStatus() {
            return candidateStatus;
        }

        public final void setCandidateStatus(String candidateStatus) {
            this.candidateStatus = candidateStatus;
        }

        @Override
        public final Builder candidateStatus(String candidateStatus) {
            this.candidateStatus = candidateStatus;
            return this;
        }

        @Override
        public final Builder candidateStatus(CandidateStatus candidateStatus) {
            this.candidateStatus(candidateStatus == null ? null : candidateStatus.toString());
            return this;
        }

        public final List<AutoMLContainerDefinition.Builder> getInferenceContainers() {
            List<AutoMLContainerDefinition.Builder> result = AutoMLContainerDefinitionsCopier
                    .copyToBuilder(this.inferenceContainers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceContainers(Collection<AutoMLContainerDefinition.BuilderImpl> inferenceContainers) {
            this.inferenceContainers = AutoMLContainerDefinitionsCopier.copyFromBuilder(inferenceContainers);
        }

        @Override
        public final Builder inferenceContainers(Collection<AutoMLContainerDefinition> inferenceContainers) {
            this.inferenceContainers = AutoMLContainerDefinitionsCopier.copy(inferenceContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceContainers(AutoMLContainerDefinition... inferenceContainers) {
            inferenceContainers(Arrays.asList(inferenceContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceContainers(Consumer<AutoMLContainerDefinition.Builder>... inferenceContainers) {
            inferenceContainers(Stream.of(inferenceContainers)
                    .map(c -> AutoMLContainerDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final CandidateProperties.Builder getCandidateProperties() {
            return candidateProperties != null ? candidateProperties.toBuilder() : null;
        }

        public final void setCandidateProperties(CandidateProperties.BuilderImpl candidateProperties) {
            this.candidateProperties = candidateProperties != null ? candidateProperties.build() : null;
        }

        @Override
        public final Builder candidateProperties(CandidateProperties candidateProperties) {
            this.candidateProperties = candidateProperties;
            return this;
        }

        public final Map<String, List<AutoMLContainerDefinition.Builder>> getInferenceContainerDefinitions() {
            Map<String, List<AutoMLContainerDefinition.Builder>> result = AutoMLInferenceContainerDefinitionsCopier
                    .copyToBuilder(this.inferenceContainerDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInferenceContainerDefinitions(
                Map<String, ? extends Collection<AutoMLContainerDefinition.BuilderImpl>> inferenceContainerDefinitions) {
            this.inferenceContainerDefinitions = AutoMLInferenceContainerDefinitionsCopier
                    .copyFromBuilder(inferenceContainerDefinitions);
        }

        @Override
        public final Builder inferenceContainerDefinitionsWithStrings(
                Map<String, ? extends Collection<AutoMLContainerDefinition>> inferenceContainerDefinitions) {
            this.inferenceContainerDefinitions = AutoMLInferenceContainerDefinitionsCopier.copy(inferenceContainerDefinitions);
            return this;
        }

        @Override
        public final Builder inferenceContainerDefinitions(
                Map<AutoMLProcessingUnit, ? extends Collection<AutoMLContainerDefinition>> inferenceContainerDefinitions) {
            this.inferenceContainerDefinitions = AutoMLInferenceContainerDefinitionsCopier
                    .copyEnumToString(inferenceContainerDefinitions);
            return this;
        }

        @Override
        public AutoMLCandidate build() {
            return new AutoMLCandidate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
