/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of algorithms run on a dataset for training the model candidates of an Autopilot job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLAlgorithmConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLAlgorithmConfig.Builder, AutoMLAlgorithmConfig> {
    private static final SdkField<List<String>> AUTO_ML_ALGORITHMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AutoMLAlgorithms")
            .getter(getter(AutoMLAlgorithmConfig::autoMLAlgorithmsAsStrings))
            .setter(setter(Builder::autoMLAlgorithmsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLAlgorithms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_ALGORITHMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> autoMLAlgorithms;

    private AutoMLAlgorithmConfig(BuilderImpl builder) {
        this.autoMLAlgorithms = builder.autoMLAlgorithms;
    }

    /**
     * <p>
     * The selection of algorithms run on a dataset to train the model candidates of an Autopilot job.
     * </p>
     * <note>
     * <p>
     * Selected algorithms must belong to the list corresponding to the training mode set in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
     * >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a minimum of 1
     * algorithm.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * In <code>ENSEMBLING</code> mode:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "catboost"
     * </p>
     * </li>
     * <li>
     * <p>
     * "extra-trees"
     * </p>
     * </li>
     * <li>
     * <p>
     * "fastai"
     * </p>
     * </li>
     * <li>
     * <p>
     * "lightgbm"
     * </p>
     * </li>
     * <li>
     * <p>
     * "linear-learner"
     * </p>
     * </li>
     * <li>
     * <p>
     * "nn-torch"
     * </p>
     * </li>
     * <li>
     * <p>
     * "randomforest"
     * </p>
     * </li>
     * <li>
     * <p>
     * "xgboost"
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * In <code>HYPERPARAMETER_TUNING</code> mode:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "linear-learner"
     * </p>
     * </li>
     * <li>
     * <p>
     * "mlp"
     * </p>
     * </li>
     * <li>
     * <p>
     * "xgboost"
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoMLAlgorithms} method.
     * </p>
     * 
     * @return The selection of algorithms run on a dataset to train the model candidates of an Autopilot job. </p>
     *         <note>
     *         <p>
     *         Selected algorithms must belong to the list corresponding to the training mode set in <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
     *         >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a
     *         minimum of 1 algorithm.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         In <code>ENSEMBLING</code> mode:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         "catboost"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "extra-trees"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "fastai"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "lightgbm"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "linear-learner"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "nn-torch"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "randomforest"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "xgboost"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         In <code>HYPERPARAMETER_TUNING</code> mode:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         "linear-learner"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "mlp"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "xgboost"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<AutoMLAlgorithm> autoMLAlgorithms() {
        return AutoMLAlgorithmsCopier.copyStringToEnum(autoMLAlgorithms);
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoMLAlgorithms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoMLAlgorithms() {
        return autoMLAlgorithms != null && !(autoMLAlgorithms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selection of algorithms run on a dataset to train the model candidates of an Autopilot job.
     * </p>
     * <note>
     * <p>
     * Selected algorithms must belong to the list corresponding to the training mode set in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
     * >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a minimum of 1
     * algorithm.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * In <code>ENSEMBLING</code> mode:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "catboost"
     * </p>
     * </li>
     * <li>
     * <p>
     * "extra-trees"
     * </p>
     * </li>
     * <li>
     * <p>
     * "fastai"
     * </p>
     * </li>
     * <li>
     * <p>
     * "lightgbm"
     * </p>
     * </li>
     * <li>
     * <p>
     * "linear-learner"
     * </p>
     * </li>
     * <li>
     * <p>
     * "nn-torch"
     * </p>
     * </li>
     * <li>
     * <p>
     * "randomforest"
     * </p>
     * </li>
     * <li>
     * <p>
     * "xgboost"
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * In <code>HYPERPARAMETER_TUNING</code> mode:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "linear-learner"
     * </p>
     * </li>
     * <li>
     * <p>
     * "mlp"
     * </p>
     * </li>
     * <li>
     * <p>
     * "xgboost"
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoMLAlgorithms} method.
     * </p>
     * 
     * @return The selection of algorithms run on a dataset to train the model candidates of an Autopilot job. </p>
     *         <note>
     *         <p>
     *         Selected algorithms must belong to the list corresponding to the training mode set in <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
     *         >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a
     *         minimum of 1 algorithm.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         In <code>ENSEMBLING</code> mode:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         "catboost"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "extra-trees"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "fastai"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "lightgbm"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "linear-learner"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "nn-torch"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "randomforest"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "xgboost"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         In <code>HYPERPARAMETER_TUNING</code> mode:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         "linear-learner"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "mlp"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "xgboost"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<String> autoMLAlgorithmsAsStrings() {
        return autoMLAlgorithms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoMLAlgorithms() ? autoMLAlgorithmsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLAlgorithmConfig)) {
            return false;
        }
        AutoMLAlgorithmConfig other = (AutoMLAlgorithmConfig) obj;
        return hasAutoMLAlgorithms() == other.hasAutoMLAlgorithms()
                && Objects.equals(autoMLAlgorithmsAsStrings(), other.autoMLAlgorithmsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLAlgorithmConfig")
                .add("AutoMLAlgorithms", hasAutoMLAlgorithms() ? autoMLAlgorithmsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLAlgorithms":
            return Optional.ofNullable(clazz.cast(autoMLAlgorithmsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLAlgorithmConfig, T> g) {
        return obj -> g.apply((AutoMLAlgorithmConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLAlgorithmConfig> {
        /**
         * <p>
         * The selection of algorithms run on a dataset to train the model candidates of an Autopilot job.
         * </p>
         * <note>
         * <p>
         * Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         * >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a minimum
         * of 1 algorithm.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * In <code>ENSEMBLING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "catboost"
         * </p>
         * </li>
         * <li>
         * <p>
         * "extra-trees"
         * </p>
         * </li>
         * <li>
         * <p>
         * "fastai"
         * </p>
         * </li>
         * <li>
         * <p>
         * "lightgbm"
         * </p>
         * </li>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "nn-torch"
         * </p>
         * </li>
         * <li>
         * <p>
         * "randomforest"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * In <code>HYPERPARAMETER_TUNING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "mlp"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param autoMLAlgorithms
         *        The selection of algorithms run on a dataset to train the model candidates of an Autopilot job. </p>
         *        <note>
         *        <p>
         *        Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         *        >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a
         *        minimum of 1 algorithm.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        In <code>ENSEMBLING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "catboost"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "extra-trees"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "fastai"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "lightgbm"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "nn-torch"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "randomforest"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        In <code>HYPERPARAMETER_TUNING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mlp"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLAlgorithmsWithStrings(Collection<String> autoMLAlgorithms);

        /**
         * <p>
         * The selection of algorithms run on a dataset to train the model candidates of an Autopilot job.
         * </p>
         * <note>
         * <p>
         * Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         * >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a minimum
         * of 1 algorithm.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * In <code>ENSEMBLING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "catboost"
         * </p>
         * </li>
         * <li>
         * <p>
         * "extra-trees"
         * </p>
         * </li>
         * <li>
         * <p>
         * "fastai"
         * </p>
         * </li>
         * <li>
         * <p>
         * "lightgbm"
         * </p>
         * </li>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "nn-torch"
         * </p>
         * </li>
         * <li>
         * <p>
         * "randomforest"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * In <code>HYPERPARAMETER_TUNING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "mlp"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param autoMLAlgorithms
         *        The selection of algorithms run on a dataset to train the model candidates of an Autopilot job. </p>
         *        <note>
         *        <p>
         *        Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         *        >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a
         *        minimum of 1 algorithm.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        In <code>ENSEMBLING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "catboost"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "extra-trees"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "fastai"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "lightgbm"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "nn-torch"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "randomforest"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        In <code>HYPERPARAMETER_TUNING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mlp"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLAlgorithmsWithStrings(String... autoMLAlgorithms);

        /**
         * <p>
         * The selection of algorithms run on a dataset to train the model candidates of an Autopilot job.
         * </p>
         * <note>
         * <p>
         * Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         * >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a minimum
         * of 1 algorithm.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * In <code>ENSEMBLING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "catboost"
         * </p>
         * </li>
         * <li>
         * <p>
         * "extra-trees"
         * </p>
         * </li>
         * <li>
         * <p>
         * "fastai"
         * </p>
         * </li>
         * <li>
         * <p>
         * "lightgbm"
         * </p>
         * </li>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "nn-torch"
         * </p>
         * </li>
         * <li>
         * <p>
         * "randomforest"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * In <code>HYPERPARAMETER_TUNING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "mlp"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param autoMLAlgorithms
         *        The selection of algorithms run on a dataset to train the model candidates of an Autopilot job. </p>
         *        <note>
         *        <p>
         *        Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         *        >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a
         *        minimum of 1 algorithm.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        In <code>ENSEMBLING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "catboost"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "extra-trees"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "fastai"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "lightgbm"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "nn-torch"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "randomforest"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        In <code>HYPERPARAMETER_TUNING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mlp"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLAlgorithms(Collection<AutoMLAlgorithm> autoMLAlgorithms);

        /**
         * <p>
         * The selection of algorithms run on a dataset to train the model candidates of an Autopilot job.
         * </p>
         * <note>
         * <p>
         * Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         * >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a minimum
         * of 1 algorithm.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * In <code>ENSEMBLING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "catboost"
         * </p>
         * </li>
         * <li>
         * <p>
         * "extra-trees"
         * </p>
         * </li>
         * <li>
         * <p>
         * "fastai"
         * </p>
         * </li>
         * <li>
         * <p>
         * "lightgbm"
         * </p>
         * </li>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "nn-torch"
         * </p>
         * </li>
         * <li>
         * <p>
         * "randomforest"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * In <code>HYPERPARAMETER_TUNING</code> mode:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "linear-learner"
         * </p>
         * </li>
         * <li>
         * <p>
         * "mlp"
         * </p>
         * </li>
         * <li>
         * <p>
         * "xgboost"
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param autoMLAlgorithms
         *        The selection of algorithms run on a dataset to train the model candidates of an Autopilot job. </p>
         *        <note>
         *        <p>
         *        Selected algorithms must belong to the list corresponding to the training mode set in <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode"
         *        >AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a
         *        minimum of 1 algorithm.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        In <code>ENSEMBLING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "catboost"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "extra-trees"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "fastai"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "lightgbm"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "nn-torch"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "randomforest"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        In <code>HYPERPARAMETER_TUNING</code> mode:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "linear-learner"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "mlp"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "xgboost"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLAlgorithms(AutoMLAlgorithm... autoMLAlgorithms);
    }

    static final class BuilderImpl implements Builder {
        private List<String> autoMLAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLAlgorithmConfig model) {
            autoMLAlgorithmsWithStrings(model.autoMLAlgorithms);
        }

        public final Collection<String> getAutoMLAlgorithms() {
            if (autoMLAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return autoMLAlgorithms;
        }

        public final void setAutoMLAlgorithms(Collection<String> autoMLAlgorithms) {
            this.autoMLAlgorithms = AutoMLAlgorithmsCopier.copy(autoMLAlgorithms);
        }

        @Override
        public final Builder autoMLAlgorithmsWithStrings(Collection<String> autoMLAlgorithms) {
            this.autoMLAlgorithms = AutoMLAlgorithmsCopier.copy(autoMLAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLAlgorithmsWithStrings(String... autoMLAlgorithms) {
            autoMLAlgorithmsWithStrings(Arrays.asList(autoMLAlgorithms));
            return this;
        }

        @Override
        public final Builder autoMLAlgorithms(Collection<AutoMLAlgorithm> autoMLAlgorithms) {
            this.autoMLAlgorithms = AutoMLAlgorithmsCopier.copyEnumToString(autoMLAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLAlgorithms(AutoMLAlgorithm... autoMLAlgorithms) {
            autoMLAlgorithms(Arrays.asList(autoMLAlgorithms));
            return this;
        }

        @Override
        public AutoMLAlgorithmConfig build() {
            return new AutoMLAlgorithmConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
