/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AsyncInferenceConfig;
import software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig;
import software.amazon.awssdk.services.sagemaker.model.ExplainerConfig;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointConfigResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeEndpointConfigResponse> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::endpointConfigName)).setter(DescribeEndpointConfigResponse.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<String> ENDPOINT_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigArn").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::endpointConfigArn)).setter(DescribeEndpointConfigResponse.setter(Builder::endpointConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigArn").build()}).build();
    private static final SdkField<List<ProductionVariant>> PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductionVariants").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::productionVariants)).setter(DescribeEndpointConfigResponse.setter(Builder::productionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataCaptureConfig> DATA_CAPTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCaptureConfig").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::dataCaptureConfig)).setter(DescribeEndpointConfigResponse.setter(Builder::dataCaptureConfig)).constructor(DataCaptureConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::kmsKeyId)).setter(DescribeEndpointConfigResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::creationTime)).setter(DescribeEndpointConfigResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<AsyncInferenceConfig> ASYNC_INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AsyncInferenceConfig").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::asyncInferenceConfig)).setter(DescribeEndpointConfigResponse.setter(Builder::asyncInferenceConfig)).constructor(AsyncInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsyncInferenceConfig").build()}).build();
    private static final SdkField<ExplainerConfig> EXPLAINER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExplainerConfig").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::explainerConfig)).setter(DescribeEndpointConfigResponse.setter(Builder::explainerConfig)).constructor(ExplainerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainerConfig").build()}).build();
    private static final SdkField<List<ProductionVariant>> SHADOW_PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShadowProductionVariants").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::shadowProductionVariants)).setter(DescribeEndpointConfigResponse.setter(Builder::shadowProductionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::executionRoleArn)).setter(DescribeEndpointConfigResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::vpcConfig)).setter(DescribeEndpointConfigResponse.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableNetworkIsolation").getter(DescribeEndpointConfigResponse.getter(DescribeEndpointConfigResponse::enableNetworkIsolation)).setter(DescribeEndpointConfigResponse.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD, ENDPOINT_CONFIG_ARN_FIELD, PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD, KMS_KEY_ID_FIELD, CREATION_TIME_FIELD, ASYNC_INFERENCE_CONFIG_FIELD, EXPLAINER_CONFIG_FIELD, SHADOW_PRODUCTION_VARIANTS_FIELD, EXECUTION_ROLE_ARN_FIELD, VPC_CONFIG_FIELD, ENABLE_NETWORK_ISOLATION_FIELD));
    private final String endpointConfigName;
    private final String endpointConfigArn;
    private final List<ProductionVariant> productionVariants;
    private final DataCaptureConfig dataCaptureConfig;
    private final String kmsKeyId;
    private final Instant creationTime;
    private final AsyncInferenceConfig asyncInferenceConfig;
    private final ExplainerConfig explainerConfig;
    private final List<ProductionVariant> shadowProductionVariants;
    private final String executionRoleArn;
    private final VpcConfig vpcConfig;
    private final Boolean enableNetworkIsolation;

    private DescribeEndpointConfigResponse(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.endpointConfigArn = builder.endpointConfigArn;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.creationTime = builder.creationTime;
        this.asyncInferenceConfig = builder.asyncInferenceConfig;
        this.explainerConfig = builder.explainerConfig;
        this.shadowProductionVariants = builder.shadowProductionVariants;
        this.executionRoleArn = builder.executionRoleArn;
        this.vpcConfig = builder.vpcConfig;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
    }

    public final String endpointConfigName() {
        return this.endpointConfigName;
    }

    public final String endpointConfigArn() {
        return this.endpointConfigArn;
    }

    public final boolean hasProductionVariants() {
        return this.productionVariants != null && !(this.productionVariants instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariant> productionVariants() {
        return this.productionVariants;
    }

    public final DataCaptureConfig dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final AsyncInferenceConfig asyncInferenceConfig() {
        return this.asyncInferenceConfig;
    }

    public final ExplainerConfig explainerConfig() {
        return this.explainerConfig;
    }

    public final boolean hasShadowProductionVariants() {
        return this.shadowProductionVariants != null && !(this.shadowProductionVariants instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariant> shadowProductionVariants() {
        return this.shadowProductionVariants;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductionVariants() ? this.productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.asyncInferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointConfigResponse)) {
            return false;
        }
        DescribeEndpointConfigResponse other = (DescribeEndpointConfigResponse)((Object)obj);
        return Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && Objects.equals(this.endpointConfigArn(), other.endpointConfigArn()) && this.hasProductionVariants() == other.hasProductionVariants() && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.dataCaptureConfig(), other.dataCaptureConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.asyncInferenceConfig(), other.asyncInferenceConfig()) && Objects.equals(this.explainerConfig(), other.explainerConfig()) && this.hasShadowProductionVariants() == other.hasShadowProductionVariants() && Objects.equals(this.shadowProductionVariants(), other.shadowProductionVariants()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEndpointConfigResponse").add("EndpointConfigName", (Object)this.endpointConfigName()).add("EndpointConfigArn", (Object)this.endpointConfigArn()).add("ProductionVariants", this.hasProductionVariants() ? this.productionVariants() : null).add("DataCaptureConfig", (Object)this.dataCaptureConfig()).add("KmsKeyId", (Object)this.kmsKeyId()).add("CreationTime", (Object)this.creationTime()).add("AsyncInferenceConfig", (Object)this.asyncInferenceConfig()).add("ExplainerConfig", (Object)this.explainerConfig()).add("ShadowProductionVariants", this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("VpcConfig", (Object)this.vpcConfig()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "EndpointConfigArn": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigArn()));
            }
            case "ProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.productionVariants()));
            }
            case "DataCaptureConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCaptureConfig()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "AsyncInferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.asyncInferenceConfig()));
            }
            case "ExplainerConfig": {
                return Optional.ofNullable(clazz.cast(this.explainerConfig()));
            }
            case "ShadowProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.shadowProductionVariants()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointConfigResponse, T> g) {
        return obj -> g.apply((DescribeEndpointConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String endpointConfigName;
        private String endpointConfigArn;
        private List<ProductionVariant> productionVariants = DefaultSdkAutoConstructList.getInstance();
        private DataCaptureConfig dataCaptureConfig;
        private String kmsKeyId;
        private Instant creationTime;
        private AsyncInferenceConfig asyncInferenceConfig;
        private ExplainerConfig explainerConfig;
        private List<ProductionVariant> shadowProductionVariants = DefaultSdkAutoConstructList.getInstance();
        private String executionRoleArn;
        private VpcConfig vpcConfig;
        private Boolean enableNetworkIsolation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointConfigResponse model) {
            super(model);
            this.endpointConfigName(model.endpointConfigName);
            this.endpointConfigArn(model.endpointConfigArn);
            this.productionVariants(model.productionVariants);
            this.dataCaptureConfig(model.dataCaptureConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.creationTime(model.creationTime);
            this.asyncInferenceConfig(model.asyncInferenceConfig);
            this.explainerConfig(model.explainerConfig);
            this.shadowProductionVariants(model.shadowProductionVariants);
            this.executionRoleArn(model.executionRoleArn);
            this.vpcConfig(model.vpcConfig);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final String getEndpointConfigArn() {
            return this.endpointConfigArn;
        }

        public final void setEndpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
        }

        @Override
        public final Builder endpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
            return this;
        }

        public final List<ProductionVariant.Builder> getProductionVariants() {
            List<ProductionVariant.Builder> result = ProductionVariantListCopier.copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariant.Builder> ... productionVariants) {
            this.productionVariants(Stream.of(productionVariants).map(c -> (ProductionVariant)((ProductionVariant.Builder)ProductionVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataCaptureConfig.Builder getDataCaptureConfig() {
            return this.dataCaptureConfig != null ? this.dataCaptureConfig.toBuilder() : null;
        }

        public final void setDataCaptureConfig(DataCaptureConfig.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        @Override
        public final Builder dataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final AsyncInferenceConfig.Builder getAsyncInferenceConfig() {
            return this.asyncInferenceConfig != null ? this.asyncInferenceConfig.toBuilder() : null;
        }

        public final void setAsyncInferenceConfig(AsyncInferenceConfig.BuilderImpl asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig != null ? asyncInferenceConfig.build() : null;
        }

        @Override
        public final Builder asyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
            this.asyncInferenceConfig = asyncInferenceConfig;
            return this;
        }

        public final ExplainerConfig.Builder getExplainerConfig() {
            return this.explainerConfig != null ? this.explainerConfig.toBuilder() : null;
        }

        public final void setExplainerConfig(ExplainerConfig.BuilderImpl explainerConfig) {
            this.explainerConfig = explainerConfig != null ? explainerConfig.build() : null;
        }

        @Override
        public final Builder explainerConfig(ExplainerConfig explainerConfig) {
            this.explainerConfig = explainerConfig;
            return this;
        }

        public final List<ProductionVariant.Builder> getShadowProductionVariants() {
            List<ProductionVariant.Builder> result = ProductionVariantListCopier.copyToBuilder(this.shadowProductionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShadowProductionVariants(Collection<ProductionVariant.BuilderImpl> shadowProductionVariants) {
            this.shadowProductionVariants = ProductionVariantListCopier.copyFromBuilder(shadowProductionVariants);
        }

        @Override
        public final Builder shadowProductionVariants(Collection<ProductionVariant> shadowProductionVariants) {
            this.shadowProductionVariants = ProductionVariantListCopier.copy(shadowProductionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(ProductionVariant ... shadowProductionVariants) {
            this.shadowProductionVariants(Arrays.asList(shadowProductionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(Consumer<ProductionVariant.Builder> ... shadowProductionVariants) {
            this.shadowProductionVariants(Stream.of(shadowProductionVariants).map(c -> (ProductionVariant)((ProductionVariant.Builder)ProductionVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        @Override
        public DescribeEndpointConfigResponse build() {
            return new DescribeEndpointConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointConfigResponse> {
        public Builder endpointConfigName(String var1);

        public Builder endpointConfigArn(String var1);

        public Builder productionVariants(Collection<ProductionVariant> var1);

        public Builder productionVariants(ProductionVariant ... var1);

        public Builder productionVariants(Consumer<ProductionVariant.Builder> ... var1);

        public Builder dataCaptureConfig(DataCaptureConfig var1);

        default public Builder dataCaptureConfig(Consumer<DataCaptureConfig.Builder> dataCaptureConfig) {
            return this.dataCaptureConfig((DataCaptureConfig)((DataCaptureConfig.Builder)DataCaptureConfig.builder().applyMutation(dataCaptureConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder creationTime(Instant var1);

        public Builder asyncInferenceConfig(AsyncInferenceConfig var1);

        default public Builder asyncInferenceConfig(Consumer<AsyncInferenceConfig.Builder> asyncInferenceConfig) {
            return this.asyncInferenceConfig((AsyncInferenceConfig)((AsyncInferenceConfig.Builder)AsyncInferenceConfig.builder().applyMutation(asyncInferenceConfig)).build());
        }

        public Builder explainerConfig(ExplainerConfig var1);

        default public Builder explainerConfig(Consumer<ExplainerConfig.Builder> explainerConfig) {
            return this.explainerConfig((ExplainerConfig)((ExplainerConfig.Builder)ExplainerConfig.builder().applyMutation(explainerConfig)).build());
        }

        public Builder shadowProductionVariants(Collection<ProductionVariant> var1);

        public Builder shadowProductionVariants(ProductionVariant ... var1);

        public Builder shadowProductionVariants(Consumer<ProductionVariant.Builder> ... var1);

        public Builder executionRoleArn(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder enableNetworkIsolation(Boolean var1);
    }
}

