/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists a summary of the properties of a SageMaker HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSummary implements SdkPojo, Serializable, ToCopyableBuilder<ClusterSummary.Builder, ClusterSummary> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ClusterSummary::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(ClusterSummary::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ClusterSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterStatus").getter(getter(ClusterSummary::clusterStatusAsString))
            .setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_NAME_FIELD, CREATION_TIME_FIELD, CLUSTER_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final String clusterName;

    private final Instant creationTime;

    private final String clusterStatus;

    private ClusterSummary(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.clusterStatus = builder.clusterStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The name of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The name of the SageMaker HyperPod cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The time when the SageMaker HyperPod cluster is created.
     * </p>
     * 
     * @return The time when the SageMaker HyperPod cluster is created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The status of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker HyperPod cluster.
     * @see ClusterStatus
     */
    public final ClusterStatus clusterStatus() {
        return ClusterStatus.fromValue(clusterStatus);
    }

    /**
     * <p>
     * The status of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker HyperPod cluster.
     * @see ClusterStatus
     */
    public final String clusterStatusAsString() {
        return clusterStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSummary)) {
            return false;
        }
        ClusterSummary other = (ClusterSummary) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(clusterStatusAsString(), other.clusterStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterSummary").add("ClusterArn", clusterArn()).add("ClusterName", clusterName())
                .add("CreationTime", creationTime()).add("ClusterStatus", clusterStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ClusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSummary, T> g) {
        return obj -> g.apply((ClusterSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The name of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The time when the SageMaker HyperPod cluster is created.
         * </p>
         * 
         * @param creationTime
         *        The time when the SageMaker HyperPod cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The status of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterStatus
         *        The status of the SageMaker HyperPod cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The status of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterStatus
         *        The status of the SageMaker HyperPod cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(ClusterStatus clusterStatus);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private String clusterName;

        private Instant creationTime;

        private String clusterStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSummary model) {
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            creationTime(model.creationTime);
            clusterStatus(model.clusterStatus);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(ClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        @Override
        public ClusterSummary build() {
            return new ClusterSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
