/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the Amazon SageMaker Studio Lifecycle Configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StudioLifecycleConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StudioLifecycleConfigDetails.Builder, StudioLifecycleConfigDetails> {
    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigArn").getter(getter(StudioLifecycleConfigDetails::studioLifecycleConfigArn))
            .setter(setter(Builder::studioLifecycleConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigArn").build())
            .build();

    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigName").getter(getter(StudioLifecycleConfigDetails::studioLifecycleConfigName))
            .setter(setter(Builder::studioLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(StudioLifecycleConfigDetails::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(StudioLifecycleConfigDetails::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_APP_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigAppType")
            .getter(getter(StudioLifecycleConfigDetails::studioLifecycleConfigAppTypeAsString))
            .setter(setter(Builder::studioLifecycleConfigAppType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigAppType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STUDIO_LIFECYCLE_CONFIG_ARN_FIELD, STUDIO_LIFECYCLE_CONFIG_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            STUDIO_LIFECYCLE_CONFIG_APP_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String studioLifecycleConfigArn;

    private final String studioLifecycleConfigName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String studioLifecycleConfigAppType;

    private StudioLifecycleConfigDetails(BuilderImpl builder) {
        this.studioLifecycleConfigArn = builder.studioLifecycleConfigArn;
        this.studioLifecycleConfigName = builder.studioLifecycleConfigName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.studioLifecycleConfigAppType = builder.studioLifecycleConfigAppType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lifecycle Configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lifecycle Configuration.
     */
    public final String studioLifecycleConfigArn() {
        return studioLifecycleConfigArn;
    }

    /**
     * <p>
     * The name of the Amazon SageMaker Studio Lifecycle Configuration.
     * </p>
     * 
     * @return The name of the Amazon SageMaker Studio Lifecycle Configuration.
     */
    public final String studioLifecycleConfigName() {
        return studioLifecycleConfigName;
    }

    /**
     * <p>
     * The creation time of the Amazon SageMaker Studio Lifecycle Configuration.
     * </p>
     * 
     * @return The creation time of the Amazon SageMaker Studio Lifecycle Configuration.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * This value is equivalent to CreationTime because Amazon SageMaker Studio Lifecycle Configurations are immutable.
     * </p>
     * 
     * @return This value is equivalent to CreationTime because Amazon SageMaker Studio Lifecycle Configurations are
     *         immutable.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The App type to which the Lifecycle Configuration is attached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioLifecycleConfigAppType} will return {@link StudioLifecycleConfigAppType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #studioLifecycleConfigAppTypeAsString}.
     * </p>
     * 
     * @return The App type to which the Lifecycle Configuration is attached.
     * @see StudioLifecycleConfigAppType
     */
    public final StudioLifecycleConfigAppType studioLifecycleConfigAppType() {
        return StudioLifecycleConfigAppType.fromValue(studioLifecycleConfigAppType);
    }

    /**
     * <p>
     * The App type to which the Lifecycle Configuration is attached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioLifecycleConfigAppType} will return {@link StudioLifecycleConfigAppType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #studioLifecycleConfigAppTypeAsString}.
     * </p>
     * 
     * @return The App type to which the Lifecycle Configuration is attached.
     * @see StudioLifecycleConfigAppType
     */
    public final String studioLifecycleConfigAppTypeAsString() {
        return studioLifecycleConfigAppType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigAppTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioLifecycleConfigDetails)) {
            return false;
        }
        StudioLifecycleConfigDetails other = (StudioLifecycleConfigDetails) obj;
        return Objects.equals(studioLifecycleConfigArn(), other.studioLifecycleConfigArn())
                && Objects.equals(studioLifecycleConfigName(), other.studioLifecycleConfigName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(studioLifecycleConfigAppTypeAsString(), other.studioLifecycleConfigAppTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StudioLifecycleConfigDetails").add("StudioLifecycleConfigArn", studioLifecycleConfigArn())
                .add("StudioLifecycleConfigName", studioLifecycleConfigName()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime())
                .add("StudioLifecycleConfigAppType", studioLifecycleConfigAppTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioLifecycleConfigArn":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigArn()));
        case "StudioLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "StudioLifecycleConfigAppType":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigAppTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioLifecycleConfigDetails, T> g) {
        return obj -> g.apply((StudioLifecycleConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StudioLifecycleConfigDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lifecycle Configuration.
         * </p>
         * 
         * @param studioLifecycleConfigArn
         *        The Amazon Resource Name (ARN) of the Lifecycle Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigArn(String studioLifecycleConfigArn);

        /**
         * <p>
         * The name of the Amazon SageMaker Studio Lifecycle Configuration.
         * </p>
         * 
         * @param studioLifecycleConfigName
         *        The name of the Amazon SageMaker Studio Lifecycle Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigName(String studioLifecycleConfigName);

        /**
         * <p>
         * The creation time of the Amazon SageMaker Studio Lifecycle Configuration.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the Amazon SageMaker Studio Lifecycle Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * This value is equivalent to CreationTime because Amazon SageMaker Studio Lifecycle Configurations are
         * immutable.
         * </p>
         * 
         * @param lastModifiedTime
         *        This value is equivalent to CreationTime because Amazon SageMaker Studio Lifecycle Configurations are
         *        immutable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The App type to which the Lifecycle Configuration is attached.
         * </p>
         * 
         * @param studioLifecycleConfigAppType
         *        The App type to which the Lifecycle Configuration is attached.
         * @see StudioLifecycleConfigAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioLifecycleConfigAppType
         */
        Builder studioLifecycleConfigAppType(String studioLifecycleConfigAppType);

        /**
         * <p>
         * The App type to which the Lifecycle Configuration is attached.
         * </p>
         * 
         * @param studioLifecycleConfigAppType
         *        The App type to which the Lifecycle Configuration is attached.
         * @see StudioLifecycleConfigAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioLifecycleConfigAppType
         */
        Builder studioLifecycleConfigAppType(StudioLifecycleConfigAppType studioLifecycleConfigAppType);
    }

    static final class BuilderImpl implements Builder {
        private String studioLifecycleConfigArn;

        private String studioLifecycleConfigName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String studioLifecycleConfigAppType;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioLifecycleConfigDetails model) {
            studioLifecycleConfigArn(model.studioLifecycleConfigArn);
            studioLifecycleConfigName(model.studioLifecycleConfigName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            studioLifecycleConfigAppType(model.studioLifecycleConfigAppType);
        }

        public final String getStudioLifecycleConfigArn() {
            return studioLifecycleConfigArn;
        }

        public final void setStudioLifecycleConfigArn(String studioLifecycleConfigArn) {
            this.studioLifecycleConfigArn = studioLifecycleConfigArn;
        }

        @Override
        public final Builder studioLifecycleConfigArn(String studioLifecycleConfigArn) {
            this.studioLifecycleConfigArn = studioLifecycleConfigArn;
            return this;
        }

        public final String getStudioLifecycleConfigName() {
            return studioLifecycleConfigName;
        }

        public final void setStudioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
        }

        @Override
        public final Builder studioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStudioLifecycleConfigAppType() {
            return studioLifecycleConfigAppType;
        }

        public final void setStudioLifecycleConfigAppType(String studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType = studioLifecycleConfigAppType;
        }

        @Override
        public final Builder studioLifecycleConfigAppType(String studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType = studioLifecycleConfigAppType;
            return this;
        }

        @Override
        public final Builder studioLifecycleConfigAppType(StudioLifecycleConfigAppType studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType(studioLifecycleConfigAppType == null ? null : studioLifecycleConfigAppType
                    .toString());
            return this;
        }

        @Override
        public StudioLifecycleConfigDetails build() {
            return new StudioLifecycleConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
