/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an instance (also called a <i>node</i> interchangeably) in a SageMaker HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterNodeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterNodeDetails.Builder, ClusterNodeDetails> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(ClusterNodeDetails::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ClusterNodeDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<ClusterInstanceStatusDetails> INSTANCE_STATUS_FIELD = SdkField
            .<ClusterInstanceStatusDetails> builder(MarshallingType.SDK_POJO).memberName("InstanceStatus")
            .getter(getter(ClusterNodeDetails::instanceStatus)).setter(setter(Builder::instanceStatus))
            .constructor(ClusterInstanceStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ClusterNodeDetails::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchTime").getter(getter(ClusterNodeDetails::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()).build();

    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField
            .<ClusterLifeCycleConfig> builder(MarshallingType.SDK_POJO).memberName("LifeCycleConfig")
            .getter(getter(ClusterNodeDetails::lifeCycleConfig)).setter(setter(Builder::lifeCycleConfig))
            .constructor(ClusterLifeCycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore").getter(getter(ClusterNodeDetails::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD,
            INSTANCE_ID_FIELD, INSTANCE_STATUS_FIELD, INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, LIFE_CYCLE_CONFIG_FIELD,
            THREADS_PER_CORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceGroupName;

    private final String instanceId;

    private final ClusterInstanceStatusDetails instanceStatus;

    private final String instanceType;

    private final Instant launchTime;

    private final ClusterLifeCycleConfig lifeCycleConfig;

    private final Integer threadsPerCore;

    private ClusterNodeDetails(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceId = builder.instanceId;
        this.instanceStatus = builder.instanceStatus;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.threadsPerCore = builder.threadsPerCore;
    }

    /**
     * <p>
     * The instance group name in which the instance is.
     * </p>
     * 
     * @return The instance group name in which the instance is.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The status of the instance.
     * </p>
     * 
     * @return The status of the instance.
     */
    public final ClusterInstanceStatusDetails instanceStatus() {
        return instanceStatus;
    }

    /**
     * <p>
     * The type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of the instance.
     * @see ClusterInstanceType
     */
    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of the instance.
     * @see ClusterInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The time when the instance is launched.
     * </p>
     * 
     * @return The time when the instance is launched.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The LifeCycle configuration applied to the instance.
     * </p>
     * 
     * @return The LifeCycle configuration applied to the instance.
     */
    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return lifeCycleConfig;
    }

    /**
     * <p>
     * The number of threads per CPU core you specified under <code>CreateCluster</code>.
     * </p>
     * 
     * @return The number of threads per CPU core you specified under <code>CreateCluster</code>.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNodeDetails)) {
            return false;
        }
        ClusterNodeDetails other = (ClusterNodeDetails) obj;
        return Objects.equals(instanceGroupName(), other.instanceGroupName()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceStatus(), other.instanceStatus())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(launchTime(), other.launchTime()) && Objects.equals(lifeCycleConfig(), other.lifeCycleConfig())
                && Objects.equals(threadsPerCore(), other.threadsPerCore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterNodeDetails").add("InstanceGroupName", instanceGroupName())
                .add("InstanceId", instanceId()).add("InstanceStatus", instanceStatus())
                .add("InstanceType", instanceTypeAsString()).add("LaunchTime", launchTime())
                .add("LifeCycleConfig", lifeCycleConfig()).add("ThreadsPerCore", threadsPerCore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceStatus":
            return Optional.ofNullable(clazz.cast(instanceStatus()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "LifeCycleConfig":
            return Optional.ofNullable(clazz.cast(lifeCycleConfig()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterNodeDetails, T> g) {
        return obj -> g.apply((ClusterNodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterNodeDetails> {
        /**
         * <p>
         * The instance group name in which the instance is.
         * </p>
         * 
         * @param instanceGroupName
         *        The instance group name in which the instance is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * 
         * @param instanceStatus
         *        The status of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterInstanceStatusDetails.Builder}
         * avoiding the need to create one manually via {@link ClusterInstanceStatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterInstanceStatusDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceStatus(ClusterInstanceStatusDetails)}.
         * 
         * @param instanceStatus
         *        a consumer that will call methods on {@link ClusterInstanceStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStatus(ClusterInstanceStatusDetails)
         */
        default Builder instanceStatus(Consumer<ClusterInstanceStatusDetails.Builder> instanceStatus) {
            return instanceStatus(ClusterInstanceStatusDetails.builder().applyMutation(instanceStatus).build());
        }

        /**
         * <p>
         * The type of the instance.
         * </p>
         * 
         * @param instanceType
         *        The type of the instance.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of the instance.
         * </p>
         * 
         * @param instanceType
         *        The type of the instance.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(ClusterInstanceType instanceType);

        /**
         * <p>
         * The time when the instance is launched.
         * </p>
         * 
         * @param launchTime
         *        The time when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The LifeCycle configuration applied to the instance.
         * </p>
         * 
         * @param lifeCycleConfig
         *        The LifeCycle configuration applied to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig);

        /**
         * <p>
         * The LifeCycle configuration applied to the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterLifeCycleConfig.Builder} avoiding
         * the need to create one manually via {@link ClusterLifeCycleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterLifeCycleConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lifeCycleConfig(ClusterLifeCycleConfig)}.
         * 
         * @param lifeCycleConfig
         *        a consumer that will call methods on {@link ClusterLifeCycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycleConfig(ClusterLifeCycleConfig)
         */
        default Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return lifeCycleConfig(ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig).build());
        }

        /**
         * <p>
         * The number of threads per CPU core you specified under <code>CreateCluster</code>.
         * </p>
         * 
         * @param threadsPerCore
         *        The number of threads per CPU core you specified under <code>CreateCluster</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);
    }

    static final class BuilderImpl implements Builder {
        private String instanceGroupName;

        private String instanceId;

        private ClusterInstanceStatusDetails instanceStatus;

        private String instanceType;

        private Instant launchTime;

        private ClusterLifeCycleConfig lifeCycleConfig;

        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNodeDetails model) {
            instanceGroupName(model.instanceGroupName);
            instanceId(model.instanceId);
            instanceStatus(model.instanceStatus);
            instanceType(model.instanceType);
            launchTime(model.launchTime);
            lifeCycleConfig(model.lifeCycleConfig);
            threadsPerCore(model.threadsPerCore);
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final ClusterInstanceStatusDetails.Builder getInstanceStatus() {
            return instanceStatus != null ? instanceStatus.toBuilder() : null;
        }

        public final void setInstanceStatus(ClusterInstanceStatusDetails.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        @Override
        public final Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return lifeCycleConfig != null ? lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        @Override
        public ClusterNodeDetails build() {
            return new ClusterNodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
