/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.waiters.SageMakerAsyncWaiter;
import software.amazon.awssdk.services.sagemaker.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultSageMakerAsyncWaiter
implements SageMakerAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final SageMakerAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeNotebookInstanceResponse> notebookInstanceInServiceWaiter;
    private final AsyncWaiter<DescribeNotebookInstanceResponse> notebookInstanceStoppedWaiter;
    private final AsyncWaiter<DescribeNotebookInstanceResponse> notebookInstanceDeletedWaiter;
    private final AsyncWaiter<DescribeTrainingJobResponse> trainingJobCompletedOrStoppedWaiter;
    private final AsyncWaiter<DescribeEndpointResponse> endpointInServiceWaiter;
    private final AsyncWaiter<DescribeEndpointResponse> endpointDeletedWaiter;
    private final AsyncWaiter<DescribeTransformJobResponse> transformJobCompletedOrStoppedWaiter;
    private final AsyncWaiter<DescribeProcessingJobResponse> processingJobCompletedOrStoppedWaiter;
    private final AsyncWaiter<DescribeImageResponse> imageCreatedWaiter;
    private final AsyncWaiter<DescribeImageResponse> imageUpdatedWaiter;
    private final AsyncWaiter<DescribeImageResponse> imageDeletedWaiter;
    private final AsyncWaiter<DescribeImageVersionResponse> imageVersionCreatedWaiter;
    private final AsyncWaiter<DescribeImageVersionResponse> imageVersionDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultSageMakerAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (SageMakerAsyncClient)SageMakerAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.notebookInstanceInServiceWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNotebookInstanceResponse.class).acceptors(DefaultSageMakerAsyncWaiter.notebookInstanceInServiceWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.notebookInstanceInServiceWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.notebookInstanceStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNotebookInstanceResponse.class).acceptors(DefaultSageMakerAsyncWaiter.notebookInstanceStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.notebookInstanceStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.notebookInstanceDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNotebookInstanceResponse.class).acceptors(DefaultSageMakerAsyncWaiter.notebookInstanceDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.notebookInstanceDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.trainingJobCompletedOrStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeTrainingJobResponse.class).acceptors(DefaultSageMakerAsyncWaiter.trainingJobCompletedOrStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.trainingJobCompletedOrStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.endpointInServiceWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeEndpointResponse.class).acceptors(DefaultSageMakerAsyncWaiter.endpointInServiceWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.endpointInServiceWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.endpointDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeEndpointResponse.class).acceptors(DefaultSageMakerAsyncWaiter.endpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.endpointDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.transformJobCompletedOrStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeTransformJobResponse.class).acceptors(DefaultSageMakerAsyncWaiter.transformJobCompletedOrStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.transformJobCompletedOrStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.processingJobCompletedOrStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeProcessingJobResponse.class).acceptors(DefaultSageMakerAsyncWaiter.processingJobCompletedOrStoppedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.processingJobCompletedOrStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.imageCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImageResponse.class).acceptors(DefaultSageMakerAsyncWaiter.imageCreatedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.imageCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.imageUpdatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImageResponse.class).acceptors(DefaultSageMakerAsyncWaiter.imageUpdatedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.imageUpdatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.imageDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImageResponse.class).acceptors(DefaultSageMakerAsyncWaiter.imageDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.imageDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.imageVersionCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImageVersionResponse.class).acceptors(DefaultSageMakerAsyncWaiter.imageVersionCreatedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.imageVersionCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.imageVersionDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImageVersionResponse.class).acceptors(DefaultSageMakerAsyncWaiter.imageVersionDeletedWaiterAcceptors())).overrideConfiguration(DefaultSageMakerAsyncWaiter.imageVersionDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEndpointResponse>> waitUntilEndpointDeleted(DescribeEndpointRequest describeEndpointRequest) {
        return this.endpointDeletedWaiter.runAsync(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEndpointResponse>> waitUntilEndpointDeleted(DescribeEndpointRequest describeEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.endpointDeletedWaiter.runAsync(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)), DefaultSageMakerAsyncWaiter.endpointDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEndpointResponse>> waitUntilEndpointInService(DescribeEndpointRequest describeEndpointRequest) {
        return this.endpointInServiceWaiter.runAsync(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEndpointResponse>> waitUntilEndpointInService(DescribeEndpointRequest describeEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.endpointInServiceWaiter.runAsync(() -> this.client.describeEndpoint(this.applyWaitersUserAgent(describeEndpointRequest)), DefaultSageMakerAsyncWaiter.endpointInServiceWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageResponse>> waitUntilImageCreated(DescribeImageRequest describeImageRequest) {
        return this.imageCreatedWaiter.runAsync(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageResponse>> waitUntilImageCreated(DescribeImageRequest describeImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageCreatedWaiter.runAsync(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)), DefaultSageMakerAsyncWaiter.imageCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageResponse>> waitUntilImageDeleted(DescribeImageRequest describeImageRequest) {
        return this.imageDeletedWaiter.runAsync(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageResponse>> waitUntilImageDeleted(DescribeImageRequest describeImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageDeletedWaiter.runAsync(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)), DefaultSageMakerAsyncWaiter.imageDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageResponse>> waitUntilImageUpdated(DescribeImageRequest describeImageRequest) {
        return this.imageUpdatedWaiter.runAsync(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageResponse>> waitUntilImageUpdated(DescribeImageRequest describeImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageUpdatedWaiter.runAsync(() -> this.client.describeImage(this.applyWaitersUserAgent(describeImageRequest)), DefaultSageMakerAsyncWaiter.imageUpdatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageVersionResponse>> waitUntilImageVersionCreated(DescribeImageVersionRequest describeImageVersionRequest) {
        return this.imageVersionCreatedWaiter.runAsync(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageVersionResponse>> waitUntilImageVersionCreated(DescribeImageVersionRequest describeImageVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageVersionCreatedWaiter.runAsync(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)), DefaultSageMakerAsyncWaiter.imageVersionCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageVersionResponse>> waitUntilImageVersionDeleted(DescribeImageVersionRequest describeImageVersionRequest) {
        return this.imageVersionDeletedWaiter.runAsync(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageVersionResponse>> waitUntilImageVersionDeleted(DescribeImageVersionRequest describeImageVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageVersionDeletedWaiter.runAsync(() -> this.client.describeImageVersion(this.applyWaitersUserAgent(describeImageVersionRequest)), DefaultSageMakerAsyncWaiter.imageVersionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNotebookInstanceResponse>> waitUntilNotebookInstanceDeleted(DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        return this.notebookInstanceDeletedWaiter.runAsync(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNotebookInstanceResponse>> waitUntilNotebookInstanceDeleted(DescribeNotebookInstanceRequest describeNotebookInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.notebookInstanceDeletedWaiter.runAsync(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)), DefaultSageMakerAsyncWaiter.notebookInstanceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNotebookInstanceResponse>> waitUntilNotebookInstanceInService(DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        return this.notebookInstanceInServiceWaiter.runAsync(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNotebookInstanceResponse>> waitUntilNotebookInstanceInService(DescribeNotebookInstanceRequest describeNotebookInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.notebookInstanceInServiceWaiter.runAsync(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)), DefaultSageMakerAsyncWaiter.notebookInstanceInServiceWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNotebookInstanceResponse>> waitUntilNotebookInstanceStopped(DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        return this.notebookInstanceStoppedWaiter.runAsync(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNotebookInstanceResponse>> waitUntilNotebookInstanceStopped(DescribeNotebookInstanceRequest describeNotebookInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.notebookInstanceStoppedWaiter.runAsync(() -> this.client.describeNotebookInstance(this.applyWaitersUserAgent(describeNotebookInstanceRequest)), DefaultSageMakerAsyncWaiter.notebookInstanceStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeProcessingJobResponse>> waitUntilProcessingJobCompletedOrStopped(DescribeProcessingJobRequest describeProcessingJobRequest) {
        return this.processingJobCompletedOrStoppedWaiter.runAsync(() -> this.client.describeProcessingJob(this.applyWaitersUserAgent(describeProcessingJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeProcessingJobResponse>> waitUntilProcessingJobCompletedOrStopped(DescribeProcessingJobRequest describeProcessingJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.processingJobCompletedOrStoppedWaiter.runAsync(() -> this.client.describeProcessingJob(this.applyWaitersUserAgent(describeProcessingJobRequest)), DefaultSageMakerAsyncWaiter.processingJobCompletedOrStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTrainingJobResponse>> waitUntilTrainingJobCompletedOrStopped(DescribeTrainingJobRequest describeTrainingJobRequest) {
        return this.trainingJobCompletedOrStoppedWaiter.runAsync(() -> this.client.describeTrainingJob(this.applyWaitersUserAgent(describeTrainingJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTrainingJobResponse>> waitUntilTrainingJobCompletedOrStopped(DescribeTrainingJobRequest describeTrainingJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.trainingJobCompletedOrStoppedWaiter.runAsync(() -> this.client.describeTrainingJob(this.applyWaitersUserAgent(describeTrainingJobRequest)), DefaultSageMakerAsyncWaiter.trainingJobCompletedOrStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTransformJobResponse>> waitUntilTransformJobCompletedOrStopped(DescribeTransformJobRequest describeTransformJobRequest) {
        return this.transformJobCompletedOrStoppedWaiter.runAsync(() -> this.client.describeTransformJob(this.applyWaitersUserAgent(describeTransformJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTransformJobResponse>> waitUntilTransformJobCompletedOrStopped(DescribeTransformJobRequest describeTransformJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.transformJobCompletedOrStoppedWaiter.runAsync(() -> this.client.describeTransformJob(this.applyWaitersUserAgent(describeTransformJobRequest)), DefaultSageMakerAsyncWaiter.transformJobCompletedOrStoppedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> notebookInstanceInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "InService");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> notebookInstanceStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> notebookInstanceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNotebookInstanceResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("NotebookInstanceStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTrainingJobResponse>> trainingJobCompletedOrStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTrainingJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTrainingJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TrainingJobStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TrainingJobStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TrainingJobStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEndpointResponse>> endpointInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("EndpointStatus").value(), "InService");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("EndpointStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEndpointResponse>> endpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEndpointResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("EndpointStatus").value(), "Failed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTransformJobResponse>> transformJobCompletedOrStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTransformJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTransformJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TransformJobStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TransformJobStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TransformJobStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeProcessingJobResponse>> processingJobCompletedOrStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeProcessingJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeProcessingJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ProcessingJobStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ProcessingJobStatus").value(), "Stopped");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ProcessingJobStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageResponse>> imageCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageResponse>> imageUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "UPDATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageResponse>> imageDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageStatus").value(), "DELETE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageVersionResponse>> imageVersionCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageVersionStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageVersionStatus").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImageVersionResponse>> imageVersionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageVersionResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("ImageVersionStatus").value(), "DELETE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultSageMakerAsyncWaiter.errorCode(error), "ValidationException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration notebookInstanceInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration notebookInstanceStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration notebookInstanceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration trainingJobCompletedOrStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration endpointInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration endpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration transformJobCompletedOrStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration processingJobCompletedOrStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageVersionCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageVersionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static SageMakerAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends SageMakerRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SageMakerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements SageMakerAsyncWaiter.Builder {
        private SageMakerAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public SageMakerAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public SageMakerAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public SageMakerAsyncWaiter.Builder client(SageMakerAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public SageMakerAsyncWaiter build() {
            return new DefaultSageMakerAsyncWaiter(this);
        }
    }
}

