/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelCardVersionsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListModelCardVersionsResponse.Builder, ListModelCardVersionsResponse> {
    private static final SdkField<List<ModelCardVersionSummary>> MODEL_CARD_VERSION_SUMMARY_LIST_FIELD = SdkField
            .<List<ModelCardVersionSummary>> builder(MarshallingType.LIST)
            .memberName("ModelCardVersionSummaryList")
            .getter(getter(ListModelCardVersionsResponse::modelCardVersionSummaryList))
            .setter(setter(Builder::modelCardVersionSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersionSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelCardVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelCardVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelCardVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_CARD_VERSION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ModelCardVersionSummary> modelCardVersionSummaryList;

    private final String nextToken;

    private ListModelCardVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardVersionSummaryList = builder.modelCardVersionSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelCardVersionSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelCardVersionSummaryList() {
        return modelCardVersionSummaryList != null && !(modelCardVersionSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of the listed versions of the model card.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelCardVersionSummaryList} method.
     * </p>
     * 
     * @return The summaries of the listed versions of the model card.
     */
    public final List<ModelCardVersionSummary> modelCardVersionSummaryList() {
        return modelCardVersionSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of model card versions, use
     * it in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of model card
     *         versions, use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelCardVersionSummaryList() ? modelCardVersionSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCardVersionsResponse)) {
            return false;
        }
        ListModelCardVersionsResponse other = (ListModelCardVersionsResponse) obj;
        return hasModelCardVersionSummaryList() == other.hasModelCardVersionSummaryList()
                && Objects.equals(modelCardVersionSummaryList(), other.modelCardVersionSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelCardVersionsResponse")
                .add("ModelCardVersionSummaryList", hasModelCardVersionSummaryList() ? modelCardVersionSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardVersionSummaryList":
            return Optional.ofNullable(clazz.cast(modelCardVersionSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelCardVersionsResponse, T> g) {
        return obj -> g.apply((ListModelCardVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListModelCardVersionsResponse> {
        /**
         * <p>
         * The summaries of the listed versions of the model card.
         * </p>
         * 
         * @param modelCardVersionSummaryList
         *        The summaries of the listed versions of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersionSummaryList(Collection<ModelCardVersionSummary> modelCardVersionSummaryList);

        /**
         * <p>
         * The summaries of the listed versions of the model card.
         * </p>
         * 
         * @param modelCardVersionSummaryList
         *        The summaries of the listed versions of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersionSummaryList(ModelCardVersionSummary... modelCardVersionSummaryList);

        /**
         * <p>
         * The summaries of the listed versions of the model card.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelCardVersionSummaryList(List<ModelCardVersionSummary>)}.
         * 
         * @param modelCardVersionSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelCardVersionSummaryList(java.util.Collection<ModelCardVersionSummary>)
         */
        Builder modelCardVersionSummaryList(Consumer<ModelCardVersionSummary.Builder>... modelCardVersionSummaryList);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of model card versions,
         * use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of model card
         *        versions, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ModelCardVersionSummary> modelCardVersionSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCardVersionsResponse model) {
            super(model);
            modelCardVersionSummaryList(model.modelCardVersionSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ModelCardVersionSummary.Builder> getModelCardVersionSummaryList() {
            List<ModelCardVersionSummary.Builder> result = ModelCardVersionSummaryListCopier
                    .copyToBuilder(this.modelCardVersionSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCardVersionSummaryList(
                Collection<ModelCardVersionSummary.BuilderImpl> modelCardVersionSummaryList) {
            this.modelCardVersionSummaryList = ModelCardVersionSummaryListCopier.copyFromBuilder(modelCardVersionSummaryList);
        }

        @Override
        public final Builder modelCardVersionSummaryList(Collection<ModelCardVersionSummary> modelCardVersionSummaryList) {
            this.modelCardVersionSummaryList = ModelCardVersionSummaryListCopier.copy(modelCardVersionSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardVersionSummaryList(ModelCardVersionSummary... modelCardVersionSummaryList) {
            modelCardVersionSummaryList(Arrays.asList(modelCardVersionSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardVersionSummaryList(Consumer<ModelCardVersionSummary.Builder>... modelCardVersionSummaryList) {
            modelCardVersionSummaryList(Stream.of(modelCardVersionSummaryList)
                    .map(c -> ModelCardVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelCardVersionsResponse build() {
            return new ListModelCardVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
