/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClustersResponse.getter(ListClustersResponse::nextToken)).setter(ListClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ClusterSummary>> CLUSTER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSummaries").getter(ListClustersResponse.getter(ListClustersResponse::clusterSummaries)).setter(ListClustersResponse.setter(Builder::clusterSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CLUSTER_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<ClusterSummary> clusterSummaries;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.clusterSummaries = builder.clusterSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasClusterSummaries() {
        return this.clusterSummaries != null && !(this.clusterSummaries instanceof SdkAutoConstructList);
    }

    public final List<ClusterSummary> clusterSummaries() {
        return this.clusterSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSummaries() ? this.clusterSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasClusterSummaries() == other.hasClusterSummaries() && Objects.equals(this.clusterSummaries(), other.clusterSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListClustersResponse").add("NextToken", (Object)this.nextToken()).add("ClusterSummaries", this.hasClusterSummaries() ? this.clusterSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ClusterSummaries": {
                return Optional.ofNullable(clazz.cast(this.clusterSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ClusterSummary> clusterSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.clusterSummaries(model.clusterSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClusterSummary.Builder> getClusterSummaries() {
            List<ClusterSummary.Builder> result = ClusterSummariesCopier.copyToBuilder(this.clusterSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSummaries(Collection<ClusterSummary.BuilderImpl> clusterSummaries) {
            this.clusterSummaries = ClusterSummariesCopier.copyFromBuilder(clusterSummaries);
        }

        @Override
        public final Builder clusterSummaries(Collection<ClusterSummary> clusterSummaries) {
            this.clusterSummaries = ClusterSummariesCopier.copy(clusterSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSummaries(ClusterSummary ... clusterSummaries) {
            this.clusterSummaries(Arrays.asList(clusterSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSummaries(Consumer<ClusterSummary.Builder> ... clusterSummaries) {
            this.clusterSummaries(Stream.of(clusterSummaries).map(c -> (ClusterSummary)((ClusterSummary.Builder)ClusterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClustersResponse> {
        public Builder nextToken(String var1);

        public Builder clusterSummaries(Collection<ClusterSummary> var1);

        public Builder clusterSummaries(ClusterSummary ... var1);

        public Builder clusterSummaries(Consumer<ClusterSummary.Builder> ... var1);
    }
}

