/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSpacesRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListSpacesRequest.Builder, ListSpacesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSpacesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSpacesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListSpacesRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListSpacesRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainIdEquals").getter(getter(ListSpacesRequest::domainIdEquals))
            .setter(setter(Builder::domainIdEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIdEquals").build()).build();

    private static final SdkField<String> SPACE_NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceNameContains").getter(getter(ListSpacesRequest::spaceNameContains))
            .setter(setter(Builder::spaceNameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceNameContains").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, DOMAIN_ID_EQUALS_FIELD, SPACE_NAME_CONTAINS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String sortOrder;

    private final String sortBy;

    private final String domainIdEquals;

    private final String spaceNameContains;

    private ListSpacesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.domainIdEquals = builder.domainIdEquals;
        this.spaceNameContains = builder.spaceNameContains;
    }

    /**
     * <p>
     * If the previous response was truncated, you will receive this token. Use it in your next request to receive the
     * next set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you will receive this token. Use it in your next request to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of items to return in the response. If the total number of items available is more than the
     * value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide the
     * <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
     * </p>
     * 
     * @return The total number of items to return in the response. If the total number of items available is more than
     *         the value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide
     *         the <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The sort order for the results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for the results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The parameter by which to sort the results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SpaceSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The parameter by which to sort the results. The default is <code>CreationTime</code>.
     * @see SpaceSortKey
     */
    public final SpaceSortKey sortBy() {
        return SpaceSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * The parameter by which to sort the results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SpaceSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The parameter by which to sort the results. The default is <code>CreationTime</code>.
     * @see SpaceSortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * A parameter to search for the domain ID.
     * </p>
     * 
     * @return A parameter to search for the domain ID.
     */
    public final String domainIdEquals() {
        return domainIdEquals;
    }

    /**
     * <p>
     * A parameter by which to filter the results.
     * </p>
     * 
     * @return A parameter by which to filter the results.
     */
    public final String spaceNameContains() {
        return spaceNameContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdEquals());
        hashCode = 31 * hashCode + Objects.hashCode(spaceNameContains());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpacesRequest)) {
            return false;
        }
        ListSpacesRequest other = (ListSpacesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(domainIdEquals(), other.domainIdEquals())
                && Objects.equals(spaceNameContains(), other.spaceNameContains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSpacesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("SortOrder", sortOrderAsString()).add("SortBy", sortByAsString()).add("DomainIdEquals", domainIdEquals())
                .add("SpaceNameContains", spaceNameContains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "DomainIdEquals":
            return Optional.ofNullable(clazz.cast(domainIdEquals()));
        case "SpaceNameContains":
            return Optional.ofNullable(clazz.cast(spaceNameContains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSpacesRequest, T> g) {
        return obj -> g.apply((ListSpacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSpacesRequest> {
        /**
         * <p>
         * If the previous response was truncated, you will receive this token. Use it in your next request to receive
         * the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you will receive this token. Use it in your next request to
         *        receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of items to return in the response. If the total number of items available is more than the
         * value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide the
         * <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return in the response. If the total number of items available is more
         *        than the value specified, a <code>NextToken</code> is provided in the response. To resume pagination,
         *        provide the <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The sort order for the results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for the results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The parameter by which to sort the results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The parameter by which to sort the results. The default is <code>CreationTime</code>.
         * @see SpaceSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpaceSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The parameter by which to sort the results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The parameter by which to sort the results. The default is <code>CreationTime</code>.
         * @see SpaceSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpaceSortKey
         */
        Builder sortBy(SpaceSortKey sortBy);

        /**
         * <p>
         * A parameter to search for the domain ID.
         * </p>
         * 
         * @param domainIdEquals
         *        A parameter to search for the domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdEquals(String domainIdEquals);

        /**
         * <p>
         * A parameter by which to filter the results.
         * </p>
         * 
         * @param spaceNameContains
         *        A parameter by which to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceNameContains(String spaceNameContains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String sortOrder;

        private String sortBy;

        private String domainIdEquals;

        private String spaceNameContains;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpacesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            domainIdEquals(model.domainIdEquals);
            spaceNameContains(model.spaceNameContains);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SpaceSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getDomainIdEquals() {
            return domainIdEquals;
        }

        public final void setDomainIdEquals(String domainIdEquals) {
            this.domainIdEquals = domainIdEquals;
        }

        @Override
        public final Builder domainIdEquals(String domainIdEquals) {
            this.domainIdEquals = domainIdEquals;
            return this;
        }

        public final String getSpaceNameContains() {
            return spaceNameContains;
        }

        public final void setSpaceNameContains(String spaceNameContains) {
            this.spaceNameContains = spaceNameContains;
        }

        @Override
        public final Builder spaceNameContains(String spaceNameContains) {
            this.spaceNameContains = spaceNameContains;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSpacesRequest build() {
            return new ListSpacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
