/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSpaceRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateSpaceRequest.Builder, CreateSpaceRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(CreateSpaceRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceName").getter(getter(CreateSpaceRequest::spaceName)).setter(setter(Builder::spaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateSpaceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SpaceSettings> SPACE_SETTINGS_FIELD = SdkField
            .<SpaceSettings> builder(MarshallingType.SDK_POJO).memberName("SpaceSettings")
            .getter(getter(CreateSpaceRequest::spaceSettings)).setter(setter(Builder::spaceSettings))
            .constructor(SpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettings").build()).build();

    private static final SdkField<OwnershipSettings> OWNERSHIP_SETTINGS_FIELD = SdkField
            .<OwnershipSettings> builder(MarshallingType.SDK_POJO).memberName("OwnershipSettings")
            .getter(getter(CreateSpaceRequest::ownershipSettings)).setter(setter(Builder::ownershipSettings))
            .constructor(OwnershipSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipSettings").build()).build();

    private static final SdkField<SpaceSharingSettings> SPACE_SHARING_SETTINGS_FIELD = SdkField
            .<SpaceSharingSettings> builder(MarshallingType.SDK_POJO).memberName("SpaceSharingSettings")
            .getter(getter(CreateSpaceRequest::spaceSharingSettings)).setter(setter(Builder::spaceSharingSettings))
            .constructor(SpaceSharingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSharingSettings").build())
            .build();

    private static final SdkField<String> SPACE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceDisplayName").getter(getter(CreateSpaceRequest::spaceDisplayName))
            .setter(setter(Builder::spaceDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceDisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            SPACE_NAME_FIELD, TAGS_FIELD, SPACE_SETTINGS_FIELD, OWNERSHIP_SETTINGS_FIELD, SPACE_SHARING_SETTINGS_FIELD,
            SPACE_DISPLAY_NAME_FIELD));

    private final String domainId;

    private final String spaceName;

    private final List<Tag> tags;

    private final SpaceSettings spaceSettings;

    private final OwnershipSettings ownershipSettings;

    private final SpaceSharingSettings spaceSharingSettings;

    private final String spaceDisplayName;

    private CreateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.spaceName = builder.spaceName;
        this.tags = builder.tags;
        this.spaceSettings = builder.spaceSettings;
        this.ownershipSettings = builder.ownershipSettings;
        this.spaceSharingSettings = builder.spaceSharingSettings;
        this.spaceDisplayName = builder.spaceDisplayName;
    }

    /**
     * <p>
     * The ID of the associated domain.
     * </p>
     * 
     * @return The ID of the associated domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the space.
     * </p>
     * 
     * @return The name of the space.
     */
    public final String spaceName() {
        return spaceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to associated with the space. Each tag consists of a key and an optional value. Tag keys must be unique for
     * each resource. Tags are searchable using the <code>Search</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to associated with the space. Each tag consists of a key and an optional value. Tag keys must be
     *         unique for each resource. Tags are searchable using the <code>Search</code> API.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A collection of space settings.
     * </p>
     * 
     * @return A collection of space settings.
     */
    public final SpaceSettings spaceSettings() {
        return spaceSettings;
    }

    /**
     * <p>
     * A collection of ownership settings.
     * </p>
     * 
     * @return A collection of ownership settings.
     */
    public final OwnershipSettings ownershipSettings() {
        return ownershipSettings;
    }

    /**
     * <p>
     * A collection of space sharing settings.
     * </p>
     * 
     * @return A collection of space sharing settings.
     */
    public final SpaceSharingSettings spaceSharingSettings() {
        return spaceSharingSettings;
    }

    /**
     * <p>
     * The name of the space that appears in the SageMaker Studio UI.
     * </p>
     * 
     * @return The name of the space that appears in the SageMaker Studio UI.
     */
    public final String spaceDisplayName() {
        return spaceDisplayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(spaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ownershipSettings());
        hashCode = 31 * hashCode + Objects.hashCode(spaceSharingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(spaceDisplayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpaceRequest)) {
            return false;
        }
        CreateSpaceRequest other = (CreateSpaceRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(spaceName(), other.spaceName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(spaceSettings(), other.spaceSettings())
                && Objects.equals(ownershipSettings(), other.ownershipSettings())
                && Objects.equals(spaceSharingSettings(), other.spaceSharingSettings())
                && Objects.equals(spaceDisplayName(), other.spaceDisplayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSpaceRequest").add("DomainId", domainId()).add("SpaceName", spaceName())
                .add("Tags", hasTags() ? tags() : null).add("SpaceSettings", spaceSettings())
                .add("OwnershipSettings", ownershipSettings()).add("SpaceSharingSettings", spaceSharingSettings())
                .add("SpaceDisplayName", spaceDisplayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "SpaceName":
            return Optional.ofNullable(clazz.cast(spaceName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SpaceSettings":
            return Optional.ofNullable(clazz.cast(spaceSettings()));
        case "OwnershipSettings":
            return Optional.ofNullable(clazz.cast(ownershipSettings()));
        case "SpaceSharingSettings":
            return Optional.ofNullable(clazz.cast(spaceSharingSettings()));
        case "SpaceDisplayName":
            return Optional.ofNullable(clazz.cast(spaceDisplayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSpaceRequest, T> g) {
        return obj -> g.apply((CreateSpaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSpaceRequest> {
        /**
         * <p>
         * The ID of the associated domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the associated domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the space.
         * </p>
         * 
         * @param spaceName
         *        The name of the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceName(String spaceName);

        /**
         * <p>
         * Tags to associated with the space. Each tag consists of a key and an optional value. Tag keys must be unique
         * for each resource. Tags are searchable using the <code>Search</code> API.
         * </p>
         * 
         * @param tags
         *        Tags to associated with the space. Each tag consists of a key and an optional value. Tag keys must be
         *        unique for each resource. Tags are searchable using the <code>Search</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to associated with the space. Each tag consists of a key and an optional value. Tag keys must be unique
         * for each resource. Tags are searchable using the <code>Search</code> API.
         * </p>
         * 
         * @param tags
         *        Tags to associated with the space. Each tag consists of a key and an optional value. Tag keys must be
         *        unique for each resource. Tags are searchable using the <code>Search</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to associated with the space. Each tag consists of a key and an optional value. Tag keys must be unique
         * for each resource. Tags are searchable using the <code>Search</code> API.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A collection of space settings.
         * </p>
         * 
         * @param spaceSettings
         *        A collection of space settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceSettings(SpaceSettings spaceSettings);

        /**
         * <p>
         * A collection of space settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceSettings.Builder} avoiding the need
         * to create one manually via {@link SpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #spaceSettings(SpaceSettings)}.
         * 
         * @param spaceSettings
         *        a consumer that will call methods on {@link SpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceSettings(SpaceSettings)
         */
        default Builder spaceSettings(Consumer<SpaceSettings.Builder> spaceSettings) {
            return spaceSettings(SpaceSettings.builder().applyMutation(spaceSettings).build());
        }

        /**
         * <p>
         * A collection of ownership settings.
         * </p>
         * 
         * @param ownershipSettings
         *        A collection of ownership settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownershipSettings(OwnershipSettings ownershipSettings);

        /**
         * <p>
         * A collection of ownership settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link OwnershipSettings.Builder} avoiding the
         * need to create one manually via {@link OwnershipSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OwnershipSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #ownershipSettings(OwnershipSettings)}.
         * 
         * @param ownershipSettings
         *        a consumer that will call methods on {@link OwnershipSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownershipSettings(OwnershipSettings)
         */
        default Builder ownershipSettings(Consumer<OwnershipSettings.Builder> ownershipSettings) {
            return ownershipSettings(OwnershipSettings.builder().applyMutation(ownershipSettings).build());
        }

        /**
         * <p>
         * A collection of space sharing settings.
         * </p>
         * 
         * @param spaceSharingSettings
         *        A collection of space sharing settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceSharingSettings(SpaceSharingSettings spaceSharingSettings);

        /**
         * <p>
         * A collection of space sharing settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceSharingSettings.Builder} avoiding
         * the need to create one manually via {@link SpaceSharingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceSharingSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #spaceSharingSettings(SpaceSharingSettings)}.
         * 
         * @param spaceSharingSettings
         *        a consumer that will call methods on {@link SpaceSharingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceSharingSettings(SpaceSharingSettings)
         */
        default Builder spaceSharingSettings(Consumer<SpaceSharingSettings.Builder> spaceSharingSettings) {
            return spaceSharingSettings(SpaceSharingSettings.builder().applyMutation(spaceSharingSettings).build());
        }

        /**
         * <p>
         * The name of the space that appears in the SageMaker Studio UI.
         * </p>
         * 
         * @param spaceDisplayName
         *        The name of the space that appears in the SageMaker Studio UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceDisplayName(String spaceDisplayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private String spaceName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private SpaceSettings spaceSettings;

        private OwnershipSettings ownershipSettings;

        private SpaceSharingSettings spaceSharingSettings;

        private String spaceDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpaceRequest model) {
            super(model);
            domainId(model.domainId);
            spaceName(model.spaceName);
            tags(model.tags);
            spaceSettings(model.spaceSettings);
            ownershipSettings(model.ownershipSettings);
            spaceSharingSettings(model.spaceSharingSettings);
            spaceDisplayName(model.spaceDisplayName);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceName() {
            return spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SpaceSettings.Builder getSpaceSettings() {
            return spaceSettings != null ? spaceSettings.toBuilder() : null;
        }

        public final void setSpaceSettings(SpaceSettings.BuilderImpl spaceSettings) {
            this.spaceSettings = spaceSettings != null ? spaceSettings.build() : null;
        }

        @Override
        public final Builder spaceSettings(SpaceSettings spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        public final OwnershipSettings.Builder getOwnershipSettings() {
            return ownershipSettings != null ? ownershipSettings.toBuilder() : null;
        }

        public final void setOwnershipSettings(OwnershipSettings.BuilderImpl ownershipSettings) {
            this.ownershipSettings = ownershipSettings != null ? ownershipSettings.build() : null;
        }

        @Override
        public final Builder ownershipSettings(OwnershipSettings ownershipSettings) {
            this.ownershipSettings = ownershipSettings;
            return this;
        }

        public final SpaceSharingSettings.Builder getSpaceSharingSettings() {
            return spaceSharingSettings != null ? spaceSharingSettings.toBuilder() : null;
        }

        public final void setSpaceSharingSettings(SpaceSharingSettings.BuilderImpl spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings != null ? spaceSharingSettings.build() : null;
        }

        @Override
        public final Builder spaceSharingSettings(SpaceSharingSettings spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings;
            return this;
        }

        public final String getSpaceDisplayName() {
            return spaceDisplayName;
        }

        public final void setSpaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
        }

        @Override
        public final Builder spaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSpaceRequest build() {
            return new CreateSpaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
