/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies summary information about the ownership settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OwnershipSettingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OwnershipSettingsSummary.Builder, OwnershipSettingsSummary> {
    private static final SdkField<String> OWNER_USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerUserProfileName").getter(getter(OwnershipSettingsSummary::ownerUserProfileName))
            .setter(setter(Builder::ownerUserProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerUserProfileName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(OWNER_USER_PROFILE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ownerUserProfileName;

    private OwnershipSettingsSummary(BuilderImpl builder) {
        this.ownerUserProfileName = builder.ownerUserProfileName;
    }

    /**
     * <p>
     * The user profile who is the owner of the private space.
     * </p>
     * 
     * @return The user profile who is the owner of the private space.
     */
    public final String ownerUserProfileName() {
        return ownerUserProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerUserProfileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OwnershipSettingsSummary)) {
            return false;
        }
        OwnershipSettingsSummary other = (OwnershipSettingsSummary) obj;
        return Objects.equals(ownerUserProfileName(), other.ownerUserProfileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OwnershipSettingsSummary").add("OwnerUserProfileName", ownerUserProfileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerUserProfileName":
            return Optional.ofNullable(clazz.cast(ownerUserProfileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OwnershipSettingsSummary, T> g) {
        return obj -> g.apply((OwnershipSettingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OwnershipSettingsSummary> {
        /**
         * <p>
         * The user profile who is the owner of the private space.
         * </p>
         * 
         * @param ownerUserProfileName
         *        The user profile who is the owner of the private space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerUserProfileName(String ownerUserProfileName);
    }

    static final class BuilderImpl implements Builder {
        private String ownerUserProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(OwnershipSettingsSummary model) {
            ownerUserProfileName(model.ownerUserProfileName);
        }

        public final String getOwnerUserProfileName() {
            return ownerUserProfileName;
        }

        public final void setOwnerUserProfileName(String ownerUserProfileName) {
            this.ownerUserProfileName = ownerUserProfileName;
        }

        @Override
        public final Builder ownerUserProfileName(String ownerUserProfileName) {
            this.ownerUserProfileName = ownerUserProfileName;
            return this;
        }

        @Override
        public OwnershipSettingsSummary build() {
            return new OwnershipSettingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
