/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelCardExportJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListModelCardExportJobsResponse.Builder, ListModelCardExportJobsResponse> {
    private static final SdkField<List<ModelCardExportJobSummary>> MODEL_CARD_EXPORT_JOB_SUMMARIES_FIELD = SdkField
            .<List<ModelCardExportJobSummary>> builder(MarshallingType.LIST)
            .memberName("ModelCardExportJobSummaries")
            .getter(getter(ListModelCardExportJobsResponse::modelCardExportJobSummaries))
            .setter(setter(Builder::modelCardExportJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelCardExportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelCardExportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelCardExportJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_CARD_EXPORT_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ModelCardExportJobSummary> modelCardExportJobSummaries;

    private final String nextToken;

    private ListModelCardExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardExportJobSummaries = builder.modelCardExportJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelCardExportJobSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelCardExportJobSummaries() {
        return modelCardExportJobSummaries != null && !(modelCardExportJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of the listed model card export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelCardExportJobSummaries} method.
     * </p>
     * 
     * @return The summaries of the listed model card export jobs.
     */
    public final List<ModelCardExportJobSummary> modelCardExportJobSummaries() {
        return modelCardExportJobSummaries;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of model card export jobs,
     * use it in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of model card export
     *         jobs, use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelCardExportJobSummaries() ? modelCardExportJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCardExportJobsResponse)) {
            return false;
        }
        ListModelCardExportJobsResponse other = (ListModelCardExportJobsResponse) obj;
        return hasModelCardExportJobSummaries() == other.hasModelCardExportJobSummaries()
                && Objects.equals(modelCardExportJobSummaries(), other.modelCardExportJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelCardExportJobsResponse")
                .add("ModelCardExportJobSummaries", hasModelCardExportJobSummaries() ? modelCardExportJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardExportJobSummaries":
            return Optional.ofNullable(clazz.cast(modelCardExportJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelCardExportJobsResponse, T> g) {
        return obj -> g.apply((ListModelCardExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListModelCardExportJobsResponse> {
        /**
         * <p>
         * The summaries of the listed model card export jobs.
         * </p>
         * 
         * @param modelCardExportJobSummaries
         *        The summaries of the listed model card export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobSummaries(Collection<ModelCardExportJobSummary> modelCardExportJobSummaries);

        /**
         * <p>
         * The summaries of the listed model card export jobs.
         * </p>
         * 
         * @param modelCardExportJobSummaries
         *        The summaries of the listed model card export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobSummaries(ModelCardExportJobSummary... modelCardExportJobSummaries);

        /**
         * <p>
         * The summaries of the listed model card export jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelCardExportJobSummaries(List<ModelCardExportJobSummary>)}.
         * 
         * @param modelCardExportJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelCardExportJobSummaries(java.util.Collection<ModelCardExportJobSummary>)
         */
        Builder modelCardExportJobSummaries(Consumer<ModelCardExportJobSummary.Builder>... modelCardExportJobSummaries);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of model card export
         * jobs, use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of model card
         *        export jobs, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ModelCardExportJobSummary> modelCardExportJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCardExportJobsResponse model) {
            super(model);
            modelCardExportJobSummaries(model.modelCardExportJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<ModelCardExportJobSummary.Builder> getModelCardExportJobSummaries() {
            List<ModelCardExportJobSummary.Builder> result = ModelCardExportJobSummaryListCopier
                    .copyToBuilder(this.modelCardExportJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCardExportJobSummaries(
                Collection<ModelCardExportJobSummary.BuilderImpl> modelCardExportJobSummaries) {
            this.modelCardExportJobSummaries = ModelCardExportJobSummaryListCopier.copyFromBuilder(modelCardExportJobSummaries);
        }

        @Override
        public final Builder modelCardExportJobSummaries(Collection<ModelCardExportJobSummary> modelCardExportJobSummaries) {
            this.modelCardExportJobSummaries = ModelCardExportJobSummaryListCopier.copy(modelCardExportJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardExportJobSummaries(ModelCardExportJobSummary... modelCardExportJobSummaries) {
            modelCardExportJobSummaries(Arrays.asList(modelCardExportJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardExportJobSummaries(
                Consumer<ModelCardExportJobSummary.Builder>... modelCardExportJobSummaries) {
            modelCardExportJobSummaries(Stream.of(modelCardExportJobSummaries)
                    .map(c -> ModelCardExportJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelCardExportJobsResponse build() {
            return new ListModelCardExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
