/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an instance group in a SageMaker HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterInstanceGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterInstanceGroupDetails.Builder, ClusterInstanceGroupDetails> {
    private static final SdkField<Integer> CURRENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentCount").getter(getter(ClusterInstanceGroupDetails::currentCount))
            .setter(setter(Builder::currentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentCount").build()).build();

    private static final SdkField<Integer> TARGET_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetCount").getter(getter(ClusterInstanceGroupDetails::targetCount))
            .setter(setter(Builder::targetCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCount").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(ClusterInstanceGroupDetails::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ClusterInstanceGroupDetails::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField
            .<ClusterLifeCycleConfig> builder(MarshallingType.SDK_POJO).memberName("LifeCycleConfig")
            .getter(getter(ClusterInstanceGroupDetails::lifeCycleConfig)).setter(setter(Builder::lifeCycleConfig))
            .constructor(ClusterLifeCycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(ClusterInstanceGroupDetails::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore").getter(getter(ClusterInstanceGroupDetails::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_COUNT_FIELD,
            TARGET_COUNT_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_TYPE_FIELD, LIFE_CYCLE_CONFIG_FIELD, EXECUTION_ROLE_FIELD,
            THREADS_PER_CORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer currentCount;

    private final Integer targetCount;

    private final String instanceGroupName;

    private final String instanceType;

    private final ClusterLifeCycleConfig lifeCycleConfig;

    private final String executionRole;

    private final Integer threadsPerCore;

    private ClusterInstanceGroupDetails(BuilderImpl builder) {
        this.currentCount = builder.currentCount;
        this.targetCount = builder.targetCount;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceType = builder.instanceType;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.executionRole = builder.executionRole;
        this.threadsPerCore = builder.threadsPerCore;
    }

    /**
     * <p>
     * The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
     */
    public final Integer currentCount() {
        return currentCount;
    }

    /**
     * <p>
     * The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
     */
    public final Integer targetCount() {
        return targetCount;
    }

    /**
     * <p>
     * The name of the instance group of a SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The name of the instance group of a SageMaker HyperPod cluster.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The instance type of the instance group of a SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type of the instance group of a SageMaker HyperPod cluster.
     * @see ClusterInstanceType
     */
    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type of the instance group of a SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type of the instance group of a SageMaker HyperPod cluster.
     * @see ClusterInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * Details of LifeCycle configuration for the instance group.
     * </p>
     * 
     * @return Details of LifeCycle configuration for the instance group.
     */
    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return lifeCycleConfig;
    }

    /**
     * <p>
     * The execution role for the instance group to assume.
     * </p>
     * 
     * @return The execution role for the instance group to assume.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The number you specified to <code>TreadsPerCore</code> in <code>CreateCluster</code> for enabling or disabling
     * multithreading. For instance types that support multithreading, you can specify 1 for disabling multithreading
     * and 2 for enabling multithreading. For more information, see the reference table of <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU cores
     * and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The number you specified to <code>TreadsPerCore</code> in <code>CreateCluster</code> for enabling or
     *         disabling multithreading. For instance types that support multithreading, you can specify 1 for disabling
     *         multithreading and 2 for enabling multithreading. For more information, see the reference table of <a
     *         href
     *         ="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU
     *         cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User
     *         Guide</i>.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentCount());
        hashCode = 31 * hashCode + Objects.hashCode(targetCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInstanceGroupDetails)) {
            return false;
        }
        ClusterInstanceGroupDetails other = (ClusterInstanceGroupDetails) obj;
        return Objects.equals(currentCount(), other.currentCount()) && Objects.equals(targetCount(), other.targetCount())
                && Objects.equals(instanceGroupName(), other.instanceGroupName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(lifeCycleConfig(), other.lifeCycleConfig())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(threadsPerCore(), other.threadsPerCore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterInstanceGroupDetails").add("CurrentCount", currentCount())
                .add("TargetCount", targetCount()).add("InstanceGroupName", instanceGroupName())
                .add("InstanceType", instanceTypeAsString()).add("LifeCycleConfig", lifeCycleConfig())
                .add("ExecutionRole", executionRole()).add("ThreadsPerCore", threadsPerCore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentCount":
            return Optional.ofNullable(clazz.cast(currentCount()));
        case "TargetCount":
            return Optional.ofNullable(clazz.cast(targetCount()));
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LifeCycleConfig":
            return Optional.ofNullable(clazz.cast(lifeCycleConfig()));
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInstanceGroupDetails, T> g) {
        return obj -> g.apply((ClusterInstanceGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterInstanceGroupDetails> {
        /**
         * <p>
         * The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param currentCount
         *        The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentCount(Integer currentCount);

        /**
         * <p>
         * The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param targetCount
         *        The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCount(Integer targetCount);

        /**
         * <p>
         * The name of the instance group of a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceGroupName
         *        The name of the instance group of a SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The instance type of the instance group of a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the instance group of a SageMaker HyperPod cluster.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type of the instance group of a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the instance group of a SageMaker HyperPod cluster.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(ClusterInstanceType instanceType);

        /**
         * <p>
         * Details of LifeCycle configuration for the instance group.
         * </p>
         * 
         * @param lifeCycleConfig
         *        Details of LifeCycle configuration for the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig);

        /**
         * <p>
         * Details of LifeCycle configuration for the instance group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterLifeCycleConfig.Builder} avoiding
         * the need to create one manually via {@link ClusterLifeCycleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterLifeCycleConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lifeCycleConfig(ClusterLifeCycleConfig)}.
         * 
         * @param lifeCycleConfig
         *        a consumer that will call methods on {@link ClusterLifeCycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycleConfig(ClusterLifeCycleConfig)
         */
        default Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return lifeCycleConfig(ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig).build());
        }

        /**
         * <p>
         * The execution role for the instance group to assume.
         * </p>
         * 
         * @param executionRole
         *        The execution role for the instance group to assume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The number you specified to <code>TreadsPerCore</code> in <code>CreateCluster</code> for enabling or
         * disabling multithreading. For instance types that support multithreading, you can specify 1 for disabling
         * multithreading and 2 for enabling multithreading. For more information, see the reference table of <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU
         * cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param threadsPerCore
         *        The number you specified to <code>TreadsPerCore</code> in <code>CreateCluster</code> for enabling or
         *        disabling multithreading. For instance types that support multithreading, you can specify 1 for
         *        disabling multithreading and 2 for enabling multithreading. For more information, see the reference
         *        table of <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU
         *        cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);
    }

    static final class BuilderImpl implements Builder {
        private Integer currentCount;

        private Integer targetCount;

        private String instanceGroupName;

        private String instanceType;

        private ClusterLifeCycleConfig lifeCycleConfig;

        private String executionRole;

        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInstanceGroupDetails model) {
            currentCount(model.currentCount);
            targetCount(model.targetCount);
            instanceGroupName(model.instanceGroupName);
            instanceType(model.instanceType);
            lifeCycleConfig(model.lifeCycleConfig);
            executionRole(model.executionRole);
            threadsPerCore(model.threadsPerCore);
        }

        public final Integer getCurrentCount() {
            return currentCount;
        }

        public final void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        @Override
        public final Builder currentCount(Integer currentCount) {
            this.currentCount = currentCount;
            return this;
        }

        public final Integer getTargetCount() {
            return targetCount;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        @Override
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return lifeCycleConfig != null ? lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        @Override
        public ClusterInstanceGroupDetails build() {
            return new ClusterInstanceGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
