/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the file system and kernels in a SageMaker image running as a Code Editor app. The
 * <code>FileSystemConfig</code> object is not supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeEditorAppImageConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeEditorAppImageConfig.Builder, CodeEditorAppImageConfig> {
    private static final SdkField<FileSystemConfig> FILE_SYSTEM_CONFIG_FIELD = SdkField
            .<FileSystemConfig> builder(MarshallingType.SDK_POJO).memberName("FileSystemConfig")
            .getter(getter(CodeEditorAppImageConfig::fileSystemConfig)).setter(setter(Builder::fileSystemConfig))
            .constructor(FileSystemConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfig").build()).build();

    private static final SdkField<ContainerConfig> CONTAINER_CONFIG_FIELD = SdkField
            .<ContainerConfig> builder(MarshallingType.SDK_POJO).memberName("ContainerConfig")
            .getter(getter(CodeEditorAppImageConfig::containerConfig)).setter(setter(Builder::containerConfig))
            .constructor(ContainerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_CONFIG_FIELD,
            CONTAINER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final FileSystemConfig fileSystemConfig;

    private final ContainerConfig containerConfig;

    private CodeEditorAppImageConfig(BuilderImpl builder) {
        this.fileSystemConfig = builder.fileSystemConfig;
        this.containerConfig = builder.containerConfig;
    }

    /**
     * Returns the value of the FileSystemConfig property for this object.
     * 
     * @return The value of the FileSystemConfig property for this object.
     */
    public final FileSystemConfig fileSystemConfig() {
        return fileSystemConfig;
    }

    /**
     * Returns the value of the ContainerConfig property for this object.
     * 
     * @return The value of the ContainerConfig property for this object.
     */
    public final ContainerConfig containerConfig() {
        return containerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemConfig());
        hashCode = 31 * hashCode + Objects.hashCode(containerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeEditorAppImageConfig)) {
            return false;
        }
        CodeEditorAppImageConfig other = (CodeEditorAppImageConfig) obj;
        return Objects.equals(fileSystemConfig(), other.fileSystemConfig())
                && Objects.equals(containerConfig(), other.containerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeEditorAppImageConfig").add("FileSystemConfig", fileSystemConfig())
                .add("ContainerConfig", containerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemConfig":
            return Optional.ofNullable(clazz.cast(fileSystemConfig()));
        case "ContainerConfig":
            return Optional.ofNullable(clazz.cast(containerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeEditorAppImageConfig, T> g) {
        return obj -> g.apply((CodeEditorAppImageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeEditorAppImageConfig> {
        /**
         * Sets the value of the FileSystemConfig property for this object.
         *
         * @param fileSystemConfig
         *        The new value for the FileSystemConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfig(FileSystemConfig fileSystemConfig);

        /**
         * Sets the value of the FileSystemConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FileSystemConfig.Builder} avoiding the
         * need to create one manually via {@link FileSystemConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSystemConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #fileSystemConfig(FileSystemConfig)}.
         * 
         * @param fileSystemConfig
         *        a consumer that will call methods on {@link FileSystemConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemConfig(FileSystemConfig)
         */
        default Builder fileSystemConfig(Consumer<FileSystemConfig.Builder> fileSystemConfig) {
            return fileSystemConfig(FileSystemConfig.builder().applyMutation(fileSystemConfig).build());
        }

        /**
         * Sets the value of the ContainerConfig property for this object.
         *
         * @param containerConfig
         *        The new value for the ContainerConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerConfig(ContainerConfig containerConfig);

        /**
         * Sets the value of the ContainerConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ContainerConfig.Builder} avoiding the
         * need to create one manually via {@link ContainerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #containerConfig(ContainerConfig)}.
         * 
         * @param containerConfig
         *        a consumer that will call methods on {@link ContainerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerConfig(ContainerConfig)
         */
        default Builder containerConfig(Consumer<ContainerConfig.Builder> containerConfig) {
            return containerConfig(ContainerConfig.builder().applyMutation(containerConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileSystemConfig fileSystemConfig;

        private ContainerConfig containerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeEditorAppImageConfig model) {
            fileSystemConfig(model.fileSystemConfig);
            containerConfig(model.containerConfig);
        }

        public final FileSystemConfig.Builder getFileSystemConfig() {
            return fileSystemConfig != null ? fileSystemConfig.toBuilder() : null;
        }

        public final void setFileSystemConfig(FileSystemConfig.BuilderImpl fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig != null ? fileSystemConfig.build() : null;
        }

        @Override
        public final Builder fileSystemConfig(FileSystemConfig fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig;
            return this;
        }

        public final ContainerConfig.Builder getContainerConfig() {
            return containerConfig != null ? containerConfig.toBuilder() : null;
        }

        public final void setContainerConfig(ContainerConfig.BuilderImpl containerConfig) {
            this.containerConfig = containerConfig != null ? containerConfig.build() : null;
        }

        @Override
        public final Builder containerConfig(ContainerConfig containerConfig) {
            this.containerConfig = containerConfig;
            return this;
        }

        @Override
        public CodeEditorAppImageConfig build() {
            return new CodeEditorAppImageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
