/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of default EBS storage settings that applies to private spaces created within a domain or user profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultEbsStorageSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultEbsStorageSettings.Builder, DefaultEbsStorageSettings> {
    private static final SdkField<Integer> DEFAULT_EBS_VOLUME_SIZE_IN_GB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("DefaultEbsVolumeSizeInGb")
            .getter(getter(DefaultEbsStorageSettings::defaultEbsVolumeSizeInGb))
            .setter(setter(Builder::defaultEbsVolumeSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEbsVolumeSizeInGb").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_EBS_VOLUME_SIZE_IN_GB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumEbsVolumeSizeInGb")
            .getter(getter(DefaultEbsStorageSettings::maximumEbsVolumeSizeInGb))
            .setter(setter(Builder::maximumEbsVolumeSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEbsVolumeSizeInGb").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_EBS_VOLUME_SIZE_IN_GB_FIELD, MAXIMUM_EBS_VOLUME_SIZE_IN_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer defaultEbsVolumeSizeInGb;

    private final Integer maximumEbsVolumeSizeInGb;

    private DefaultEbsStorageSettings(BuilderImpl builder) {
        this.defaultEbsVolumeSizeInGb = builder.defaultEbsVolumeSizeInGb;
        this.maximumEbsVolumeSizeInGb = builder.maximumEbsVolumeSizeInGb;
    }

    /**
     * <p>
     * The default size of the EBS storage volume for a private space.
     * </p>
     * 
     * @return The default size of the EBS storage volume for a private space.
     */
    public final Integer defaultEbsVolumeSizeInGb() {
        return defaultEbsVolumeSizeInGb;
    }

    /**
     * <p>
     * The maximum size of the EBS storage volume for a private space.
     * </p>
     * 
     * @return The maximum size of the EBS storage volume for a private space.
     */
    public final Integer maximumEbsVolumeSizeInGb() {
        return maximumEbsVolumeSizeInGb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultEbsVolumeSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(maximumEbsVolumeSizeInGb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultEbsStorageSettings)) {
            return false;
        }
        DefaultEbsStorageSettings other = (DefaultEbsStorageSettings) obj;
        return Objects.equals(defaultEbsVolumeSizeInGb(), other.defaultEbsVolumeSizeInGb())
                && Objects.equals(maximumEbsVolumeSizeInGb(), other.maximumEbsVolumeSizeInGb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultEbsStorageSettings").add("DefaultEbsVolumeSizeInGb", defaultEbsVolumeSizeInGb())
                .add("MaximumEbsVolumeSizeInGb", maximumEbsVolumeSizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultEbsVolumeSizeInGb":
            return Optional.ofNullable(clazz.cast(defaultEbsVolumeSizeInGb()));
        case "MaximumEbsVolumeSizeInGb":
            return Optional.ofNullable(clazz.cast(maximumEbsVolumeSizeInGb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultEbsStorageSettings, T> g) {
        return obj -> g.apply((DefaultEbsStorageSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultEbsStorageSettings> {
        /**
         * <p>
         * The default size of the EBS storage volume for a private space.
         * </p>
         * 
         * @param defaultEbsVolumeSizeInGb
         *        The default size of the EBS storage volume for a private space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEbsVolumeSizeInGb(Integer defaultEbsVolumeSizeInGb);

        /**
         * <p>
         * The maximum size of the EBS storage volume for a private space.
         * </p>
         * 
         * @param maximumEbsVolumeSizeInGb
         *        The maximum size of the EBS storage volume for a private space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEbsVolumeSizeInGb(Integer maximumEbsVolumeSizeInGb);
    }

    static final class BuilderImpl implements Builder {
        private Integer defaultEbsVolumeSizeInGb;

        private Integer maximumEbsVolumeSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultEbsStorageSettings model) {
            defaultEbsVolumeSizeInGb(model.defaultEbsVolumeSizeInGb);
            maximumEbsVolumeSizeInGb(model.maximumEbsVolumeSizeInGb);
        }

        public final Integer getDefaultEbsVolumeSizeInGb() {
            return defaultEbsVolumeSizeInGb;
        }

        public final void setDefaultEbsVolumeSizeInGb(Integer defaultEbsVolumeSizeInGb) {
            this.defaultEbsVolumeSizeInGb = defaultEbsVolumeSizeInGb;
        }

        @Override
        public final Builder defaultEbsVolumeSizeInGb(Integer defaultEbsVolumeSizeInGb) {
            this.defaultEbsVolumeSizeInGb = defaultEbsVolumeSizeInGb;
            return this;
        }

        public final Integer getMaximumEbsVolumeSizeInGb() {
            return maximumEbsVolumeSizeInGb;
        }

        public final void setMaximumEbsVolumeSizeInGb(Integer maximumEbsVolumeSizeInGb) {
            this.maximumEbsVolumeSizeInGb = maximumEbsVolumeSizeInGb;
        }

        @Override
        public final Builder maximumEbsVolumeSizeInGb(Integer maximumEbsVolumeSizeInGb) {
            this.maximumEbsVolumeSizeInGb = maximumEbsVolumeSizeInGb;
            return this;
        }

        @Override
        public DefaultEbsStorageSettings build() {
            return new DefaultEbsStorageSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
