/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output configuration information for a labeling job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobOutputConfig.Builder, LabelingJobOutputConfig> {
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputPath").getter(getter(LabelingJobOutputConfig::s3OutputPath))
            .setter(setter(Builder::s3OutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(LabelingJobOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(LabelingJobOutputConfig::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_PATH_FIELD,
            KMS_KEY_ID_FIELD, SNS_TOPIC_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3OutputPath;

    private final String kmsKeyId;

    private final String snsTopicArn;

    private LabelingJobOutputConfig(BuilderImpl builder) {
        this.s3OutputPath = builder.s3OutputPath;
        this.kmsKeyId = builder.kmsKeyId;
        this.snsTopicArn = builder.snsTopicArn;
    }

    /**
     * <p>
     * The Amazon S3 location to write output data.
     * </p>
     * 
     * @return The Amazon S3 location to write output data.
     */
    public final String s3OutputPath() {
        return s3OutputPath;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if any.
     * </p>
     * <p>
     * If you provide your own KMS key ID, you must add the required permissions to your KMS key described in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions"
     * >Encrypt Output Data and Storage Volume with Amazon Web Services KMS</a>.
     * </p>
     * <p>
     * If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for Amazon S3
     * for your role's account to encrypt your output data.
     * </p>
     * <p>
     * If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side
     * encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in
     * the <i>Amazon Simple Storage Service Developer Guide.</i>
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if any.</p>
     *         <p>
     *         If you provide your own KMS key ID, you must add the required permissions to your KMS key described in <a
     *         href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions"
     *         >Encrypt Output Data and Storage Volume with Amazon Web Services KMS</a>.
     *         </p>
     *         <p>
     *         If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for
     *         Amazon S3 for your role's account to encrypt your output data.
     *         </p>
     *         <p>
     *         If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with
     *         server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to
     *         <code>"aws:kms"</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption
     *         Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a <code>SnsTopicArn</code> if you
     * want to do real time chaining to another streaming job and receive an Amazon SNS notifications each time a data
     * object is submitted by a worker.
     * </p>
     * <p>
     * If you provide an <code>SnsTopicArn</code> in <code>OutputConfig</code>, when workers complete labeling tasks,
     * Ground Truth will send labeling task output data to the SNS output topic you specify here.
     * </p>
     * <p>
     * To learn more, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data"
     * >Receive Output Data from a Streaming Labeling Job</a>.
     * </p>
     * 
     * @return An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a <code>SnsTopicArn</code>
     *         if you want to do real time chaining to another streaming job and receive an Amazon SNS notifications
     *         each time a data object is submitted by a worker.</p>
     *         <p>
     *         If you provide an <code>SnsTopicArn</code> in <code>OutputConfig</code>, when workers complete labeling
     *         tasks, Ground Truth will send labeling task output data to the SNS output topic you specify here.
     *         </p>
     *         <p>
     *         To learn more, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data"
     *         >Receive Output Data from a Streaming Labeling Job</a>.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobOutputConfig)) {
            return false;
        }
        LabelingJobOutputConfig other = (LabelingJobOutputConfig) obj;
        return Objects.equals(s3OutputPath(), other.s3OutputPath()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(snsTopicArn(), other.snsTopicArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelingJobOutputConfig").add("S3OutputPath", s3OutputPath()).add("KmsKeyId", kmsKeyId())
                .add("SnsTopicArn", snsTopicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputPath":
            return Optional.ofNullable(clazz.cast(s3OutputPath()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobOutputConfig, T> g) {
        return obj -> g.apply((LabelingJobOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobOutputConfig> {
        /**
         * <p>
         * The Amazon S3 location to write output data.
         * </p>
         * 
         * @param s3OutputPath
         *        The Amazon S3 location to write output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputPath(String s3OutputPath);

        /**
         * <p>
         * The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if any.
         * </p>
         * <p>
         * If you provide your own KMS key ID, you must add the required permissions to your KMS key described in <a
         * href
         * ="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions"
         * >Encrypt Output Data and Storage Volume with Amazon Web Services KMS</a>.
         * </p>
         * <p>
         * If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for Amazon
         * S3 for your role's account to encrypt your output data.
         * </p>
         * <p>
         * If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with
         * server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to
         * <code>"aws:kms"</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption
         * Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i>
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if
         *        any.</p>
         *        <p>
         *        If you provide your own KMS key ID, you must add the required permissions to your KMS key described in
         *        <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions"
         *        >Encrypt Output Data and Storage Volume with Amazon Web Services KMS</a>.
         *        </p>
         *        <p>
         *        If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for
         *        Amazon S3 for your role's account to encrypt your output data.
         *        </p>
         *        <p>
         *        If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with
         *        server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to
         *        <code>"aws:kms"</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption
         *        Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a <code>SnsTopicArn</code> if
         * you want to do real time chaining to another streaming job and receive an Amazon SNS notifications each time
         * a data object is submitted by a worker.
         * </p>
         * <p>
         * If you provide an <code>SnsTopicArn</code> in <code>OutputConfig</code>, when workers complete labeling
         * tasks, Ground Truth will send labeling task output data to the SNS output topic you specify here.
         * </p>
         * <p>
         * To learn more, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data"
         * >Receive Output Data from a Streaming Labeling Job</a>.
         * </p>
         * 
         * @param snsTopicArn
         *        An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a
         *        <code>SnsTopicArn</code> if you want to do real time chaining to another streaming job and receive an
         *        Amazon SNS notifications each time a data object is submitted by a worker.</p>
         *        <p>
         *        If you provide an <code>SnsTopicArn</code> in <code>OutputConfig</code>, when workers complete
         *        labeling tasks, Ground Truth will send labeling task output data to the SNS output topic you specify
         *        here.
         *        </p>
         *        <p>
         *        To learn more, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data"
         *        >Receive Output Data from a Streaming Labeling Job</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3OutputPath;

        private String kmsKeyId;

        private String snsTopicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobOutputConfig model) {
            s3OutputPath(model.s3OutputPath);
            kmsKeyId(model.kmsKeyId);
            snsTopicArn(model.snsTopicArn);
        }

        public final String getS3OutputPath() {
            return s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        @Override
        public LabelingJobOutputConfig build() {
            return new LabelingJobOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
