/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceExperimentsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListInferenceExperimentsResponse.Builder, ListInferenceExperimentsResponse> {
    private static final SdkField<List<InferenceExperimentSummary>> INFERENCE_EXPERIMENTS_FIELD = SdkField
            .<List<InferenceExperimentSummary>> builder(MarshallingType.LIST)
            .memberName("InferenceExperiments")
            .getter(getter(ListInferenceExperimentsResponse::inferenceExperiments))
            .setter(setter(Builder::inferenceExperiments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExperiments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceExperimentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceExperimentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceExperimentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_EXPERIMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InferenceExperimentSummary> inferenceExperiments;

    private final String nextToken;

    private ListInferenceExperimentsResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceExperiments = builder.inferenceExperiments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceExperiments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInferenceExperiments() {
        return inferenceExperiments != null && !(inferenceExperiments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of inference experiments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceExperiments} method.
     * </p>
     * 
     * @return List of inference experiments.
     */
    public final List<InferenceExperimentSummary> inferenceExperiments() {
        return inferenceExperiments;
    }

    /**
     * <p>
     * The token to use when calling the next page of results.
     * </p>
     * 
     * @return The token to use when calling the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceExperiments() ? inferenceExperiments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceExperimentsResponse)) {
            return false;
        }
        ListInferenceExperimentsResponse other = (ListInferenceExperimentsResponse) obj;
        return hasInferenceExperiments() == other.hasInferenceExperiments()
                && Objects.equals(inferenceExperiments(), other.inferenceExperiments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceExperimentsResponse")
                .add("InferenceExperiments", hasInferenceExperiments() ? inferenceExperiments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceExperiments":
            return Optional.ofNullable(clazz.cast(inferenceExperiments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceExperimentsResponse, T> g) {
        return obj -> g.apply((ListInferenceExperimentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceExperimentsResponse> {
        /**
         * <p>
         * List of inference experiments.
         * </p>
         * 
         * @param inferenceExperiments
         *        List of inference experiments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceExperiments(Collection<InferenceExperimentSummary> inferenceExperiments);

        /**
         * <p>
         * List of inference experiments.
         * </p>
         * 
         * @param inferenceExperiments
         *        List of inference experiments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceExperiments(InferenceExperimentSummary... inferenceExperiments);

        /**
         * <p>
         * List of inference experiments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceExperiments(List<InferenceExperimentSummary>)}.
         * 
         * @param inferenceExperiments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceExperiments(java.util.Collection<InferenceExperimentSummary>)
         */
        Builder inferenceExperiments(Consumer<InferenceExperimentSummary.Builder>... inferenceExperiments);

        /**
         * <p>
         * The token to use when calling the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use when calling the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<InferenceExperimentSummary> inferenceExperiments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceExperimentsResponse model) {
            super(model);
            inferenceExperiments(model.inferenceExperiments);
            nextToken(model.nextToken);
        }

        public final List<InferenceExperimentSummary.Builder> getInferenceExperiments() {
            List<InferenceExperimentSummary.Builder> result = InferenceExperimentListCopier
                    .copyToBuilder(this.inferenceExperiments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceExperiments(Collection<InferenceExperimentSummary.BuilderImpl> inferenceExperiments) {
            this.inferenceExperiments = InferenceExperimentListCopier.copyFromBuilder(inferenceExperiments);
        }

        @Override
        public final Builder inferenceExperiments(Collection<InferenceExperimentSummary> inferenceExperiments) {
            this.inferenceExperiments = InferenceExperimentListCopier.copy(inferenceExperiments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExperiments(InferenceExperimentSummary... inferenceExperiments) {
            inferenceExperiments(Arrays.asList(inferenceExperiments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExperiments(Consumer<InferenceExperimentSummary.Builder>... inferenceExperiments) {
            inferenceExperiments(Stream.of(inferenceExperiments)
                    .map(c -> InferenceExperimentSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInferenceExperimentsResponse build() {
            return new ListInferenceExperimentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
