/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinition;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig;
import software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.ThroughputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFeatureGroupRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateFeatureGroupRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::featureGroupName)).setter(CreateFeatureGroupRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> RECORD_IDENTIFIER_FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordIdentifierFeatureName").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::recordIdentifierFeatureName)).setter(CreateFeatureGroupRequest.setter(Builder::recordIdentifierFeatureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIdentifierFeatureName").build()}).build();
    private static final SdkField<String> EVENT_TIME_FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventTimeFeatureName").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::eventTimeFeatureName)).setter(CreateFeatureGroupRequest.setter(Builder::eventTimeFeatureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeFeatureName").build()}).build();
    private static final SdkField<List<FeatureDefinition>> FEATURE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureDefinitions").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::featureDefinitions)).setter(CreateFeatureGroupRequest.setter(Builder::featureDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OnlineStoreConfig> ONLINE_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnlineStoreConfig").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::onlineStoreConfig)).setter(CreateFeatureGroupRequest.setter(Builder::onlineStoreConfig)).constructor(OnlineStoreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlineStoreConfig").build()}).build();
    private static final SdkField<OfflineStoreConfig> OFFLINE_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfflineStoreConfig").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::offlineStoreConfig)).setter(CreateFeatureGroupRequest.setter(Builder::offlineStoreConfig)).constructor(OfflineStoreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreConfig").build()}).build();
    private static final SdkField<ThroughputConfig> THROUGHPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThroughputConfig").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::throughputConfig)).setter(CreateFeatureGroupRequest.setter(Builder::throughputConfig)).constructor(ThroughputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::roleArn)).setter(CreateFeatureGroupRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::description)).setter(CreateFeatureGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFeatureGroupRequest.getter(CreateFeatureGroupRequest::tags)).setter(CreateFeatureGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, RECORD_IDENTIFIER_FEATURE_NAME_FIELD, EVENT_TIME_FEATURE_NAME_FIELD, FEATURE_DEFINITIONS_FIELD, ONLINE_STORE_CONFIG_FIELD, OFFLINE_STORE_CONFIG_FIELD, THROUGHPUT_CONFIG_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private final String featureGroupName;
    private final String recordIdentifierFeatureName;
    private final String eventTimeFeatureName;
    private final List<FeatureDefinition> featureDefinitions;
    private final OnlineStoreConfig onlineStoreConfig;
    private final OfflineStoreConfig offlineStoreConfig;
    private final ThroughputConfig throughputConfig;
    private final String roleArn;
    private final String description;
    private final List<Tag> tags;

    private CreateFeatureGroupRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierFeatureName = builder.recordIdentifierFeatureName;
        this.eventTimeFeatureName = builder.eventTimeFeatureName;
        this.featureDefinitions = builder.featureDefinitions;
        this.onlineStoreConfig = builder.onlineStoreConfig;
        this.offlineStoreConfig = builder.offlineStoreConfig;
        this.throughputConfig = builder.throughputConfig;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String recordIdentifierFeatureName() {
        return this.recordIdentifierFeatureName;
    }

    public final String eventTimeFeatureName() {
        return this.eventTimeFeatureName;
    }

    public final boolean hasFeatureDefinitions() {
        return this.featureDefinitions != null && !(this.featureDefinitions instanceof SdkAutoConstructList);
    }

    public final List<FeatureDefinition> featureDefinitions() {
        return this.featureDefinitions;
    }

    public final OnlineStoreConfig onlineStoreConfig() {
        return this.onlineStoreConfig;
    }

    public final OfflineStoreConfig offlineStoreConfig() {
        return this.offlineStoreConfig;
    }

    public final ThroughputConfig throughputConfig() {
        return this.throughputConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordIdentifierFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimeFeatureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureDefinitions() ? this.featureDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeatureGroupRequest)) {
            return false;
        }
        CreateFeatureGroupRequest other = (CreateFeatureGroupRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.recordIdentifierFeatureName(), other.recordIdentifierFeatureName()) && Objects.equals(this.eventTimeFeatureName(), other.eventTimeFeatureName()) && this.hasFeatureDefinitions() == other.hasFeatureDefinitions() && Objects.equals(this.featureDefinitions(), other.featureDefinitions()) && Objects.equals(this.onlineStoreConfig(), other.onlineStoreConfig()) && Objects.equals(this.offlineStoreConfig(), other.offlineStoreConfig()) && Objects.equals(this.throughputConfig(), other.throughputConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFeatureGroupRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("RecordIdentifierFeatureName", (Object)this.recordIdentifierFeatureName()).add("EventTimeFeatureName", (Object)this.eventTimeFeatureName()).add("FeatureDefinitions", this.hasFeatureDefinitions() ? this.featureDefinitions() : null).add("OnlineStoreConfig", (Object)this.onlineStoreConfig()).add("OfflineStoreConfig", (Object)this.offlineStoreConfig()).add("ThroughputConfig", (Object)this.throughputConfig()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "RecordIdentifierFeatureName": {
                return Optional.ofNullable(clazz.cast(this.recordIdentifierFeatureName()));
            }
            case "EventTimeFeatureName": {
                return Optional.ofNullable(clazz.cast(this.eventTimeFeatureName()));
            }
            case "FeatureDefinitions": {
                return Optional.ofNullable(clazz.cast(this.featureDefinitions()));
            }
            case "OnlineStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.onlineStoreConfig()));
            }
            case "OfflineStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.offlineStoreConfig()));
            }
            case "ThroughputConfig": {
                return Optional.ofNullable(clazz.cast(this.throughputConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFeatureGroupRequest, T> g) {
        return obj -> g.apply((CreateFeatureGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private String recordIdentifierFeatureName;
        private String eventTimeFeatureName;
        private List<FeatureDefinition> featureDefinitions = DefaultSdkAutoConstructList.getInstance();
        private OnlineStoreConfig onlineStoreConfig;
        private OfflineStoreConfig offlineStoreConfig;
        private ThroughputConfig throughputConfig;
        private String roleArn;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFeatureGroupRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.recordIdentifierFeatureName(model.recordIdentifierFeatureName);
            this.eventTimeFeatureName(model.eventTimeFeatureName);
            this.featureDefinitions(model.featureDefinitions);
            this.onlineStoreConfig(model.onlineStoreConfig);
            this.offlineStoreConfig(model.offlineStoreConfig);
            this.throughputConfig(model.throughputConfig);
            this.roleArn(model.roleArn);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierFeatureName() {
            return this.recordIdentifierFeatureName;
        }

        public final void setRecordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
        }

        @Override
        public final Builder recordIdentifierFeatureName(String recordIdentifierFeatureName) {
            this.recordIdentifierFeatureName = recordIdentifierFeatureName;
            return this;
        }

        public final String getEventTimeFeatureName() {
            return this.eventTimeFeatureName;
        }

        public final void setEventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
        }

        @Override
        public final Builder eventTimeFeatureName(String eventTimeFeatureName) {
            this.eventTimeFeatureName = eventTimeFeatureName;
            return this;
        }

        public final List<FeatureDefinition.Builder> getFeatureDefinitions() {
            List<FeatureDefinition.Builder> result = FeatureDefinitionsCopier.copyToBuilder(this.featureDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatureDefinitions(Collection<FeatureDefinition.BuilderImpl> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copyFromBuilder(featureDefinitions);
        }

        @Override
        public final Builder featureDefinitions(Collection<FeatureDefinition> featureDefinitions) {
            this.featureDefinitions = FeatureDefinitionsCopier.copy(featureDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(FeatureDefinition ... featureDefinitions) {
            this.featureDefinitions(Arrays.asList(featureDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureDefinitions(Consumer<FeatureDefinition.Builder> ... featureDefinitions) {
            this.featureDefinitions(Stream.of(featureDefinitions).map(c -> (FeatureDefinition)((FeatureDefinition.Builder)FeatureDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OnlineStoreConfig.Builder getOnlineStoreConfig() {
            return this.onlineStoreConfig != null ? this.onlineStoreConfig.toBuilder() : null;
        }

        public final void setOnlineStoreConfig(OnlineStoreConfig.BuilderImpl onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig != null ? onlineStoreConfig.build() : null;
        }

        @Override
        public final Builder onlineStoreConfig(OnlineStoreConfig onlineStoreConfig) {
            this.onlineStoreConfig = onlineStoreConfig;
            return this;
        }

        public final OfflineStoreConfig.Builder getOfflineStoreConfig() {
            return this.offlineStoreConfig != null ? this.offlineStoreConfig.toBuilder() : null;
        }

        public final void setOfflineStoreConfig(OfflineStoreConfig.BuilderImpl offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig != null ? offlineStoreConfig.build() : null;
        }

        @Override
        public final Builder offlineStoreConfig(OfflineStoreConfig offlineStoreConfig) {
            this.offlineStoreConfig = offlineStoreConfig;
            return this;
        }

        public final ThroughputConfig.Builder getThroughputConfig() {
            return this.throughputConfig != null ? this.throughputConfig.toBuilder() : null;
        }

        public final void setThroughputConfig(ThroughputConfig.BuilderImpl throughputConfig) {
            this.throughputConfig = throughputConfig != null ? throughputConfig.build() : null;
        }

        @Override
        public final Builder throughputConfig(ThroughputConfig throughputConfig) {
            this.throughputConfig = throughputConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFeatureGroupRequest build() {
            return new CreateFeatureGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFeatureGroupRequest> {
        public Builder featureGroupName(String var1);

        public Builder recordIdentifierFeatureName(String var1);

        public Builder eventTimeFeatureName(String var1);

        public Builder featureDefinitions(Collection<FeatureDefinition> var1);

        public Builder featureDefinitions(FeatureDefinition ... var1);

        public Builder featureDefinitions(Consumer<FeatureDefinition.Builder> ... var1);

        public Builder onlineStoreConfig(OnlineStoreConfig var1);

        default public Builder onlineStoreConfig(Consumer<OnlineStoreConfig.Builder> onlineStoreConfig) {
            return this.onlineStoreConfig((OnlineStoreConfig)((OnlineStoreConfig.Builder)OnlineStoreConfig.builder().applyMutation(onlineStoreConfig)).build());
        }

        public Builder offlineStoreConfig(OfflineStoreConfig var1);

        default public Builder offlineStoreConfig(Consumer<OfflineStoreConfig.Builder> offlineStoreConfig) {
            return this.offlineStoreConfig((OfflineStoreConfig)((OfflineStoreConfig.Builder)OfflineStoreConfig.builder().applyMutation(offlineStoreConfig)).build());
        }

        public Builder throughputConfig(ThroughputConfig var1);

        default public Builder throughputConfig(Consumer<ThroughputConfig.Builder> throughputConfig) {
            return this.throughputConfig((ThroughputConfig)((ThroughputConfig.Builder)ThroughputConfig.builder().applyMutation(throughputConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

