/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse;

public class ListDeviceFleetsPublisher
implements SdkPublisher<ListDeviceFleetsResponse> {
    private final SageMakerAsyncClient client;
    private final ListDeviceFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeviceFleetsPublisher(SageMakerAsyncClient client, ListDeviceFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeviceFleetsPublisher(SageMakerAsyncClient client, ListDeviceFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeviceFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeviceFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeviceFleetSummary> deviceFleetSummaries() {
        Function<ListDeviceFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deviceFleetSummaries() != null) {
                return response.deviceFleetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeviceFleetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeviceFleetsResponseFetcher
    implements AsyncPageFetcher<ListDeviceFleetsResponse> {
        private ListDeviceFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeviceFleetsResponse> nextPage(ListDeviceFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceFleetsPublisher.this.client.listDeviceFleets(ListDeviceFleetsPublisher.this.firstRequest);
            }
            return ListDeviceFleetsPublisher.this.client.listDeviceFleets((ListDeviceFleetsRequest)((Object)ListDeviceFleetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

