/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A file system, created by you, that you assign to a user profile or space for an Amazon SageMaker Domain. Permitted
 * users can access this file system in Amazon SageMaker Studio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomFileSystem implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomFileSystem.Builder, CustomFileSystem> {
    private static final SdkField<EFSFileSystem> EFS_FILE_SYSTEM_FIELD = SdkField
            .<EFSFileSystem> builder(MarshallingType.SDK_POJO).memberName("EFSFileSystem")
            .getter(getter(CustomFileSystem::efsFileSystem)).setter(setter(Builder::efsFileSystem))
            .constructor(EFSFileSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EFSFileSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FILE_SYSTEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final EFSFileSystem efsFileSystem;

    private final Type type;

    private CustomFileSystem(BuilderImpl builder) {
        this.efsFileSystem = builder.efsFileSystem;
        this.type = builder.type;
    }

    /**
     * <p>
     * A custom file system in Amazon EFS.
     * </p>
     * 
     * @return A custom file system in Amazon EFS.
     */
    public final EFSFileSystem efsFileSystem() {
        return efsFileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(efsFileSystem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFileSystem)) {
            return false;
        }
        CustomFileSystem other = (CustomFileSystem) obj;
        return Objects.equals(efsFileSystem(), other.efsFileSystem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomFileSystem").add("EFSFileSystem", efsFileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EFSFileSystem":
            return Optional.ofNullable(clazz.cast(efsFileSystem()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #efsFileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon EFS.
     * </p>
     * 
     * @param efsFileSystem
     *        A custom file system in Amazon EFS.
     */
    public static CustomFileSystem fromEfsFileSystem(EFSFileSystem efsFileSystem) {
        return builder().efsFileSystem(efsFileSystem).build();
    }

    /**
     * Create an instance of this class with {@link #efsFileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon EFS.
     * </p>
     * 
     * @param efsFileSystem
     *        A custom file system in Amazon EFS.
     */
    public static CustomFileSystem fromEfsFileSystem(Consumer<EFSFileSystem.Builder> efsFileSystem) {
        EFSFileSystem.Builder builder = EFSFileSystem.builder();
        efsFileSystem.accept(builder);
        return fromEfsFileSystem(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomFileSystem, T> g) {
        return obj -> g.apply((CustomFileSystem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomFileSystem> {
        /**
         * <p>
         * A custom file system in Amazon EFS.
         * </p>
         * 
         * @param efsFileSystem
         *        A custom file system in Amazon EFS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFileSystem(EFSFileSystem efsFileSystem);

        /**
         * <p>
         * A custom file system in Amazon EFS.
         * </p>
         * This is a convenience method that creates an instance of the {@link EFSFileSystem.Builder} avoiding the need
         * to create one manually via {@link EFSFileSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EFSFileSystem.Builder#build()} is called immediately and its
         * result is passed to {@link #efsFileSystem(EFSFileSystem)}.
         * 
         * @param efsFileSystem
         *        a consumer that will call methods on {@link EFSFileSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsFileSystem(EFSFileSystem)
         */
        default Builder efsFileSystem(Consumer<EFSFileSystem.Builder> efsFileSystem) {
            return efsFileSystem(EFSFileSystem.builder().applyMutation(efsFileSystem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EFSFileSystem efsFileSystem;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFileSystem model) {
            efsFileSystem(model.efsFileSystem);
        }

        public final EFSFileSystem.Builder getEfsFileSystem() {
            return efsFileSystem != null ? efsFileSystem.toBuilder() : null;
        }

        public final void setEfsFileSystem(EFSFileSystem.BuilderImpl efsFileSystem) {
            Object oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem != null ? efsFileSystem.build() : null;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
        }

        @Override
        public final Builder efsFileSystem(EFSFileSystem efsFileSystem) {
            Object oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
            return this;
        }

        @Override
        public CustomFileSystem build() {
            return new CustomFileSystem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomFileSystem#type()
     */
    public enum Type {
        EFS_FILE_SYSTEM,

        UNKNOWN_TO_SDK_VERSION
    }
}
