/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStudioLifecycleConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<DeleteStudioLifecycleConfigRequest.Builder, DeleteStudioLifecycleConfigRequest> {
    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigName")
            .getter(getter(DeleteStudioLifecycleConfigRequest::studioLifecycleConfigName))
            .setter(setter(Builder::studioLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STUDIO_LIFECYCLE_CONFIG_NAME_FIELD));

    private final String studioLifecycleConfigName;

    private DeleteStudioLifecycleConfigRequest(BuilderImpl builder) {
        super(builder);
        this.studioLifecycleConfigName = builder.studioLifecycleConfigName;
    }

    /**
     * <p>
     * The name of the Amazon SageMaker Studio Lifecycle Configuration to delete.
     * </p>
     * 
     * @return The name of the Amazon SageMaker Studio Lifecycle Configuration to delete.
     */
    public final String studioLifecycleConfigName() {
        return studioLifecycleConfigName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStudioLifecycleConfigRequest)) {
            return false;
        }
        DeleteStudioLifecycleConfigRequest other = (DeleteStudioLifecycleConfigRequest) obj;
        return Objects.equals(studioLifecycleConfigName(), other.studioLifecycleConfigName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteStudioLifecycleConfigRequest")
                .add("StudioLifecycleConfigName", studioLifecycleConfigName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteStudioLifecycleConfigRequest, T> g) {
        return obj -> g.apply((DeleteStudioLifecycleConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteStudioLifecycleConfigRequest> {
        /**
         * <p>
         * The name of the Amazon SageMaker Studio Lifecycle Configuration to delete.
         * </p>
         * 
         * @param studioLifecycleConfigName
         *        The name of the Amazon SageMaker Studio Lifecycle Configuration to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigName(String studioLifecycleConfigName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String studioLifecycleConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStudioLifecycleConfigRequest model) {
            super(model);
            studioLifecycleConfigName(model.studioLifecycleConfigName);
        }

        public final String getStudioLifecycleConfigName() {
            return studioLifecycleConfigName;
        }

        public final void setStudioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
        }

        @Override
        public final Builder studioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStudioLifecycleConfigRequest build() {
            return new DeleteStudioLifecycleConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
