/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a breakdown of the number of objects labeled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelCounters implements SdkPojo, Serializable, ToCopyableBuilder<LabelCounters.Builder, LabelCounters> {
    private static final SdkField<Integer> TOTAL_LABELED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalLabeled").getter(getter(LabelCounters::totalLabeled)).setter(setter(Builder::totalLabeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLabeled").build()).build();

    private static final SdkField<Integer> HUMAN_LABELED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HumanLabeled").getter(getter(LabelCounters::humanLabeled)).setter(setter(Builder::humanLabeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLabeled").build()).build();

    private static final SdkField<Integer> MACHINE_LABELED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MachineLabeled").getter(getter(LabelCounters::machineLabeled)).setter(setter(Builder::machineLabeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MachineLabeled").build()).build();

    private static final SdkField<Integer> FAILED_NON_RETRYABLE_ERROR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedNonRetryableError").getter(getter(LabelCounters::failedNonRetryableError))
            .setter(setter(Builder::failedNonRetryableError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedNonRetryableError").build())
            .build();

    private static final SdkField<Integer> UNLABELED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Unlabeled").getter(getter(LabelCounters::unlabeled)).setter(setter(Builder::unlabeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unlabeled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_LABELED_FIELD,
            HUMAN_LABELED_FIELD, MACHINE_LABELED_FIELD, FAILED_NON_RETRYABLE_ERROR_FIELD, UNLABELED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalLabeled;

    private final Integer humanLabeled;

    private final Integer machineLabeled;

    private final Integer failedNonRetryableError;

    private final Integer unlabeled;

    private LabelCounters(BuilderImpl builder) {
        this.totalLabeled = builder.totalLabeled;
        this.humanLabeled = builder.humanLabeled;
        this.machineLabeled = builder.machineLabeled;
        this.failedNonRetryableError = builder.failedNonRetryableError;
        this.unlabeled = builder.unlabeled;
    }

    /**
     * <p>
     * The total number of objects labeled.
     * </p>
     * 
     * @return The total number of objects labeled.
     */
    public final Integer totalLabeled() {
        return totalLabeled;
    }

    /**
     * <p>
     * The total number of objects labeled by a human worker.
     * </p>
     * 
     * @return The total number of objects labeled by a human worker.
     */
    public final Integer humanLabeled() {
        return humanLabeled;
    }

    /**
     * <p>
     * The total number of objects labeled by automated data labeling.
     * </p>
     * 
     * @return The total number of objects labeled by automated data labeling.
     */
    public final Integer machineLabeled() {
        return machineLabeled;
    }

    /**
     * <p>
     * The total number of objects that could not be labeled due to an error.
     * </p>
     * 
     * @return The total number of objects that could not be labeled due to an error.
     */
    public final Integer failedNonRetryableError() {
        return failedNonRetryableError;
    }

    /**
     * <p>
     * The total number of objects not yet labeled.
     * </p>
     * 
     * @return The total number of objects not yet labeled.
     */
    public final Integer unlabeled() {
        return unlabeled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalLabeled());
        hashCode = 31 * hashCode + Objects.hashCode(humanLabeled());
        hashCode = 31 * hashCode + Objects.hashCode(machineLabeled());
        hashCode = 31 * hashCode + Objects.hashCode(failedNonRetryableError());
        hashCode = 31 * hashCode + Objects.hashCode(unlabeled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelCounters)) {
            return false;
        }
        LabelCounters other = (LabelCounters) obj;
        return Objects.equals(totalLabeled(), other.totalLabeled()) && Objects.equals(humanLabeled(), other.humanLabeled())
                && Objects.equals(machineLabeled(), other.machineLabeled())
                && Objects.equals(failedNonRetryableError(), other.failedNonRetryableError())
                && Objects.equals(unlabeled(), other.unlabeled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelCounters").add("TotalLabeled", totalLabeled()).add("HumanLabeled", humanLabeled())
                .add("MachineLabeled", machineLabeled()).add("FailedNonRetryableError", failedNonRetryableError())
                .add("Unlabeled", unlabeled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalLabeled":
            return Optional.ofNullable(clazz.cast(totalLabeled()));
        case "HumanLabeled":
            return Optional.ofNullable(clazz.cast(humanLabeled()));
        case "MachineLabeled":
            return Optional.ofNullable(clazz.cast(machineLabeled()));
        case "FailedNonRetryableError":
            return Optional.ofNullable(clazz.cast(failedNonRetryableError()));
        case "Unlabeled":
            return Optional.ofNullable(clazz.cast(unlabeled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelCounters, T> g) {
        return obj -> g.apply((LabelCounters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelCounters> {
        /**
         * <p>
         * The total number of objects labeled.
         * </p>
         * 
         * @param totalLabeled
         *        The total number of objects labeled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalLabeled(Integer totalLabeled);

        /**
         * <p>
         * The total number of objects labeled by a human worker.
         * </p>
         * 
         * @param humanLabeled
         *        The total number of objects labeled by a human worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLabeled(Integer humanLabeled);

        /**
         * <p>
         * The total number of objects labeled by automated data labeling.
         * </p>
         * 
         * @param machineLabeled
         *        The total number of objects labeled by automated data labeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder machineLabeled(Integer machineLabeled);

        /**
         * <p>
         * The total number of objects that could not be labeled due to an error.
         * </p>
         * 
         * @param failedNonRetryableError
         *        The total number of objects that could not be labeled due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedNonRetryableError(Integer failedNonRetryableError);

        /**
         * <p>
         * The total number of objects not yet labeled.
         * </p>
         * 
         * @param unlabeled
         *        The total number of objects not yet labeled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlabeled(Integer unlabeled);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalLabeled;

        private Integer humanLabeled;

        private Integer machineLabeled;

        private Integer failedNonRetryableError;

        private Integer unlabeled;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelCounters model) {
            totalLabeled(model.totalLabeled);
            humanLabeled(model.humanLabeled);
            machineLabeled(model.machineLabeled);
            failedNonRetryableError(model.failedNonRetryableError);
            unlabeled(model.unlabeled);
        }

        public final Integer getTotalLabeled() {
            return totalLabeled;
        }

        public final void setTotalLabeled(Integer totalLabeled) {
            this.totalLabeled = totalLabeled;
        }

        @Override
        public final Builder totalLabeled(Integer totalLabeled) {
            this.totalLabeled = totalLabeled;
            return this;
        }

        public final Integer getHumanLabeled() {
            return humanLabeled;
        }

        public final void setHumanLabeled(Integer humanLabeled) {
            this.humanLabeled = humanLabeled;
        }

        @Override
        public final Builder humanLabeled(Integer humanLabeled) {
            this.humanLabeled = humanLabeled;
            return this;
        }

        public final Integer getMachineLabeled() {
            return machineLabeled;
        }

        public final void setMachineLabeled(Integer machineLabeled) {
            this.machineLabeled = machineLabeled;
        }

        @Override
        public final Builder machineLabeled(Integer machineLabeled) {
            this.machineLabeled = machineLabeled;
            return this;
        }

        public final Integer getFailedNonRetryableError() {
            return failedNonRetryableError;
        }

        public final void setFailedNonRetryableError(Integer failedNonRetryableError) {
            this.failedNonRetryableError = failedNonRetryableError;
        }

        @Override
        public final Builder failedNonRetryableError(Integer failedNonRetryableError) {
            this.failedNonRetryableError = failedNonRetryableError;
            return this;
        }

        public final Integer getUnlabeled() {
            return unlabeled;
        }

        public final void setUnlabeled(Integer unlabeled) {
            this.unlabeled = unlabeled;
        }

        @Override
        public final Builder unlabeled(Integer unlabeled) {
            this.unlabeled = unlabeled;
            return this;
        }

        @Override
        public LabelCounters build() {
            return new LabelCounters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
