/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A monitoring schedule for a model displayed in the Amazon SageMaker Model Dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDashboardMonitoringSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDashboardMonitoringSchedule.Builder, ModelDashboardMonitoringSchedule> {
    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleArn").getter(getter(ModelDashboardMonitoringSchedule::monitoringScheduleArn))
            .setter(setter(Builder::monitoringScheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(ModelDashboardMonitoringSchedule::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleStatus")
            .getter(getter(ModelDashboardMonitoringSchedule::monitoringScheduleStatusAsString))
            .setter(setter(Builder::monitoringScheduleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleStatus").build())
            .build();

    private static final SdkField<String> MONITORING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringType").getter(getter(ModelDashboardMonitoringSchedule::monitoringTypeAsString))
            .setter(setter(Builder::monitoringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringType").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(ModelDashboardMonitoringSchedule::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelDashboardMonitoringSchedule::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ModelDashboardMonitoringSchedule::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<MonitoringScheduleConfig> MONITORING_SCHEDULE_CONFIG_FIELD = SdkField
            .<MonitoringScheduleConfig> builder(MarshallingType.SDK_POJO).memberName("MonitoringScheduleConfig")
            .getter(getter(ModelDashboardMonitoringSchedule::monitoringScheduleConfig))
            .setter(setter(Builder::monitoringScheduleConfig)).constructor(MonitoringScheduleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleConfig").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(ModelDashboardMonitoringSchedule::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<List<MonitoringAlertSummary>> MONITORING_ALERT_SUMMARIES_FIELD = SdkField
            .<List<MonitoringAlertSummary>> builder(MarshallingType.LIST)
            .memberName("MonitoringAlertSummaries")
            .getter(getter(ModelDashboardMonitoringSchedule::monitoringAlertSummaries))
            .setter(setter(Builder::monitoringAlertSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitoringAlertSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitoringAlertSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MonitoringExecutionSummary> LAST_MONITORING_EXECUTION_SUMMARY_FIELD = SdkField
            .<MonitoringExecutionSummary> builder(MarshallingType.SDK_POJO)
            .memberName("LastMonitoringExecutionSummary")
            .getter(getter(ModelDashboardMonitoringSchedule::lastMonitoringExecutionSummary))
            .setter(setter(Builder::lastMonitoringExecutionSummary))
            .constructor(MonitoringExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMonitoringExecutionSummary")
                    .build()).build();

    private static final SdkField<BatchTransformInput> BATCH_TRANSFORM_INPUT_FIELD = SdkField
            .<BatchTransformInput> builder(MarshallingType.SDK_POJO).memberName("BatchTransformInput")
            .getter(getter(ModelDashboardMonitoringSchedule::batchTransformInput)).setter(setter(Builder::batchTransformInput))
            .constructor(BatchTransformInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchTransformInput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_ARN_FIELD,
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_STATUS_FIELD, MONITORING_TYPE_FIELD, FAILURE_REASON_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MONITORING_SCHEDULE_CONFIG_FIELD, ENDPOINT_NAME_FIELD,
            MONITORING_ALERT_SUMMARIES_FIELD, LAST_MONITORING_EXECUTION_SUMMARY_FIELD, BATCH_TRANSFORM_INPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String monitoringScheduleArn;

    private final String monitoringScheduleName;

    private final String monitoringScheduleStatus;

    private final String monitoringType;

    private final String failureReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final MonitoringScheduleConfig monitoringScheduleConfig;

    private final String endpointName;

    private final List<MonitoringAlertSummary> monitoringAlertSummaries;

    private final MonitoringExecutionSummary lastMonitoringExecutionSummary;

    private final BatchTransformInput batchTransformInput;

    private ModelDashboardMonitoringSchedule(BuilderImpl builder) {
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
        this.monitoringType = builder.monitoringType;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringScheduleConfig = builder.monitoringScheduleConfig;
        this.endpointName = builder.endpointName;
        this.monitoringAlertSummaries = builder.monitoringAlertSummaries;
        this.lastMonitoringExecutionSummary = builder.lastMonitoringExecutionSummary;
        this.batchTransformInput = builder.batchTransformInput;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a monitoring schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a monitoring schedule.
     */
    public final String monitoringScheduleArn() {
        return monitoringScheduleArn;
    }

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     * 
     * @return The name of a monitoring schedule.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The status of the monitoring schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule.
     * @see ScheduleStatus
     */
    public final ScheduleStatus monitoringScheduleStatus() {
        return ScheduleStatus.fromValue(monitoringScheduleStatus);
    }

    /**
     * <p>
     * The status of the monitoring schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule.
     * @see ScheduleStatus
     */
    public final String monitoringScheduleStatusAsString() {
        return monitoringScheduleStatus;
    }

    /**
     * <p>
     * The monitor type of a model monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoringType}
     * will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitoringTypeAsString}.
     * </p>
     * 
     * @return The monitor type of a model monitor.
     * @see MonitoringType
     */
    public final MonitoringType monitoringType() {
        return MonitoringType.fromValue(monitoringType);
    }

    /**
     * <p>
     * The monitor type of a model monitor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoringType}
     * will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitoringTypeAsString}.
     * </p>
     * 
     * @return The monitor type of a model monitor.
     * @see MonitoringType
     */
    public final String monitoringTypeAsString() {
        return monitoringType;
    }

    /**
     * <p>
     * If a monitoring job failed, provides the reason.
     * </p>
     * 
     * @return If a monitoring job failed, provides the reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * A timestamp that indicates when the monitoring schedule was created.
     * </p>
     * 
     * @return A timestamp that indicates when the monitoring schedule was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that indicates when the monitoring schedule was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when the monitoring schedule was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the MonitoringScheduleConfig property for this object.
     * 
     * @return The value of the MonitoringScheduleConfig property for this object.
     */
    public final MonitoringScheduleConfig monitoringScheduleConfig() {
        return monitoringScheduleConfig;
    }

    /**
     * <p>
     * The endpoint which is monitored.
     * </p>
     * 
     * @return The endpoint which is monitored.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitoringAlertSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMonitoringAlertSummaries() {
        return monitoringAlertSummaries != null && !(monitoringAlertSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON array where each element is a summary for a monitoring alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitoringAlertSummaries} method.
     * </p>
     * 
     * @return A JSON array where each element is a summary for a monitoring alert.
     */
    public final List<MonitoringAlertSummary> monitoringAlertSummaries() {
        return monitoringAlertSummaries;
    }

    /**
     * Returns the value of the LastMonitoringExecutionSummary property for this object.
     * 
     * @return The value of the LastMonitoringExecutionSummary property for this object.
     */
    public final MonitoringExecutionSummary lastMonitoringExecutionSummary() {
        return lastMonitoringExecutionSummary;
    }

    /**
     * Returns the value of the BatchTransformInput property for this object.
     * 
     * @return The value of the BatchTransformInput property for this object.
     */
    public final BatchTransformInput batchTransformInput() {
        return batchTransformInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitoringAlertSummaries() ? monitoringAlertSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastMonitoringExecutionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(batchTransformInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDashboardMonitoringSchedule)) {
            return false;
        }
        ModelDashboardMonitoringSchedule other = (ModelDashboardMonitoringSchedule) obj;
        return Objects.equals(monitoringScheduleArn(), other.monitoringScheduleArn())
                && Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringScheduleStatusAsString(), other.monitoringScheduleStatusAsString())
                && Objects.equals(monitoringTypeAsString(), other.monitoringTypeAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(monitoringScheduleConfig(), other.monitoringScheduleConfig())
                && Objects.equals(endpointName(), other.endpointName())
                && hasMonitoringAlertSummaries() == other.hasMonitoringAlertSummaries()
                && Objects.equals(monitoringAlertSummaries(), other.monitoringAlertSummaries())
                && Objects.equals(lastMonitoringExecutionSummary(), other.lastMonitoringExecutionSummary())
                && Objects.equals(batchTransformInput(), other.batchTransformInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDashboardMonitoringSchedule").add("MonitoringScheduleArn", monitoringScheduleArn())
                .add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringScheduleStatus", monitoringScheduleStatusAsString())
                .add("MonitoringType", monitoringTypeAsString()).add("FailureReason", failureReason())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("MonitoringScheduleConfig", monitoringScheduleConfig()).add("EndpointName", endpointName())
                .add("MonitoringAlertSummaries", hasMonitoringAlertSummaries() ? monitoringAlertSummaries() : null)
                .add("LastMonitoringExecutionSummary", lastMonitoringExecutionSummary())
                .add("BatchTransformInput", batchTransformInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleArn":
            return Optional.ofNullable(clazz.cast(monitoringScheduleArn()));
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringScheduleStatus":
            return Optional.ofNullable(clazz.cast(monitoringScheduleStatusAsString()));
        case "MonitoringType":
            return Optional.ofNullable(clazz.cast(monitoringTypeAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "MonitoringScheduleConfig":
            return Optional.ofNullable(clazz.cast(monitoringScheduleConfig()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "MonitoringAlertSummaries":
            return Optional.ofNullable(clazz.cast(monitoringAlertSummaries()));
        case "LastMonitoringExecutionSummary":
            return Optional.ofNullable(clazz.cast(lastMonitoringExecutionSummary()));
        case "BatchTransformInput":
            return Optional.ofNullable(clazz.cast(batchTransformInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDashboardMonitoringSchedule, T> g) {
        return obj -> g.apply((ModelDashboardMonitoringSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDashboardMonitoringSchedule> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleArn
         *        The Amazon Resource Name (ARN) of a monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleArn(String monitoringScheduleArn);

        /**
         * <p>
         * The name of a monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of a monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The status of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(String monitoringScheduleStatus);

        /**
         * <p>
         * The status of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus);

        /**
         * <p>
         * The monitor type of a model monitor.
         * </p>
         * 
         * @param monitoringType
         *        The monitor type of a model monitor.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringType(String monitoringType);

        /**
         * <p>
         * The monitor type of a model monitor.
         * </p>
         * 
         * @param monitoringType
         *        The monitor type of a model monitor.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringType(MonitoringType monitoringType);

        /**
         * <p>
         * If a monitoring job failed, provides the reason.
         * </p>
         * 
         * @param failureReason
         *        If a monitoring job failed, provides the reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * A timestamp that indicates when the monitoring schedule was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when the monitoring schedule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that indicates when the monitoring schedule was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that indicates when the monitoring schedule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the MonitoringScheduleConfig property for this object.
         *
         * @param monitoringScheduleConfig
         *        The new value for the MonitoringScheduleConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig);

        /**
         * Sets the value of the MonitoringScheduleConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringScheduleConfig.Builder}
         * avoiding the need to create one manually via {@link MonitoringScheduleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringScheduleConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringScheduleConfig(MonitoringScheduleConfig)}.
         * 
         * @param monitoringScheduleConfig
         *        a consumer that will call methods on {@link MonitoringScheduleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringScheduleConfig(MonitoringScheduleConfig)
         */
        default Builder monitoringScheduleConfig(Consumer<MonitoringScheduleConfig.Builder> monitoringScheduleConfig) {
            return monitoringScheduleConfig(MonitoringScheduleConfig.builder().applyMutation(monitoringScheduleConfig).build());
        }

        /**
         * <p>
         * The endpoint which is monitored.
         * </p>
         * 
         * @param endpointName
         *        The endpoint which is monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * A JSON array where each element is a summary for a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertSummaries
         *        A JSON array where each element is a summary for a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertSummaries(Collection<MonitoringAlertSummary> monitoringAlertSummaries);

        /**
         * <p>
         * A JSON array where each element is a summary for a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertSummaries
         *        A JSON array where each element is a summary for a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertSummaries(MonitoringAlertSummary... monitoringAlertSummaries);

        /**
         * <p>
         * A JSON array where each element is a summary for a monitoring alert.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoringAlertSummaries(List<MonitoringAlertSummary>)}.
         * 
         * @param monitoringAlertSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringAlertSummaries(java.util.Collection<MonitoringAlertSummary>)
         */
        Builder monitoringAlertSummaries(Consumer<MonitoringAlertSummary.Builder>... monitoringAlertSummaries);

        /**
         * Sets the value of the LastMonitoringExecutionSummary property for this object.
         *
         * @param lastMonitoringExecutionSummary
         *        The new value for the LastMonitoringExecutionSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary lastMonitoringExecutionSummary);

        /**
         * Sets the value of the LastMonitoringExecutionSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringExecutionSummary.Builder}
         * avoiding the need to create one manually via {@link MonitoringExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringExecutionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #lastMonitoringExecutionSummary(MonitoringExecutionSummary)}.
         * 
         * @param lastMonitoringExecutionSummary
         *        a consumer that will call methods on {@link MonitoringExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastMonitoringExecutionSummary(MonitoringExecutionSummary)
         */
        default Builder lastMonitoringExecutionSummary(Consumer<MonitoringExecutionSummary.Builder> lastMonitoringExecutionSummary) {
            return lastMonitoringExecutionSummary(MonitoringExecutionSummary.builder()
                    .applyMutation(lastMonitoringExecutionSummary).build());
        }

        /**
         * Sets the value of the BatchTransformInput property for this object.
         *
         * @param batchTransformInput
         *        The new value for the BatchTransformInput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchTransformInput(BatchTransformInput batchTransformInput);

        /**
         * Sets the value of the BatchTransformInput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BatchTransformInput.Builder} avoiding the
         * need to create one manually via {@link BatchTransformInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchTransformInput.Builder#build()} is called immediately and
         * its result is passed to {@link #batchTransformInput(BatchTransformInput)}.
         * 
         * @param batchTransformInput
         *        a consumer that will call methods on {@link BatchTransformInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchTransformInput(BatchTransformInput)
         */
        default Builder batchTransformInput(Consumer<BatchTransformInput.Builder> batchTransformInput) {
            return batchTransformInput(BatchTransformInput.builder().applyMutation(batchTransformInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String monitoringScheduleArn;

        private String monitoringScheduleName;

        private String monitoringScheduleStatus;

        private String monitoringType;

        private String failureReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private MonitoringScheduleConfig monitoringScheduleConfig;

        private String endpointName;

        private List<MonitoringAlertSummary> monitoringAlertSummaries = DefaultSdkAutoConstructList.getInstance();

        private MonitoringExecutionSummary lastMonitoringExecutionSummary;

        private BatchTransformInput batchTransformInput;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDashboardMonitoringSchedule model) {
            monitoringScheduleArn(model.monitoringScheduleArn);
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringScheduleStatus(model.monitoringScheduleStatus);
            monitoringType(model.monitoringType);
            failureReason(model.failureReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            monitoringScheduleConfig(model.monitoringScheduleConfig);
            endpointName(model.endpointName);
            monitoringAlertSummaries(model.monitoringAlertSummaries);
            lastMonitoringExecutionSummary(model.lastMonitoringExecutionSummary);
            batchTransformInput(model.batchTransformInput);
        }

        public final String getMonitoringScheduleArn() {
            return monitoringScheduleArn;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringScheduleStatus() {
            return monitoringScheduleStatus;
        }

        public final void setMonitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
        }

        @Override
        public final Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        @Override
        public final Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus) {
            this.monitoringScheduleStatus(monitoringScheduleStatus == null ? null : monitoringScheduleStatus.toString());
            return this;
        }

        public final String getMonitoringType() {
            return monitoringType;
        }

        public final void setMonitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
        }

        @Override
        public final Builder monitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
            return this;
        }

        @Override
        public final Builder monitoringType(MonitoringType monitoringType) {
            this.monitoringType(monitoringType == null ? null : monitoringType.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final MonitoringScheduleConfig.Builder getMonitoringScheduleConfig() {
            return monitoringScheduleConfig != null ? monitoringScheduleConfig.toBuilder() : null;
        }

        public final void setMonitoringScheduleConfig(MonitoringScheduleConfig.BuilderImpl monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig != null ? monitoringScheduleConfig.build() : null;
        }

        @Override
        public final Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final List<MonitoringAlertSummary.Builder> getMonitoringAlertSummaries() {
            List<MonitoringAlertSummary.Builder> result = MonitoringAlertSummaryListCopier
                    .copyToBuilder(this.monitoringAlertSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringAlertSummaries(Collection<MonitoringAlertSummary.BuilderImpl> monitoringAlertSummaries) {
            this.monitoringAlertSummaries = MonitoringAlertSummaryListCopier.copyFromBuilder(monitoringAlertSummaries);
        }

        @Override
        public final Builder monitoringAlertSummaries(Collection<MonitoringAlertSummary> monitoringAlertSummaries) {
            this.monitoringAlertSummaries = MonitoringAlertSummaryListCopier.copy(monitoringAlertSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertSummaries(MonitoringAlertSummary... monitoringAlertSummaries) {
            monitoringAlertSummaries(Arrays.asList(monitoringAlertSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertSummaries(Consumer<MonitoringAlertSummary.Builder>... monitoringAlertSummaries) {
            monitoringAlertSummaries(Stream.of(monitoringAlertSummaries)
                    .map(c -> MonitoringAlertSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MonitoringExecutionSummary.Builder getLastMonitoringExecutionSummary() {
            return lastMonitoringExecutionSummary != null ? lastMonitoringExecutionSummary.toBuilder() : null;
        }

        public final void setLastMonitoringExecutionSummary(MonitoringExecutionSummary.BuilderImpl lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary != null ? lastMonitoringExecutionSummary.build()
                    : null;
        }

        @Override
        public final Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary;
            return this;
        }

        public final BatchTransformInput.Builder getBatchTransformInput() {
            return batchTransformInput != null ? batchTransformInput.toBuilder() : null;
        }

        public final void setBatchTransformInput(BatchTransformInput.BuilderImpl batchTransformInput) {
            this.batchTransformInput = batchTransformInput != null ? batchTransformInput.build() : null;
        }

        @Override
        public final Builder batchTransformInput(BatchTransformInput batchTransformInput) {
            this.batchTransformInput = batchTransformInput;
            return this;
        }

        @Override
        public ModelDashboardMonitoringSchedule build() {
            return new ModelDashboardMonitoringSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
