/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this parameter to configure your OIDC Identity Provider (IdP).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OidcConfig implements SdkPojo, Serializable, ToCopyableBuilder<OidcConfig.Builder, OidcConfig> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(OidcConfig::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientSecret").getter(getter(OidcConfig::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(OidcConfig::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationEndpoint").getter(getter(OidcConfig::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build())
            .build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenEndpoint").getter(getter(OidcConfig::tokenEndpoint)).setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()).build();

    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserInfoEndpoint").getter(getter(OidcConfig::userInfoEndpoint))
            .setter(setter(Builder::userInfoEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").build()).build();

    private static final SdkField<String> LOGOUT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogoutEndpoint").getter(getter(OidcConfig::logoutEndpoint)).setter(setter(Builder::logoutEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutEndpoint").build()).build();

    private static final SdkField<String> JWKS_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JwksUri").getter(getter(OidcConfig::jwksUri)).setter(setter(Builder::jwksUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD,
            LOGOUT_ENDPOINT_FIELD, JWKS_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String clientSecret;

    private final String issuer;

    private final String authorizationEndpoint;

    private final String tokenEndpoint;

    private final String userInfoEndpoint;

    private final String logoutEndpoint;

    private final String jwksUri;

    private OidcConfig(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.logoutEndpoint = builder.logoutEndpoint;
        this.jwksUri = builder.jwksUri;
    }

    /**
     * <p>
     * The OIDC IdP client ID used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP client ID used to configure your private workforce.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The OIDC IdP client secret used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP client secret used to configure your private workforce.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The OIDC IdP issuer used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP issuer used to configure your private workforce.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The OIDC IdP authorization endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP authorization endpoint used to configure your private workforce.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP token endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP token endpoint used to configure your private workforce.
     */
    public final String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP user information endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP user information endpoint used to configure your private workforce.
     */
    public final String userInfoEndpoint() {
        return userInfoEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP logout endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP logout endpoint used to configure your private workforce.
     */
    public final String logoutEndpoint() {
        return logoutEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     */
    public final String jwksUri() {
        return jwksUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(logoutEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(jwksUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcConfig)) {
            return false;
        }
        OidcConfig other = (OidcConfig) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(issuer(), other.issuer())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint())
                && Objects.equals(userInfoEndpoint(), other.userInfoEndpoint())
                && Objects.equals(logoutEndpoint(), other.logoutEndpoint()) && Objects.equals(jwksUri(), other.jwksUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OidcConfig").add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***").add("Issuer", issuer())
                .add("AuthorizationEndpoint", authorizationEndpoint()).add("TokenEndpoint", tokenEndpoint())
                .add("UserInfoEndpoint", userInfoEndpoint()).add("LogoutEndpoint", logoutEndpoint()).add("JwksUri", jwksUri())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "TokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "UserInfoEndpoint":
            return Optional.ofNullable(clazz.cast(userInfoEndpoint()));
        case "LogoutEndpoint":
            return Optional.ofNullable(clazz.cast(logoutEndpoint()));
        case "JwksUri":
            return Optional.ofNullable(clazz.cast(jwksUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OidcConfig, T> g) {
        return obj -> g.apply((OidcConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OidcConfig> {
        /**
         * <p>
         * The OIDC IdP client ID used to configure your private workforce.
         * </p>
         * 
         * @param clientId
         *        The OIDC IdP client ID used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The OIDC IdP client secret used to configure your private workforce.
         * </p>
         * 
         * @param clientSecret
         *        The OIDC IdP client secret used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The OIDC IdP issuer used to configure your private workforce.
         * </p>
         * 
         * @param issuer
         *        The OIDC IdP issuer used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The OIDC IdP authorization endpoint used to configure your private workforce.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The OIDC IdP authorization endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The OIDC IdP token endpoint used to configure your private workforce.
         * </p>
         * 
         * @param tokenEndpoint
         *        The OIDC IdP token endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The OIDC IdP user information endpoint used to configure your private workforce.
         * </p>
         * 
         * @param userInfoEndpoint
         *        The OIDC IdP user information endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfoEndpoint(String userInfoEndpoint);

        /**
         * <p>
         * The OIDC IdP logout endpoint used to configure your private workforce.
         * </p>
         * 
         * @param logoutEndpoint
         *        The OIDC IdP logout endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutEndpoint(String logoutEndpoint);

        /**
         * <p>
         * The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
         * </p>
         * 
         * @param jwksUri
         *        The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwksUri(String jwksUri);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private String issuer;

        private String authorizationEndpoint;

        private String tokenEndpoint;

        private String userInfoEndpoint;

        private String logoutEndpoint;

        private String jwksUri;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcConfig model) {
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            issuer(model.issuer);
            authorizationEndpoint(model.authorizationEndpoint);
            tokenEndpoint(model.tokenEndpoint);
            userInfoEndpoint(model.userInfoEndpoint);
            logoutEndpoint(model.logoutEndpoint);
            jwksUri(model.jwksUri);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserInfoEndpoint() {
            return userInfoEndpoint;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final String getLogoutEndpoint() {
            return logoutEndpoint;
        }

        public final void setLogoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
        }

        @Override
        public final Builder logoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
            return this;
        }

        public final String getJwksUri() {
            return jwksUri;
        }

        public final void setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
        }

        @Override
        public final Builder jwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        @Override
        public OidcConfig build() {
            return new OidcConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
