/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name and an example value of the hyperparameter that you want to use in Autotune. If Automatic model tuning (AMT)
 * determines that your hyperparameter is eligible for Autotune, an optimal hyperparameter range is selected for you.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoParameter implements SdkPojo, Serializable, ToCopyableBuilder<AutoParameter.Builder, AutoParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AutoParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_HINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueHint").getter(getter(AutoParameter::valueHint)).setter(setter(Builder::valueHint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueHint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_HINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String valueHint;

    private AutoParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.valueHint = builder.valueHint;
    }

    /**
     * <p>
     * The name of the hyperparameter to optimize using Autotune.
     * </p>
     * 
     * @return The name of the hyperparameter to optimize using Autotune.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An example value of the hyperparameter to optimize using Autotune.
     * </p>
     * 
     * @return An example value of the hyperparameter to optimize using Autotune.
     */
    public final String valueHint() {
        return valueHint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(valueHint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoParameter)) {
            return false;
        }
        AutoParameter other = (AutoParameter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(valueHint(), other.valueHint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoParameter").add("Name", name()).add("ValueHint", valueHint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ValueHint":
            return Optional.ofNullable(clazz.cast(valueHint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoParameter, T> g) {
        return obj -> g.apply((AutoParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoParameter> {
        /**
         * <p>
         * The name of the hyperparameter to optimize using Autotune.
         * </p>
         * 
         * @param name
         *        The name of the hyperparameter to optimize using Autotune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An example value of the hyperparameter to optimize using Autotune.
         * </p>
         * 
         * @param valueHint
         *        An example value of the hyperparameter to optimize using Autotune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueHint(String valueHint);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String valueHint;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoParameter model) {
            name(model.name);
            valueHint(model.valueHint);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueHint() {
            return valueHint;
        }

        public final void setValueHint(String valueHint) {
            this.valueHint = valueHint;
        }

        @Override
        public final Builder valueHint(String valueHint) {
            this.valueHint = valueHint;
            return this;
        }

        @Override
        public AutoParameter build() {
            return new AutoParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
