/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for assigning a custom file system to a user profile or space for an Amazon SageMaker Domain. Permitted
 * users can access this file system in Amazon SageMaker Studio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomFileSystemConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomFileSystemConfig.Builder, CustomFileSystemConfig> {
    private static final SdkField<EFSFileSystemConfig> EFS_FILE_SYSTEM_CONFIG_FIELD = SdkField
            .<EFSFileSystemConfig> builder(MarshallingType.SDK_POJO).memberName("EFSFileSystemConfig")
            .getter(getter(CustomFileSystemConfig::efsFileSystemConfig)).setter(setter(Builder::efsFileSystemConfig))
            .constructor(EFSFileSystemConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EFSFileSystemConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FILE_SYSTEM_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final EFSFileSystemConfig efsFileSystemConfig;

    private final Type type;

    private CustomFileSystemConfig(BuilderImpl builder) {
        this.efsFileSystemConfig = builder.efsFileSystemConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * The settings for a custom Amazon EFS file system.
     * </p>
     * 
     * @return The settings for a custom Amazon EFS file system.
     */
    public final EFSFileSystemConfig efsFileSystemConfig() {
        return efsFileSystemConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(efsFileSystemConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFileSystemConfig)) {
            return false;
        }
        CustomFileSystemConfig other = (CustomFileSystemConfig) obj;
        return Objects.equals(efsFileSystemConfig(), other.efsFileSystemConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomFileSystemConfig").add("EFSFileSystemConfig", efsFileSystemConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EFSFileSystemConfig":
            return Optional.ofNullable(clazz.cast(efsFileSystemConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #efsFileSystemConfig()} initialized to the given value.
     *
     * <p>
     * The settings for a custom Amazon EFS file system.
     * </p>
     * 
     * @param efsFileSystemConfig
     *        The settings for a custom Amazon EFS file system.
     */
    public static CustomFileSystemConfig fromEfsFileSystemConfig(EFSFileSystemConfig efsFileSystemConfig) {
        return builder().efsFileSystemConfig(efsFileSystemConfig).build();
    }

    /**
     * Create an instance of this class with {@link #efsFileSystemConfig()} initialized to the given value.
     *
     * <p>
     * The settings for a custom Amazon EFS file system.
     * </p>
     * 
     * @param efsFileSystemConfig
     *        The settings for a custom Amazon EFS file system.
     */
    public static CustomFileSystemConfig fromEfsFileSystemConfig(Consumer<EFSFileSystemConfig.Builder> efsFileSystemConfig) {
        EFSFileSystemConfig.Builder builder = EFSFileSystemConfig.builder();
        efsFileSystemConfig.accept(builder);
        return fromEfsFileSystemConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomFileSystemConfig, T> g) {
        return obj -> g.apply((CustomFileSystemConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomFileSystemConfig> {
        /**
         * <p>
         * The settings for a custom Amazon EFS file system.
         * </p>
         * 
         * @param efsFileSystemConfig
         *        The settings for a custom Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFileSystemConfig(EFSFileSystemConfig efsFileSystemConfig);

        /**
         * <p>
         * The settings for a custom Amazon EFS file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link EFSFileSystemConfig.Builder} avoiding the
         * need to create one manually via {@link EFSFileSystemConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EFSFileSystemConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #efsFileSystemConfig(EFSFileSystemConfig)}.
         * 
         * @param efsFileSystemConfig
         *        a consumer that will call methods on {@link EFSFileSystemConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsFileSystemConfig(EFSFileSystemConfig)
         */
        default Builder efsFileSystemConfig(Consumer<EFSFileSystemConfig.Builder> efsFileSystemConfig) {
            return efsFileSystemConfig(EFSFileSystemConfig.builder().applyMutation(efsFileSystemConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EFSFileSystemConfig efsFileSystemConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFileSystemConfig model) {
            efsFileSystemConfig(model.efsFileSystemConfig);
        }

        public final EFSFileSystemConfig.Builder getEfsFileSystemConfig() {
            return efsFileSystemConfig != null ? efsFileSystemConfig.toBuilder() : null;
        }

        public final void setEfsFileSystemConfig(EFSFileSystemConfig.BuilderImpl efsFileSystemConfig) {
            Object oldValue = this.efsFileSystemConfig;
            this.efsFileSystemConfig = efsFileSystemConfig != null ? efsFileSystemConfig.build() : null;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM_CONFIG, oldValue, this.efsFileSystemConfig);
        }

        @Override
        public final Builder efsFileSystemConfig(EFSFileSystemConfig efsFileSystemConfig) {
            Object oldValue = this.efsFileSystemConfig;
            this.efsFileSystemConfig = efsFileSystemConfig;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM_CONFIG, oldValue, this.efsFileSystemConfig);
            return this;
        }

        @Override
        public CustomFileSystemConfig build() {
            return new CustomFileSystemConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomFileSystemConfig#type()
     */
    public enum Type {
        EFS_FILE_SYSTEM_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
