/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AsyncInferenceClientConfig;
import software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AsyncInferenceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AsyncInferenceConfig> {
    private static final SdkField<AsyncInferenceClientConfig> CLIENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientConfig").getter(AsyncInferenceConfig.getter(AsyncInferenceConfig::clientConfig)).setter(AsyncInferenceConfig.setter(Builder::clientConfig)).constructor(AsyncInferenceClientConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConfig").build()}).build();
    private static final SdkField<AsyncInferenceOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(AsyncInferenceConfig.getter(AsyncInferenceConfig::outputConfig)).setter(AsyncInferenceConfig.setter(Builder::outputConfig)).constructor(AsyncInferenceOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final AsyncInferenceClientConfig clientConfig;
    private final AsyncInferenceOutputConfig outputConfig;

    private AsyncInferenceConfig(BuilderImpl builder) {
        this.clientConfig = builder.clientConfig;
        this.outputConfig = builder.outputConfig;
    }

    public final AsyncInferenceClientConfig clientConfig() {
        return this.clientConfig;
    }

    public final AsyncInferenceOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceConfig)) {
            return false;
        }
        AsyncInferenceConfig other = (AsyncInferenceConfig)obj;
        return Objects.equals(this.clientConfig(), other.clientConfig()) && Objects.equals(this.outputConfig(), other.outputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AsyncInferenceConfig").add("ClientConfig", (Object)this.clientConfig()).add("OutputConfig", (Object)this.outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientConfig": {
                return Optional.ofNullable(clazz.cast(this.clientConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceConfig, T> g) {
        return obj -> g.apply((AsyncInferenceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AsyncInferenceClientConfig clientConfig;
        private AsyncInferenceOutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceConfig model) {
            this.clientConfig(model.clientConfig);
            this.outputConfig(model.outputConfig);
        }

        public final AsyncInferenceClientConfig.Builder getClientConfig() {
            return this.clientConfig != null ? this.clientConfig.toBuilder() : null;
        }

        public final void setClientConfig(AsyncInferenceClientConfig.BuilderImpl clientConfig) {
            this.clientConfig = clientConfig != null ? clientConfig.build() : null;
        }

        @Override
        public final Builder clientConfig(AsyncInferenceClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public final AsyncInferenceOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(AsyncInferenceOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(AsyncInferenceOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public AsyncInferenceConfig build() {
            return new AsyncInferenceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AsyncInferenceConfig> {
        public Builder clientConfig(AsyncInferenceClientConfig var1);

        default public Builder clientConfig(Consumer<AsyncInferenceClientConfig.Builder> clientConfig) {
            return this.clientConfig((AsyncInferenceClientConfig)((AsyncInferenceClientConfig.Builder)AsyncInferenceClientConfig.builder().applyMutation(clientConfig)).build());
        }

        public Builder outputConfig(AsyncInferenceOutputConfig var1);

        default public Builder outputConfig(Consumer<AsyncInferenceOutputConfig.Builder> outputConfig) {
            return this.outputConfig((AsyncInferenceOutputConfig)((AsyncInferenceOutputConfig.Builder)AsyncInferenceOutputConfig.builder().applyMutation(outputConfig)).build());
        }
    }
}

