/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists a summary of properties of an inference experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceExperimentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceExperimentSummary.Builder, InferenceExperimentSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InferenceExperimentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(InferenceExperimentSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<InferenceExperimentSchedule> SCHEDULE_FIELD = SdkField
            .<InferenceExperimentSchedule> builder(MarshallingType.SDK_POJO).memberName("Schedule")
            .getter(getter(InferenceExperimentSummary::schedule)).setter(setter(Builder::schedule))
            .constructor(InferenceExperimentSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InferenceExperimentSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(InferenceExperimentSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(InferenceExperimentSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(InferenceExperimentSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(InferenceExperimentSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(InferenceExperimentSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(InferenceExperimentSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            SCHEDULE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final InferenceExperimentSchedule schedule;

    private final String status;

    private final String statusReason;

    private final String description;

    private final Instant creationTime;

    private final Instant completionTime;

    private final Instant lastModifiedTime;

    private final String roleArn;

    private InferenceExperimentSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the inference experiment.
     * </p>
     * 
     * @return The name of the inference experiment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the inference experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the inference experiment.
     * @see InferenceExperimentType
     */
    public final InferenceExperimentType type() {
        return InferenceExperimentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the inference experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InferenceExperimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the inference experiment.
     * @see InferenceExperimentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The duration for which the inference experiment ran or will run.
     * </p>
     * <p>
     * The maximum duration that you can set for an inference experiment is 30 days.
     * </p>
     * 
     * @return The duration for which the inference experiment ran or will run.</p>
     *         <p>
     *         The maximum duration that you can set for an inference experiment is 30 days.
     */
    public final InferenceExperimentSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The status of the inference experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference experiment.
     * @see InferenceExperimentStatus
     */
    public final InferenceExperimentStatus status() {
        return InferenceExperimentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the inference experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExperimentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the inference experiment.
     * @see InferenceExperimentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error message for the inference experiment status result.
     * </p>
     * 
     * @return The error message for the inference experiment status result.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The description of the inference experiment.
     * </p>
     * 
     * @return The description of the inference experiment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp at which the inference experiment was created.
     * </p>
     * 
     * @return The timestamp at which the inference experiment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp at which the inference experiment was completed.
     * </p>
     * 
     * @return The timestamp at which the inference experiment was completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The timestamp when you last modified the inference experiment.
     * </p>
     * 
     * @return The timestamp when you last modified the inference experiment.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and
     * manage Amazon SageMaker Inference endpoints for model deployment.
     * </p>
     * 
     * @return The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images,
     *         and manage Amazon SageMaker Inference endpoints for model deployment.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceExperimentSummary)) {
            return false;
        }
        InferenceExperimentSummary other = (InferenceExperimentSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(description(), other.description())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceExperimentSummary").add("Name", name()).add("Type", typeAsString())
                .add("Schedule", schedule()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("Description", description()).add("CreationTime", creationTime()).add("CompletionTime", completionTime())
                .add("LastModifiedTime", lastModifiedTime()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceExperimentSummary, T> g) {
        return obj -> g.apply((InferenceExperimentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceExperimentSummary> {
        /**
         * <p>
         * The name of the inference experiment.
         * </p>
         * 
         * @param name
         *        The name of the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the inference experiment.
         * </p>
         * 
         * @param type
         *        The type of the inference experiment.
         * @see InferenceExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the inference experiment.
         * </p>
         * 
         * @param type
         *        The type of the inference experiment.
         * @see InferenceExperimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentType
         */
        Builder type(InferenceExperimentType type);

        /**
         * <p>
         * The duration for which the inference experiment ran or will run.
         * </p>
         * <p>
         * The maximum duration that you can set for an inference experiment is 30 days.
         * </p>
         * 
         * @param schedule
         *        The duration for which the inference experiment ran or will run.</p>
         *        <p>
         *        The maximum duration that you can set for an inference experiment is 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(InferenceExperimentSchedule schedule);

        /**
         * <p>
         * The duration for which the inference experiment ran or will run.
         * </p>
         * <p>
         * The maximum duration that you can set for an inference experiment is 30 days.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceExperimentSchedule.Builder}
         * avoiding the need to create one manually via {@link InferenceExperimentSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceExperimentSchedule.Builder#build()} is called
         * immediately and its result is passed to {@link #schedule(InferenceExperimentSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link InferenceExperimentSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(InferenceExperimentSchedule)
         */
        default Builder schedule(Consumer<InferenceExperimentSchedule.Builder> schedule) {
            return schedule(InferenceExperimentSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The status of the inference experiment.
         * </p>
         * 
         * @param status
         *        The status of the inference experiment.
         * @see InferenceExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the inference experiment.
         * </p>
         * 
         * @param status
         *        The status of the inference experiment.
         * @see InferenceExperimentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExperimentStatus
         */
        Builder status(InferenceExperimentStatus status);

        /**
         * <p>
         * The error message for the inference experiment status result.
         * </p>
         * 
         * @param statusReason
         *        The error message for the inference experiment status result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The description of the inference experiment.
         * </p>
         * 
         * @param description
         *        The description of the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp at which the inference experiment was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp at which the inference experiment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp at which the inference experiment was completed.
         * </p>
         * 
         * @param completionTime
         *        The timestamp at which the inference experiment was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The timestamp when you last modified the inference experiment.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when you last modified the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and
         * manage Amazon SageMaker Inference endpoints for model deployment.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container
         *        images, and manage Amazon SageMaker Inference endpoints for model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private InferenceExperimentSchedule schedule;

        private String status;

        private String statusReason;

        private String description;

        private Instant creationTime;

        private Instant completionTime;

        private Instant lastModifiedTime;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceExperimentSummary model) {
            name(model.name);
            type(model.type);
            schedule(model.schedule);
            status(model.status);
            statusReason(model.statusReason);
            description(model.description);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            lastModifiedTime(model.lastModifiedTime);
            roleArn(model.roleArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InferenceExperimentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InferenceExperimentSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(InferenceExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InferenceExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceExperimentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public InferenceExperimentSummary build() {
            return new InferenceExperimentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
