/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMlflowTrackingServerRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateMlflowTrackingServerRequest> {
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerName").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::trackingServerName)).setter(CreateMlflowTrackingServerRequest.setter(Builder::trackingServerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build()}).build();
    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactStoreUri").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::artifactStoreUri)).setter(CreateMlflowTrackingServerRequest.setter(Builder::artifactStoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerSize").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::trackingServerSizeAsString)).setter(CreateMlflowTrackingServerRequest.setter(Builder::trackingServerSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerSize").build()}).build();
    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowVersion").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::mlflowVersion)).setter(CreateMlflowTrackingServerRequest.setter(Builder::mlflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::roleArn)).setter(CreateMlflowTrackingServerRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_MODEL_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutomaticModelRegistration").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::automaticModelRegistration)).setter(CreateMlflowTrackingServerRequest.setter(Builder::automaticModelRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticModelRegistration").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::weeklyMaintenanceWindowStart)).setter(CreateMlflowTrackingServerRequest.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMlflowTrackingServerRequest.getter(CreateMlflowTrackingServerRequest::tags)).setter(CreateMlflowTrackingServerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_NAME_FIELD, ARTIFACT_STORE_URI_FIELD, TRACKING_SERVER_SIZE_FIELD, MLFLOW_VERSION_FIELD, ROLE_ARN_FIELD, AUTOMATIC_MODEL_REGISTRATION_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, TAGS_FIELD));
    private final String trackingServerName;
    private final String artifactStoreUri;
    private final String trackingServerSize;
    private final String mlflowVersion;
    private final String roleArn;
    private final Boolean automaticModelRegistration;
    private final String weeklyMaintenanceWindowStart;
    private final List<Tag> tags;

    private CreateMlflowTrackingServerRequest(BuilderImpl builder) {
        super(builder);
        this.trackingServerName = builder.trackingServerName;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.trackingServerSize = builder.trackingServerSize;
        this.mlflowVersion = builder.mlflowVersion;
        this.roleArn = builder.roleArn;
        this.automaticModelRegistration = builder.automaticModelRegistration;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.tags = builder.tags;
    }

    public final String trackingServerName() {
        return this.trackingServerName;
    }

    public final String artifactStoreUri() {
        return this.artifactStoreUri;
    }

    public final TrackingServerSize trackingServerSize() {
        return TrackingServerSize.fromValue(this.trackingServerSize);
    }

    public final String trackingServerSizeAsString() {
        return this.trackingServerSize;
    }

    public final String mlflowVersion() {
        return this.mlflowVersion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Boolean automaticModelRegistration() {
        return this.automaticModelRegistration;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticModelRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlflowTrackingServerRequest)) {
            return false;
        }
        CreateMlflowTrackingServerRequest other = (CreateMlflowTrackingServerRequest)((Object)obj);
        return Objects.equals(this.trackingServerName(), other.trackingServerName()) && Objects.equals(this.artifactStoreUri(), other.artifactStoreUri()) && Objects.equals(this.trackingServerSizeAsString(), other.trackingServerSizeAsString()) && Objects.equals(this.mlflowVersion(), other.mlflowVersion()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.automaticModelRegistration(), other.automaticModelRegistration()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMlflowTrackingServerRequest").add("TrackingServerName", (Object)this.trackingServerName()).add("ArtifactStoreUri", (Object)this.artifactStoreUri()).add("TrackingServerSize", (Object)this.trackingServerSizeAsString()).add("MlflowVersion", (Object)this.mlflowVersion()).add("RoleArn", (Object)this.roleArn()).add("AutomaticModelRegistration", (Object)this.automaticModelRegistration()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackingServerName": {
                return Optional.ofNullable(clazz.cast(this.trackingServerName()));
            }
            case "ArtifactStoreUri": {
                return Optional.ofNullable(clazz.cast(this.artifactStoreUri()));
            }
            case "TrackingServerSize": {
                return Optional.ofNullable(clazz.cast(this.trackingServerSizeAsString()));
            }
            case "MlflowVersion": {
                return Optional.ofNullable(clazz.cast(this.mlflowVersion()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "AutomaticModelRegistration": {
                return Optional.ofNullable(clazz.cast(this.automaticModelRegistration()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMlflowTrackingServerRequest, T> g) {
        return obj -> g.apply((CreateMlflowTrackingServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trackingServerName;
        private String artifactStoreUri;
        private String trackingServerSize;
        private String mlflowVersion;
        private String roleArn;
        private Boolean automaticModelRegistration;
        private String weeklyMaintenanceWindowStart;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlflowTrackingServerRequest model) {
            super(model);
            this.trackingServerName(model.trackingServerName);
            this.artifactStoreUri(model.artifactStoreUri);
            this.trackingServerSize(model.trackingServerSize);
            this.mlflowVersion(model.mlflowVersion);
            this.roleArn(model.roleArn);
            this.automaticModelRegistration(model.automaticModelRegistration);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.tags(model.tags);
        }

        public final String getTrackingServerName() {
            return this.trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final String getArtifactStoreUri() {
            return this.artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getTrackingServerSize() {
            return this.trackingServerSize;
        }

        public final void setTrackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
        }

        @Override
        public final Builder trackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
            return this;
        }

        @Override
        public final Builder trackingServerSize(TrackingServerSize trackingServerSize) {
            this.trackingServerSize(trackingServerSize == null ? null : trackingServerSize.toString());
            return this;
        }

        public final String getMlflowVersion() {
            return this.mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getAutomaticModelRegistration() {
            return this.automaticModelRegistration;
        }

        public final void setAutomaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
        }

        @Override
        public final Builder automaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlflowTrackingServerRequest build() {
            return new CreateMlflowTrackingServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMlflowTrackingServerRequest> {
        public Builder trackingServerName(String var1);

        public Builder artifactStoreUri(String var1);

        public Builder trackingServerSize(String var1);

        public Builder trackingServerSize(TrackingServerSize var1);

        public Builder mlflowVersion(String var1);

        public Builder roleArn(String var1);

        public Builder automaticModelRegistration(Boolean var1);

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

