/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOptimizationJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateOptimizationJobRequest.Builder, CreateOptimizationJobRequest> {
    private static final SdkField<String> OPTIMIZATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobName").getter(getter(CreateOptimizationJobRequest::optimizationJobName))
            .setter(setter(Builder::optimizationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobName").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateOptimizationJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<OptimizationJobModelSource> MODEL_SOURCE_FIELD = SdkField
            .<OptimizationJobModelSource> builder(MarshallingType.SDK_POJO).memberName("ModelSource")
            .getter(getter(CreateOptimizationJobRequest::modelSource)).setter(setter(Builder::modelSource))
            .constructor(OptimizationJobModelSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSource").build()).build();

    private static final SdkField<String> DEPLOYMENT_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentInstanceType").getter(getter(CreateOptimizationJobRequest::deploymentInstanceTypeAsString))
            .setter(setter(Builder::deploymentInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentInstanceType").build())
            .build();

    private static final SdkField<Map<String, String>> OPTIMIZATION_ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("OptimizationEnvironment")
            .getter(getter(CreateOptimizationJobRequest::optimizationEnvironment))
            .setter(setter(Builder::optimizationEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEnvironment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<OptimizationConfig>> OPTIMIZATION_CONFIGS_FIELD = SdkField
            .<List<OptimizationConfig>> builder(MarshallingType.LIST)
            .memberName("OptimizationConfigs")
            .getter(getter(CreateOptimizationJobRequest::optimizationConfigs))
            .setter(setter(Builder::optimizationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptimizationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptimizationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OptimizationJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<OptimizationJobOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateOptimizationJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(OptimizationJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(CreateOptimizationJobRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateOptimizationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OptimizationVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<OptimizationVpcConfig> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(CreateOptimizationJobRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(OptimizationVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_NAME_FIELD,
            ROLE_ARN_FIELD, MODEL_SOURCE_FIELD, DEPLOYMENT_INSTANCE_TYPE_FIELD, OPTIMIZATION_ENVIRONMENT_FIELD,
            OPTIMIZATION_CONFIGS_FIELD, OUTPUT_CONFIG_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD));

    private final String optimizationJobName;

    private final String roleArn;

    private final OptimizationJobModelSource modelSource;

    private final String deploymentInstanceType;

    private final Map<String, String> optimizationEnvironment;

    private final List<OptimizationConfig> optimizationConfigs;

    private final OptimizationJobOutputConfig outputConfig;

    private final StoppingCondition stoppingCondition;

    private final List<Tag> tags;

    private final OptimizationVpcConfig vpcConfig;

    private CreateOptimizationJobRequest(BuilderImpl builder) {
        super(builder);
        this.optimizationJobName = builder.optimizationJobName;
        this.roleArn = builder.roleArn;
        this.modelSource = builder.modelSource;
        this.deploymentInstanceType = builder.deploymentInstanceType;
        this.optimizationEnvironment = builder.optimizationEnvironment;
        this.optimizationConfigs = builder.optimizationConfigs;
        this.outputConfig = builder.outputConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * A custom name for the new optimization job.
     * </p>
     * 
     * @return A custom name for the new optimization job.
     */
    public final String optimizationJobName() {
        return optimizationJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     * </p>
     * <p>
     * During model optimization, Amazon SageMaker needs your permission to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Read input data from an S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Write model artifacts to an S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Write logs to Amazon CloudWatch Logs
     * </p>
     * </li>
     * <li>
     * <p>
     * Publish metrics to Amazon CloudWatch
     * </p>
     * </li>
     * </ul>
     * <p>
     * You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of
     * this API must have the <code>iam:PassRole</code> permission. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your
     *         behalf. </p>
     *         <p>
     *         During model optimization, Amazon SageMaker needs your permission to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Read input data from an S3 bucket
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Write model artifacts to an S3 bucket
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Write logs to Amazon CloudWatch Logs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Publish metrics to Amazon CloudWatch
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the
     *         caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a>
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The location of the source model to optimize with an optimization job.
     * </p>
     * 
     * @return The location of the source model to optimize with an optimization job.
     */
    public final OptimizationJobModelSource modelSource() {
        return modelSource;
    }

    /**
     * <p>
     * The type of instance that hosts the optimized model that you create with the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentInstanceType} will return {@link OptimizationJobDeploymentInstanceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deploymentInstanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance that hosts the optimized model that you create with the optimization job.
     * @see OptimizationJobDeploymentInstanceType
     */
    public final OptimizationJobDeploymentInstanceType deploymentInstanceType() {
        return OptimizationJobDeploymentInstanceType.fromValue(deploymentInstanceType);
    }

    /**
     * <p>
     * The type of instance that hosts the optimized model that you create with the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentInstanceType} will return {@link OptimizationJobDeploymentInstanceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deploymentInstanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance that hosts the optimized model that you create with the optimization job.
     * @see OptimizationJobDeploymentInstanceType
     */
    public final String deploymentInstanceTypeAsString() {
        return deploymentInstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptimizationEnvironment property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOptimizationEnvironment() {
        return optimizationEnvironment != null && !(optimizationEnvironment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the model container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptimizationEnvironment} method.
     * </p>
     * 
     * @return The environment variables to set in the model container.
     */
    public final Map<String, String> optimizationEnvironment() {
        return optimizationEnvironment;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptimizationConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptimizationConfigs() {
        return optimizationConfigs != null && !(optimizationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Settings for each of the optimization techniques that the job applies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptimizationConfigs} method.
     * </p>
     * 
     * @return Settings for each of the optimization techniques that the job applies.
     */
    public final List<OptimizationConfig> optimizationConfigs() {
        return optimizationConfigs;
    }

    /**
     * <p>
     * Details for where to store the optimized model that you create with the optimization job.
     * </p>
     * 
     * @return Details for where to store the optimized model that you create with the optimization job.
     */
    public final OptimizationJobOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs associated with the optimization job. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs associated with the optimization job. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A VPC in Amazon VPC that your optimized model has access to.
     * </p>
     * 
     * @return A VPC in Amazon VPC that your optimized model has access to.
     */
    public final OptimizationVpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelSource());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptimizationEnvironment() ? optimizationEnvironment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptimizationConfigs() ? optimizationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptimizationJobRequest)) {
            return false;
        }
        CreateOptimizationJobRequest other = (CreateOptimizationJobRequest) obj;
        return Objects.equals(optimizationJobName(), other.optimizationJobName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(modelSource(), other.modelSource())
                && Objects.equals(deploymentInstanceTypeAsString(), other.deploymentInstanceTypeAsString())
                && hasOptimizationEnvironment() == other.hasOptimizationEnvironment()
                && Objects.equals(optimizationEnvironment(), other.optimizationEnvironment())
                && hasOptimizationConfigs() == other.hasOptimizationConfigs()
                && Objects.equals(optimizationConfigs(), other.optimizationConfigs())
                && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(stoppingCondition(), other.stoppingCondition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOptimizationJobRequest").add("OptimizationJobName", optimizationJobName())
                .add("RoleArn", roleArn()).add("ModelSource", modelSource())
                .add("DeploymentInstanceType", deploymentInstanceTypeAsString())
                .add("OptimizationEnvironment", hasOptimizationEnvironment() ? optimizationEnvironment() : null)
                .add("OptimizationConfigs", hasOptimizationConfigs() ? optimizationConfigs() : null)
                .add("OutputConfig", outputConfig()).add("StoppingCondition", stoppingCondition())
                .add("Tags", hasTags() ? tags() : null).add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptimizationJobName":
            return Optional.ofNullable(clazz.cast(optimizationJobName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ModelSource":
            return Optional.ofNullable(clazz.cast(modelSource()));
        case "DeploymentInstanceType":
            return Optional.ofNullable(clazz.cast(deploymentInstanceTypeAsString()));
        case "OptimizationEnvironment":
            return Optional.ofNullable(clazz.cast(optimizationEnvironment()));
        case "OptimizationConfigs":
            return Optional.ofNullable(clazz.cast(optimizationConfigs()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOptimizationJobRequest, T> g) {
        return obj -> g.apply((CreateOptimizationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOptimizationJobRequest> {
        /**
         * <p>
         * A custom name for the new optimization job.
         * </p>
         * 
         * @param optimizationJobName
         *        A custom name for the new optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobName(String optimizationJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         * </p>
         * <p>
         * During model optimization, Amazon SageMaker needs your permission to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Read input data from an S3 bucket
         * </p>
         * </li>
         * <li>
         * <p>
         * Write model artifacts to an S3 bucket
         * </p>
         * </li>
         * <li>
         * <p>
         * Write logs to Amazon CloudWatch Logs
         * </p>
         * </li>
         * <li>
         * <p>
         * Publish metrics to Amazon CloudWatch
         * </p>
         * </li>
         * </ul>
         * <p>
         * You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the
         * caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a>
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your
         *        behalf. </p>
         *        <p>
         *        During model optimization, Amazon SageMaker needs your permission to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Read input data from an S3 bucket
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Write model artifacts to an S3 bucket
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Write logs to Amazon CloudWatch Logs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Publish metrics to Amazon CloudWatch
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker,
         *        the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see
         *        <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
         *        Roles.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The location of the source model to optimize with an optimization job.
         * </p>
         * 
         * @param modelSource
         *        The location of the source model to optimize with an optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSource(OptimizationJobModelSource modelSource);

        /**
         * <p>
         * The location of the source model to optimize with an optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationJobModelSource.Builder}
         * avoiding the need to create one manually via {@link OptimizationJobModelSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationJobModelSource.Builder#build()} is called immediately
         * and its result is passed to {@link #modelSource(OptimizationJobModelSource)}.
         * 
         * @param modelSource
         *        a consumer that will call methods on {@link OptimizationJobModelSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelSource(OptimizationJobModelSource)
         */
        default Builder modelSource(Consumer<OptimizationJobModelSource.Builder> modelSource) {
            return modelSource(OptimizationJobModelSource.builder().applyMutation(modelSource).build());
        }

        /**
         * <p>
         * The type of instance that hosts the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param deploymentInstanceType
         *        The type of instance that hosts the optimized model that you create with the optimization job.
         * @see OptimizationJobDeploymentInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobDeploymentInstanceType
         */
        Builder deploymentInstanceType(String deploymentInstanceType);

        /**
         * <p>
         * The type of instance that hosts the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param deploymentInstanceType
         *        The type of instance that hosts the optimized model that you create with the optimization job.
         * @see OptimizationJobDeploymentInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobDeploymentInstanceType
         */
        Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType);

        /**
         * <p>
         * The environment variables to set in the model container.
         * </p>
         * 
         * @param optimizationEnvironment
         *        The environment variables to set in the model container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationEnvironment(Map<String, String> optimizationEnvironment);

        /**
         * <p>
         * Settings for each of the optimization techniques that the job applies.
         * </p>
         * 
         * @param optimizationConfigs
         *        Settings for each of the optimization techniques that the job applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationConfigs(Collection<OptimizationConfig> optimizationConfigs);

        /**
         * <p>
         * Settings for each of the optimization techniques that the job applies.
         * </p>
         * 
         * @param optimizationConfigs
         *        Settings for each of the optimization techniques that the job applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationConfigs(OptimizationConfig... optimizationConfigs);

        /**
         * <p>
         * Settings for each of the optimization techniques that the job applies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #optimizationConfigs(List<OptimizationConfig>)}.
         * 
         * @param optimizationConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optimizationConfigs(java.util.Collection<OptimizationConfig>)
         */
        Builder optimizationConfigs(Consumer<OptimizationConfig.Builder>... optimizationConfigs);

        /**
         * <p>
         * Details for where to store the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param outputConfig
         *        Details for where to store the optimized model that you create with the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OptimizationJobOutputConfig outputConfig);

        /**
         * <p>
         * Details for where to store the optimized model that you create with the optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationJobOutputConfig.Builder}
         * avoiding the need to create one manually via {@link OptimizationJobOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationJobOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(OptimizationJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OptimizationJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OptimizationJobOutputConfig)
         */
        default Builder outputConfig(Consumer<OptimizationJobOutputConfig.Builder> outputConfig) {
            return outputConfig(OptimizationJobOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * A list of key-value pairs associated with the optimization job. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs associated with the optimization job. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs associated with the optimization job. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs associated with the optimization job. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs associated with the optimization job. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A VPC in Amazon VPC that your optimized model has access to.
         * </p>
         * 
         * @param vpcConfig
         *        A VPC in Amazon VPC that your optimized model has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(OptimizationVpcConfig vpcConfig);

        /**
         * <p>
         * A VPC in Amazon VPC that your optimized model has access to.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationVpcConfig.Builder} avoiding
         * the need to create one manually via {@link OptimizationVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationVpcConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcConfig(OptimizationVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link OptimizationVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(OptimizationVpcConfig)
         */
        default Builder vpcConfig(Consumer<OptimizationVpcConfig.Builder> vpcConfig) {
            return vpcConfig(OptimizationVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String optimizationJobName;

        private String roleArn;

        private OptimizationJobModelSource modelSource;

        private String deploymentInstanceType;

        private Map<String, String> optimizationEnvironment = DefaultSdkAutoConstructMap.getInstance();

        private List<OptimizationConfig> optimizationConfigs = DefaultSdkAutoConstructList.getInstance();

        private OptimizationJobOutputConfig outputConfig;

        private StoppingCondition stoppingCondition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private OptimizationVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOptimizationJobRequest model) {
            super(model);
            optimizationJobName(model.optimizationJobName);
            roleArn(model.roleArn);
            modelSource(model.modelSource);
            deploymentInstanceType(model.deploymentInstanceType);
            optimizationEnvironment(model.optimizationEnvironment);
            optimizationConfigs(model.optimizationConfigs);
            outputConfig(model.outputConfig);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
            vpcConfig(model.vpcConfig);
        }

        public final String getOptimizationJobName() {
            return optimizationJobName;
        }

        public final void setOptimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
        }

        @Override
        public final Builder optimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final OptimizationJobModelSource.Builder getModelSource() {
            return modelSource != null ? modelSource.toBuilder() : null;
        }

        public final void setModelSource(OptimizationJobModelSource.BuilderImpl modelSource) {
            this.modelSource = modelSource != null ? modelSource.build() : null;
        }

        @Override
        public final Builder modelSource(OptimizationJobModelSource modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        public final String getDeploymentInstanceType() {
            return deploymentInstanceType;
        }

        public final void setDeploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
        }

        @Override
        public final Builder deploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
            return this;
        }

        @Override
        public final Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType) {
            this.deploymentInstanceType(deploymentInstanceType == null ? null : deploymentInstanceType.toString());
            return this;
        }

        public final Map<String, String> getOptimizationEnvironment() {
            if (optimizationEnvironment instanceof SdkAutoConstructMap) {
                return null;
            }
            return optimizationEnvironment;
        }

        public final void setOptimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
        }

        @Override
        public final Builder optimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
            return this;
        }

        public final List<OptimizationConfig.Builder> getOptimizationConfigs() {
            List<OptimizationConfig.Builder> result = OptimizationConfigsCopier.copyToBuilder(this.optimizationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizationConfigs(Collection<OptimizationConfig.BuilderImpl> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copyFromBuilder(optimizationConfigs);
        }

        @Override
        public final Builder optimizationConfigs(Collection<OptimizationConfig> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copy(optimizationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(OptimizationConfig... optimizationConfigs) {
            optimizationConfigs(Arrays.asList(optimizationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(Consumer<OptimizationConfig.Builder>... optimizationConfigs) {
            optimizationConfigs(Stream.of(optimizationConfigs).map(c -> OptimizationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OptimizationJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OptimizationJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OptimizationJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final OptimizationVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(OptimizationVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(OptimizationVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOptimizationJobRequest build() {
            return new CreateOptimizationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
