/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteHubContentReferenceRequest extends SageMakerRequest implements
        ToCopyableBuilder<DeleteHubContentReferenceRequest.Builder, DeleteHubContentReferenceRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(DeleteHubContentReferenceRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentType").getter(getter(DeleteHubContentReferenceRequest::hubContentTypeAsString))
            .setter(setter(Builder::hubContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()).build();

    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentName").getter(getter(DeleteHubContentReferenceRequest::hubContentName))
            .setter(setter(Builder::hubContentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            HUB_CONTENT_TYPE_FIELD, HUB_CONTENT_NAME_FIELD));

    private final String hubName;

    private final String hubContentType;

    private final String hubContentName;

    private DeleteHubContentReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubContentType = builder.hubContentType;
        this.hubContentName = builder.hubContentName;
    }

    /**
     * <p>
     * The name of the hub to delete the hub content reference from.
     * </p>
     * 
     * @return The name of the hub to delete the hub content reference from.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The type of hub content reference to delete. The only supported type of hub content reference to delete is
     * <code>ModelReference</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content reference to delete. The only supported type of hub content reference to delete
     *         is <code>ModelReference</code>.
     * @see HubContentType
     */
    public final HubContentType hubContentType() {
        return HubContentType.fromValue(hubContentType);
    }

    /**
     * <p>
     * The type of hub content reference to delete. The only supported type of hub content reference to delete is
     * <code>ModelReference</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content reference to delete. The only supported type of hub content reference to delete
     *         is <code>ModelReference</code>.
     * @see HubContentType
     */
    public final String hubContentTypeAsString() {
        return hubContentType;
    }

    /**
     * <p>
     * The name of the hub content to delete.
     * </p>
     * 
     * @return The name of the hub content to delete.
     */
    public final String hubContentName() {
        return hubContentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHubContentReferenceRequest)) {
            return false;
        }
        DeleteHubContentReferenceRequest other = (DeleteHubContentReferenceRequest) obj;
        return Objects.equals(hubName(), other.hubName())
                && Objects.equals(hubContentTypeAsString(), other.hubContentTypeAsString())
                && Objects.equals(hubContentName(), other.hubContentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteHubContentReferenceRequest").add("HubName", hubName())
                .add("HubContentType", hubContentTypeAsString()).add("HubContentName", hubContentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubContentType":
            return Optional.ofNullable(clazz.cast(hubContentTypeAsString()));
        case "HubContentName":
            return Optional.ofNullable(clazz.cast(hubContentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteHubContentReferenceRequest, T> g) {
        return obj -> g.apply((DeleteHubContentReferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteHubContentReferenceRequest> {
        /**
         * <p>
         * The name of the hub to delete the hub content reference from.
         * </p>
         * 
         * @param hubName
         *        The name of the hub to delete the hub content reference from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The type of hub content reference to delete. The only supported type of hub content reference to delete is
         * <code>ModelReference</code>.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content reference to delete. The only supported type of hub content reference to
         *        delete is <code>ModelReference</code>.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(String hubContentType);

        /**
         * <p>
         * The type of hub content reference to delete. The only supported type of hub content reference to delete is
         * <code>ModelReference</code>.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content reference to delete. The only supported type of hub content reference to
         *        delete is <code>ModelReference</code>.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(HubContentType hubContentType);

        /**
         * <p>
         * The name of the hub content to delete.
         * </p>
         * 
         * @param hubContentName
         *        The name of the hub content to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentName(String hubContentName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String hubContentType;

        private String hubContentName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHubContentReferenceRequest model) {
            super(model);
            hubName(model.hubName);
            hubContentType(model.hubContentType);
            hubContentName(model.hubContentName);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentType() {
            return hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getHubContentName() {
            return hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteHubContentReferenceRequest build() {
            return new DeleteHubContentReferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
