/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOptimizationJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeOptimizationJobResponse.Builder, DescribeOptimizationJobResponse> {
    private static final SdkField<String> OPTIMIZATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobArn").getter(getter(DescribeOptimizationJobResponse::optimizationJobArn))
            .setter(setter(Builder::optimizationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobArn").build())
            .build();

    private static final SdkField<String> OPTIMIZATION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobStatus").getter(getter(DescribeOptimizationJobResponse::optimizationJobStatusAsString))
            .setter(setter(Builder::optimizationJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobStatus").build())
            .build();

    private static final SdkField<Instant> OPTIMIZATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OptimizationStartTime").getter(getter(DescribeOptimizationJobResponse::optimizationStartTime))
            .setter(setter(Builder::optimizationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationStartTime").build())
            .build();

    private static final SdkField<Instant> OPTIMIZATION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OptimizationEndTime").getter(getter(DescribeOptimizationJobResponse::optimizationEndTime))
            .setter(setter(Builder::optimizationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEndTime").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeOptimizationJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeOptimizationJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeOptimizationJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> OPTIMIZATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobName").getter(getter(DescribeOptimizationJobResponse::optimizationJobName))
            .setter(setter(Builder::optimizationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobName").build())
            .build();

    private static final SdkField<OptimizationJobModelSource> MODEL_SOURCE_FIELD = SdkField
            .<OptimizationJobModelSource> builder(MarshallingType.SDK_POJO).memberName("ModelSource")
            .getter(getter(DescribeOptimizationJobResponse::modelSource)).setter(setter(Builder::modelSource))
            .constructor(OptimizationJobModelSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSource").build()).build();

    private static final SdkField<Map<String, String>> OPTIMIZATION_ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("OptimizationEnvironment")
            .getter(getter(DescribeOptimizationJobResponse::optimizationEnvironment))
            .setter(setter(Builder::optimizationEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEnvironment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DEPLOYMENT_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentInstanceType").getter(getter(DescribeOptimizationJobResponse::deploymentInstanceTypeAsString))
            .setter(setter(Builder::deploymentInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentInstanceType").build())
            .build();

    private static final SdkField<List<OptimizationConfig>> OPTIMIZATION_CONFIGS_FIELD = SdkField
            .<List<OptimizationConfig>> builder(MarshallingType.LIST)
            .memberName("OptimizationConfigs")
            .getter(getter(DescribeOptimizationJobResponse::optimizationConfigs))
            .setter(setter(Builder::optimizationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptimizationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptimizationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OptimizationJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<OptimizationJobOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(DescribeOptimizationJobResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(OptimizationJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<OptimizationOutput> OPTIMIZATION_OUTPUT_FIELD = SdkField
            .<OptimizationOutput> builder(MarshallingType.SDK_POJO).memberName("OptimizationOutput")
            .getter(getter(DescribeOptimizationJobResponse::optimizationOutput)).setter(setter(Builder::optimizationOutput))
            .constructor(OptimizationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationOutput").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeOptimizationJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(DescribeOptimizationJobResponse::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<OptimizationVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<OptimizationVpcConfig> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(DescribeOptimizationJobResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(OptimizationVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_ARN_FIELD,
            OPTIMIZATION_JOB_STATUS_FIELD, OPTIMIZATION_START_TIME_FIELD, OPTIMIZATION_END_TIME_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, OPTIMIZATION_JOB_NAME_FIELD, MODEL_SOURCE_FIELD,
            OPTIMIZATION_ENVIRONMENT_FIELD, DEPLOYMENT_INSTANCE_TYPE_FIELD, OPTIMIZATION_CONFIGS_FIELD, OUTPUT_CONFIG_FIELD,
            OPTIMIZATION_OUTPUT_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD, VPC_CONFIG_FIELD));

    private final String optimizationJobArn;

    private final String optimizationJobStatus;

    private final Instant optimizationStartTime;

    private final Instant optimizationEndTime;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final String optimizationJobName;

    private final OptimizationJobModelSource modelSource;

    private final Map<String, String> optimizationEnvironment;

    private final String deploymentInstanceType;

    private final List<OptimizationConfig> optimizationConfigs;

    private final OptimizationJobOutputConfig outputConfig;

    private final OptimizationOutput optimizationOutput;

    private final String roleArn;

    private final StoppingCondition stoppingCondition;

    private final OptimizationVpcConfig vpcConfig;

    private DescribeOptimizationJobResponse(BuilderImpl builder) {
        super(builder);
        this.optimizationJobArn = builder.optimizationJobArn;
        this.optimizationJobStatus = builder.optimizationJobStatus;
        this.optimizationStartTime = builder.optimizationStartTime;
        this.optimizationEndTime = builder.optimizationEndTime;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.optimizationJobName = builder.optimizationJobName;
        this.modelSource = builder.modelSource;
        this.optimizationEnvironment = builder.optimizationEnvironment;
        this.deploymentInstanceType = builder.deploymentInstanceType;
        this.optimizationConfigs = builder.optimizationConfigs;
        this.outputConfig = builder.outputConfig;
        this.optimizationOutput = builder.optimizationOutput;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the optimization job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the optimization job.
     */
    public final String optimizationJobArn() {
        return optimizationJobArn;
    }

    /**
     * <p>
     * The current status of the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationJobStatus} will return {@link OptimizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #optimizationJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the optimization job.
     * @see OptimizationJobStatus
     */
    public final OptimizationJobStatus optimizationJobStatus() {
        return OptimizationJobStatus.fromValue(optimizationJobStatus);
    }

    /**
     * <p>
     * The current status of the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationJobStatus} will return {@link OptimizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #optimizationJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the optimization job.
     * @see OptimizationJobStatus
     */
    public final String optimizationJobStatusAsString() {
        return optimizationJobStatus;
    }

    /**
     * <p>
     * The time when the optimization job started.
     * </p>
     * 
     * @return The time when the optimization job started.
     */
    public final Instant optimizationStartTime() {
        return optimizationStartTime;
    }

    /**
     * <p>
     * The time when the optimization job finished processing.
     * </p>
     * 
     * @return The time when the optimization job finished processing.
     */
    public final Instant optimizationEndTime() {
        return optimizationEndTime;
    }

    /**
     * <p>
     * The time when you created the optimization job.
     * </p>
     * 
     * @return The time when you created the optimization job.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the optimization job was last updated.
     * </p>
     * 
     * @return The time when the optimization job was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * If the optimization job status is <code>FAILED</code>, the reason for the failure.
     * </p>
     * 
     * @return If the optimization job status is <code>FAILED</code>, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The name that you assigned to the optimization job.
     * </p>
     * 
     * @return The name that you assigned to the optimization job.
     */
    public final String optimizationJobName() {
        return optimizationJobName;
    }

    /**
     * <p>
     * The location of the source model to optimize with an optimization job.
     * </p>
     * 
     * @return The location of the source model to optimize with an optimization job.
     */
    public final OptimizationJobModelSource modelSource() {
        return modelSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptimizationEnvironment property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOptimizationEnvironment() {
        return optimizationEnvironment != null && !(optimizationEnvironment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the model container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptimizationEnvironment} method.
     * </p>
     * 
     * @return The environment variables to set in the model container.
     */
    public final Map<String, String> optimizationEnvironment() {
        return optimizationEnvironment;
    }

    /**
     * <p>
     * The type of instance that hosts the optimized model that you create with the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentInstanceType} will return {@link OptimizationJobDeploymentInstanceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deploymentInstanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance that hosts the optimized model that you create with the optimization job.
     * @see OptimizationJobDeploymentInstanceType
     */
    public final OptimizationJobDeploymentInstanceType deploymentInstanceType() {
        return OptimizationJobDeploymentInstanceType.fromValue(deploymentInstanceType);
    }

    /**
     * <p>
     * The type of instance that hosts the optimized model that you create with the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentInstanceType} will return {@link OptimizationJobDeploymentInstanceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deploymentInstanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance that hosts the optimized model that you create with the optimization job.
     * @see OptimizationJobDeploymentInstanceType
     */
    public final String deploymentInstanceTypeAsString() {
        return deploymentInstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptimizationConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptimizationConfigs() {
        return optimizationConfigs != null && !(optimizationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Settings for each of the optimization techniques that the job applies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptimizationConfigs} method.
     * </p>
     * 
     * @return Settings for each of the optimization techniques that the job applies.
     */
    public final List<OptimizationConfig> optimizationConfigs() {
        return optimizationConfigs;
    }

    /**
     * <p>
     * Details for where to store the optimized model that you create with the optimization job.
     * </p>
     * 
     * @return Details for where to store the optimized model that you create with the optimization job.
     */
    public final OptimizationJobOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * Output values produced by an optimization job.
     * </p>
     * 
     * @return Output values produced by an optimization job.
     */
    public final OptimizationOutput optimizationOutput() {
        return optimizationOutput;
    }

    /**
     * <p>
     * The ARN of the IAM role that you assigned to the optimization job.
     * </p>
     * 
     * @return The ARN of the IAM role that you assigned to the optimization job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * <p>
     * A VPC in Amazon VPC that your optimized model has access to.
     * </p>
     * 
     * @return A VPC in Amazon VPC that your optimized model has access to.
     */
    public final OptimizationVpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptimizationEnvironment() ? optimizationEnvironment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptimizationConfigs() ? optimizationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptimizationJobResponse)) {
            return false;
        }
        DescribeOptimizationJobResponse other = (DescribeOptimizationJobResponse) obj;
        return Objects.equals(optimizationJobArn(), other.optimizationJobArn())
                && Objects.equals(optimizationJobStatusAsString(), other.optimizationJobStatusAsString())
                && Objects.equals(optimizationStartTime(), other.optimizationStartTime())
                && Objects.equals(optimizationEndTime(), other.optimizationEndTime())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(optimizationJobName(), other.optimizationJobName())
                && Objects.equals(modelSource(), other.modelSource())
                && hasOptimizationEnvironment() == other.hasOptimizationEnvironment()
                && Objects.equals(optimizationEnvironment(), other.optimizationEnvironment())
                && Objects.equals(deploymentInstanceTypeAsString(), other.deploymentInstanceTypeAsString())
                && hasOptimizationConfigs() == other.hasOptimizationConfigs()
                && Objects.equals(optimizationConfigs(), other.optimizationConfigs())
                && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(optimizationOutput(), other.optimizationOutput()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOptimizationJobResponse").add("OptimizationJobArn", optimizationJobArn())
                .add("OptimizationJobStatus", optimizationJobStatusAsString())
                .add("OptimizationStartTime", optimizationStartTime()).add("OptimizationEndTime", optimizationEndTime())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("FailureReason", failureReason()).add("OptimizationJobName", optimizationJobName())
                .add("ModelSource", modelSource())
                .add("OptimizationEnvironment", hasOptimizationEnvironment() ? optimizationEnvironment() : null)
                .add("DeploymentInstanceType", deploymentInstanceTypeAsString())
                .add("OptimizationConfigs", hasOptimizationConfigs() ? optimizationConfigs() : null)
                .add("OutputConfig", outputConfig()).add("OptimizationOutput", optimizationOutput()).add("RoleArn", roleArn())
                .add("StoppingCondition", stoppingCondition()).add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptimizationJobArn":
            return Optional.ofNullable(clazz.cast(optimizationJobArn()));
        case "OptimizationJobStatus":
            return Optional.ofNullable(clazz.cast(optimizationJobStatusAsString()));
        case "OptimizationStartTime":
            return Optional.ofNullable(clazz.cast(optimizationStartTime()));
        case "OptimizationEndTime":
            return Optional.ofNullable(clazz.cast(optimizationEndTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "OptimizationJobName":
            return Optional.ofNullable(clazz.cast(optimizationJobName()));
        case "ModelSource":
            return Optional.ofNullable(clazz.cast(modelSource()));
        case "OptimizationEnvironment":
            return Optional.ofNullable(clazz.cast(optimizationEnvironment()));
        case "DeploymentInstanceType":
            return Optional.ofNullable(clazz.cast(deploymentInstanceTypeAsString()));
        case "OptimizationConfigs":
            return Optional.ofNullable(clazz.cast(optimizationConfigs()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "OptimizationOutput":
            return Optional.ofNullable(clazz.cast(optimizationOutput()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptimizationJobResponse, T> g) {
        return obj -> g.apply((DescribeOptimizationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOptimizationJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the optimization job.
         * </p>
         * 
         * @param optimizationJobArn
         *        The Amazon Resource Name (ARN) of the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobArn(String optimizationJobArn);

        /**
         * <p>
         * The current status of the optimization job.
         * </p>
         * 
         * @param optimizationJobStatus
         *        The current status of the optimization job.
         * @see OptimizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobStatus
         */
        Builder optimizationJobStatus(String optimizationJobStatus);

        /**
         * <p>
         * The current status of the optimization job.
         * </p>
         * 
         * @param optimizationJobStatus
         *        The current status of the optimization job.
         * @see OptimizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobStatus
         */
        Builder optimizationJobStatus(OptimizationJobStatus optimizationJobStatus);

        /**
         * <p>
         * The time when the optimization job started.
         * </p>
         * 
         * @param optimizationStartTime
         *        The time when the optimization job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationStartTime(Instant optimizationStartTime);

        /**
         * <p>
         * The time when the optimization job finished processing.
         * </p>
         * 
         * @param optimizationEndTime
         *        The time when the optimization job finished processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationEndTime(Instant optimizationEndTime);

        /**
         * <p>
         * The time when you created the optimization job.
         * </p>
         * 
         * @param creationTime
         *        The time when you created the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the optimization job was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the optimization job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * If the optimization job status is <code>FAILED</code>, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        If the optimization job status is <code>FAILED</code>, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The name that you assigned to the optimization job.
         * </p>
         * 
         * @param optimizationJobName
         *        The name that you assigned to the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobName(String optimizationJobName);

        /**
         * <p>
         * The location of the source model to optimize with an optimization job.
         * </p>
         * 
         * @param modelSource
         *        The location of the source model to optimize with an optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSource(OptimizationJobModelSource modelSource);

        /**
         * <p>
         * The location of the source model to optimize with an optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationJobModelSource.Builder}
         * avoiding the need to create one manually via {@link OptimizationJobModelSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationJobModelSource.Builder#build()} is called immediately
         * and its result is passed to {@link #modelSource(OptimizationJobModelSource)}.
         * 
         * @param modelSource
         *        a consumer that will call methods on {@link OptimizationJobModelSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelSource(OptimizationJobModelSource)
         */
        default Builder modelSource(Consumer<OptimizationJobModelSource.Builder> modelSource) {
            return modelSource(OptimizationJobModelSource.builder().applyMutation(modelSource).build());
        }

        /**
         * <p>
         * The environment variables to set in the model container.
         * </p>
         * 
         * @param optimizationEnvironment
         *        The environment variables to set in the model container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationEnvironment(Map<String, String> optimizationEnvironment);

        /**
         * <p>
         * The type of instance that hosts the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param deploymentInstanceType
         *        The type of instance that hosts the optimized model that you create with the optimization job.
         * @see OptimizationJobDeploymentInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobDeploymentInstanceType
         */
        Builder deploymentInstanceType(String deploymentInstanceType);

        /**
         * <p>
         * The type of instance that hosts the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param deploymentInstanceType
         *        The type of instance that hosts the optimized model that you create with the optimization job.
         * @see OptimizationJobDeploymentInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobDeploymentInstanceType
         */
        Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType);

        /**
         * <p>
         * Settings for each of the optimization techniques that the job applies.
         * </p>
         * 
         * @param optimizationConfigs
         *        Settings for each of the optimization techniques that the job applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationConfigs(Collection<OptimizationConfig> optimizationConfigs);

        /**
         * <p>
         * Settings for each of the optimization techniques that the job applies.
         * </p>
         * 
         * @param optimizationConfigs
         *        Settings for each of the optimization techniques that the job applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationConfigs(OptimizationConfig... optimizationConfigs);

        /**
         * <p>
         * Settings for each of the optimization techniques that the job applies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #optimizationConfigs(List<OptimizationConfig>)}.
         * 
         * @param optimizationConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.OptimizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optimizationConfigs(java.util.Collection<OptimizationConfig>)
         */
        Builder optimizationConfigs(Consumer<OptimizationConfig.Builder>... optimizationConfigs);

        /**
         * <p>
         * Details for where to store the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param outputConfig
         *        Details for where to store the optimized model that you create with the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OptimizationJobOutputConfig outputConfig);

        /**
         * <p>
         * Details for where to store the optimized model that you create with the optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationJobOutputConfig.Builder}
         * avoiding the need to create one manually via {@link OptimizationJobOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationJobOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(OptimizationJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OptimizationJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OptimizationJobOutputConfig)
         */
        default Builder outputConfig(Consumer<OptimizationJobOutputConfig.Builder> outputConfig) {
            return outputConfig(OptimizationJobOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * Output values produced by an optimization job.
         * </p>
         * 
         * @param optimizationOutput
         *        Output values produced by an optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationOutput(OptimizationOutput optimizationOutput);

        /**
         * <p>
         * Output values produced by an optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationOutput.Builder} avoiding the
         * need to create one manually via {@link OptimizationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #optimizationOutput(OptimizationOutput)}.
         * 
         * @param optimizationOutput
         *        a consumer that will call methods on {@link OptimizationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optimizationOutput(OptimizationOutput)
         */
        default Builder optimizationOutput(Consumer<OptimizationOutput.Builder> optimizationOutput) {
            return optimizationOutput(OptimizationOutput.builder().applyMutation(optimizationOutput).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that you assigned to the optimization job.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that you assigned to the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * A VPC in Amazon VPC that your optimized model has access to.
         * </p>
         * 
         * @param vpcConfig
         *        A VPC in Amazon VPC that your optimized model has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(OptimizationVpcConfig vpcConfig);

        /**
         * <p>
         * A VPC in Amazon VPC that your optimized model has access to.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationVpcConfig.Builder} avoiding
         * the need to create one manually via {@link OptimizationVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationVpcConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcConfig(OptimizationVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link OptimizationVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(OptimizationVpcConfig)
         */
        default Builder vpcConfig(Consumer<OptimizationVpcConfig.Builder> vpcConfig) {
            return vpcConfig(OptimizationVpcConfig.builder().applyMutation(vpcConfig).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String optimizationJobArn;

        private String optimizationJobStatus;

        private Instant optimizationStartTime;

        private Instant optimizationEndTime;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private String optimizationJobName;

        private OptimizationJobModelSource modelSource;

        private Map<String, String> optimizationEnvironment = DefaultSdkAutoConstructMap.getInstance();

        private String deploymentInstanceType;

        private List<OptimizationConfig> optimizationConfigs = DefaultSdkAutoConstructList.getInstance();

        private OptimizationJobOutputConfig outputConfig;

        private OptimizationOutput optimizationOutput;

        private String roleArn;

        private StoppingCondition stoppingCondition;

        private OptimizationVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptimizationJobResponse model) {
            super(model);
            optimizationJobArn(model.optimizationJobArn);
            optimizationJobStatus(model.optimizationJobStatus);
            optimizationStartTime(model.optimizationStartTime);
            optimizationEndTime(model.optimizationEndTime);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            optimizationJobName(model.optimizationJobName);
            modelSource(model.modelSource);
            optimizationEnvironment(model.optimizationEnvironment);
            deploymentInstanceType(model.deploymentInstanceType);
            optimizationConfigs(model.optimizationConfigs);
            outputConfig(model.outputConfig);
            optimizationOutput(model.optimizationOutput);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
            vpcConfig(model.vpcConfig);
        }

        public final String getOptimizationJobArn() {
            return optimizationJobArn;
        }

        public final void setOptimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
        }

        @Override
        public final Builder optimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
            return this;
        }

        public final String getOptimizationJobStatus() {
            return optimizationJobStatus;
        }

        public final void setOptimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
        }

        @Override
        public final Builder optimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
            return this;
        }

        @Override
        public final Builder optimizationJobStatus(OptimizationJobStatus optimizationJobStatus) {
            this.optimizationJobStatus(optimizationJobStatus == null ? null : optimizationJobStatus.toString());
            return this;
        }

        public final Instant getOptimizationStartTime() {
            return optimizationStartTime;
        }

        public final void setOptimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
        }

        @Override
        public final Builder optimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
            return this;
        }

        public final Instant getOptimizationEndTime() {
            return optimizationEndTime;
        }

        public final void setOptimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
        }

        @Override
        public final Builder optimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getOptimizationJobName() {
            return optimizationJobName;
        }

        public final void setOptimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
        }

        @Override
        public final Builder optimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
            return this;
        }

        public final OptimizationJobModelSource.Builder getModelSource() {
            return modelSource != null ? modelSource.toBuilder() : null;
        }

        public final void setModelSource(OptimizationJobModelSource.BuilderImpl modelSource) {
            this.modelSource = modelSource != null ? modelSource.build() : null;
        }

        @Override
        public final Builder modelSource(OptimizationJobModelSource modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        public final Map<String, String> getOptimizationEnvironment() {
            if (optimizationEnvironment instanceof SdkAutoConstructMap) {
                return null;
            }
            return optimizationEnvironment;
        }

        public final void setOptimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
        }

        @Override
        public final Builder optimizationEnvironment(Map<String, String> optimizationEnvironment) {
            this.optimizationEnvironment = OptimizationJobEnvironmentVariablesCopier.copy(optimizationEnvironment);
            return this;
        }

        public final String getDeploymentInstanceType() {
            return deploymentInstanceType;
        }

        public final void setDeploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
        }

        @Override
        public final Builder deploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
            return this;
        }

        @Override
        public final Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType) {
            this.deploymentInstanceType(deploymentInstanceType == null ? null : deploymentInstanceType.toString());
            return this;
        }

        public final List<OptimizationConfig.Builder> getOptimizationConfigs() {
            List<OptimizationConfig.Builder> result = OptimizationConfigsCopier.copyToBuilder(this.optimizationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizationConfigs(Collection<OptimizationConfig.BuilderImpl> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copyFromBuilder(optimizationConfigs);
        }

        @Override
        public final Builder optimizationConfigs(Collection<OptimizationConfig> optimizationConfigs) {
            this.optimizationConfigs = OptimizationConfigsCopier.copy(optimizationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(OptimizationConfig... optimizationConfigs) {
            optimizationConfigs(Arrays.asList(optimizationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationConfigs(Consumer<OptimizationConfig.Builder>... optimizationConfigs) {
            optimizationConfigs(Stream.of(optimizationConfigs).map(c -> OptimizationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OptimizationJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OptimizationJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OptimizationJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final OptimizationOutput.Builder getOptimizationOutput() {
            return optimizationOutput != null ? optimizationOutput.toBuilder() : null;
        }

        public final void setOptimizationOutput(OptimizationOutput.BuilderImpl optimizationOutput) {
            this.optimizationOutput = optimizationOutput != null ? optimizationOutput.build() : null;
        }

        @Override
        public final Builder optimizationOutput(OptimizationOutput optimizationOutput) {
            this.optimizationOutput = optimizationOutput;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final OptimizationVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(OptimizationVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(OptimizationVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public DescribeOptimizationJobResponse build() {
            return new DescribeOptimizationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
