/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSearchSuggestionsRequest extends SageMakerRequest implements
        ToCopyableBuilder<GetSearchSuggestionsRequest.Builder, GetSearchSuggestionsRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(GetSearchSuggestionsRequest::resourceAsString))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<SuggestionQuery> SUGGESTION_QUERY_FIELD = SdkField
            .<SuggestionQuery> builder(MarshallingType.SDK_POJO).memberName("SuggestionQuery")
            .getter(getter(GetSearchSuggestionsRequest::suggestionQuery)).setter(setter(Builder::suggestionQuery))
            .constructor(SuggestionQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            SUGGESTION_QUERY_FIELD));

    private final String resource;

    private final SuggestionQuery suggestionQuery;

    private GetSearchSuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.suggestionQuery = builder.suggestionQuery;
    }

    /**
     * <p>
     * The name of the SageMaker resource to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resource} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceAsString}.
     * </p>
     * 
     * @return The name of the SageMaker resource to search for.
     * @see ResourceType
     */
    public final ResourceType resource() {
        return ResourceType.fromValue(resource);
    }

    /**
     * <p>
     * The name of the SageMaker resource to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resource} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceAsString}.
     * </p>
     * 
     * @return The name of the SageMaker resource to search for.
     * @see ResourceType
     */
    public final String resourceAsString() {
        return resource;
    }

    /**
     * <p>
     * Limits the property names that are included in the response.
     * </p>
     * 
     * @return Limits the property names that are included in the response.
     */
    public final SuggestionQuery suggestionQuery() {
        return suggestionQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(suggestionQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchSuggestionsRequest)) {
            return false;
        }
        GetSearchSuggestionsRequest other = (GetSearchSuggestionsRequest) obj;
        return Objects.equals(resourceAsString(), other.resourceAsString())
                && Objects.equals(suggestionQuery(), other.suggestionQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSearchSuggestionsRequest").add("Resource", resourceAsString())
                .add("SuggestionQuery", suggestionQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resourceAsString()));
        case "SuggestionQuery":
            return Optional.ofNullable(clazz.cast(suggestionQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSearchSuggestionsRequest, T> g) {
        return obj -> g.apply((GetSearchSuggestionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSearchSuggestionsRequest> {
        /**
         * <p>
         * The name of the SageMaker resource to search for.
         * </p>
         * 
         * @param resource
         *        The name of the SageMaker resource to search for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resource(String resource);

        /**
         * <p>
         * The name of the SageMaker resource to search for.
         * </p>
         * 
         * @param resource
         *        The name of the SageMaker resource to search for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resource(ResourceType resource);

        /**
         * <p>
         * Limits the property names that are included in the response.
         * </p>
         * 
         * @param suggestionQuery
         *        Limits the property names that are included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionQuery(SuggestionQuery suggestionQuery);

        /**
         * <p>
         * Limits the property names that are included in the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuggestionQuery.Builder} avoiding the
         * need to create one manually via {@link SuggestionQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggestionQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #suggestionQuery(SuggestionQuery)}.
         * 
         * @param suggestionQuery
         *        a consumer that will call methods on {@link SuggestionQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestionQuery(SuggestionQuery)
         */
        default Builder suggestionQuery(Consumer<SuggestionQuery.Builder> suggestionQuery) {
            return suggestionQuery(SuggestionQuery.builder().applyMutation(suggestionQuery).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String resource;

        private SuggestionQuery suggestionQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchSuggestionsRequest model) {
            super(model);
            resource(model.resource);
            suggestionQuery(model.suggestionQuery);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public final Builder resource(ResourceType resource) {
            this.resource(resource == null ? null : resource.toString());
            return this;
        }

        public final SuggestionQuery.Builder getSuggestionQuery() {
            return suggestionQuery != null ? suggestionQuery.toBuilder() : null;
        }

        public final void setSuggestionQuery(SuggestionQuery.BuilderImpl suggestionQuery) {
            this.suggestionQuery = suggestionQuery != null ? suggestionQuery.build() : null;
        }

        @Override
        public final Builder suggestionQuery(SuggestionQuery suggestionQuery) {
            this.suggestionQuery = suggestionQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSearchSuggestionsRequest build() {
            return new GetSearchSuggestionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
