/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration for attaching additional storage to the instances in the SageMaker HyperPod cluster
 * instance group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterInstanceStorageConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterInstanceStorageConfig.Builder, ClusterInstanceStorageConfig> {
    private static final SdkField<ClusterEbsVolumeConfig> EBS_VOLUME_CONFIG_FIELD = SdkField
            .<ClusterEbsVolumeConfig> builder(MarshallingType.SDK_POJO).memberName("EbsVolumeConfig")
            .getter(getter(ClusterInstanceStorageConfig::ebsVolumeConfig)).setter(setter(Builder::ebsVolumeConfig))
            .constructor(ClusterEbsVolumeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsVolumeConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_VOLUME_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final ClusterEbsVolumeConfig ebsVolumeConfig;

    private final Type type;

    private ClusterInstanceStorageConfig(BuilderImpl builder) {
        this.ebsVolumeConfig = builder.ebsVolumeConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in
     * the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance within the
     * SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
     * </p>
     * 
     * @return Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the
     *         instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each
     *         instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
     */
    public final ClusterEbsVolumeConfig ebsVolumeConfig() {
        return ebsVolumeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolumeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInstanceStorageConfig)) {
            return false;
        }
        ClusterInstanceStorageConfig other = (ClusterInstanceStorageConfig) obj;
        return Objects.equals(ebsVolumeConfig(), other.ebsVolumeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterInstanceStorageConfig").add("EbsVolumeConfig", ebsVolumeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsVolumeConfig":
            return Optional.ofNullable(clazz.cast(ebsVolumeConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ebsVolumeConfig()} initialized to the given value.
     *
     * <p>
     * Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in
     * the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance within the
     * SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
     * </p>
     * 
     * @param ebsVolumeConfig
     *        Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the
     *        instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each
     *        instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
     */
    public static ClusterInstanceStorageConfig fromEbsVolumeConfig(ClusterEbsVolumeConfig ebsVolumeConfig) {
        return builder().ebsVolumeConfig(ebsVolumeConfig).build();
    }

    /**
     * Create an instance of this class with {@link #ebsVolumeConfig()} initialized to the given value.
     *
     * <p>
     * Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in
     * the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance within the
     * SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
     * </p>
     * 
     * @param ebsVolumeConfig
     *        Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the
     *        instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each
     *        instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
     */
    public static ClusterInstanceStorageConfig fromEbsVolumeConfig(Consumer<ClusterEbsVolumeConfig.Builder> ebsVolumeConfig) {
        ClusterEbsVolumeConfig.Builder builder = ClusterEbsVolumeConfig.builder();
        ebsVolumeConfig.accept(builder);
        return fromEbsVolumeConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInstanceStorageConfig, T> g) {
        return obj -> g.apply((ClusterInstanceStorageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterInstanceStorageConfig> {
        /**
         * <p>
         * Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances
         * in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance
         * within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
         * </p>
         * 
         * @param ebsVolumeConfig
         *        Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the
         *        instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to
         *        each instance within the SageMaker HyperPod cluster instance group and mounted to
         *        <code>/opt/sagemaker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolumeConfig(ClusterEbsVolumeConfig ebsVolumeConfig);

        /**
         * <p>
         * Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances
         * in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance
         * within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterEbsVolumeConfig.Builder} avoiding
         * the need to create one manually via {@link ClusterEbsVolumeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterEbsVolumeConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #ebsVolumeConfig(ClusterEbsVolumeConfig)}.
         * 
         * @param ebsVolumeConfig
         *        a consumer that will call methods on {@link ClusterEbsVolumeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsVolumeConfig(ClusterEbsVolumeConfig)
         */
        default Builder ebsVolumeConfig(Consumer<ClusterEbsVolumeConfig.Builder> ebsVolumeConfig) {
            return ebsVolumeConfig(ClusterEbsVolumeConfig.builder().applyMutation(ebsVolumeConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClusterEbsVolumeConfig ebsVolumeConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInstanceStorageConfig model) {
            ebsVolumeConfig(model.ebsVolumeConfig);
        }

        public final ClusterEbsVolumeConfig.Builder getEbsVolumeConfig() {
            return ebsVolumeConfig != null ? ebsVolumeConfig.toBuilder() : null;
        }

        public final void setEbsVolumeConfig(ClusterEbsVolumeConfig.BuilderImpl ebsVolumeConfig) {
            Object oldValue = this.ebsVolumeConfig;
            this.ebsVolumeConfig = ebsVolumeConfig != null ? ebsVolumeConfig.build() : null;
            handleUnionValueChange(Type.EBS_VOLUME_CONFIG, oldValue, this.ebsVolumeConfig);
        }

        @Override
        public final Builder ebsVolumeConfig(ClusterEbsVolumeConfig ebsVolumeConfig) {
            Object oldValue = this.ebsVolumeConfig;
            this.ebsVolumeConfig = ebsVolumeConfig;
            handleUnionValueChange(Type.EBS_VOLUME_CONFIG, oldValue, this.ebsVolumeConfig);
            return this;
        }

        @Override
        public ClusterInstanceStorageConfig build() {
            return new ClusterInstanceStorageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ClusterInstanceStorageConfig#type()
     */
    public enum Type {
        EBS_VOLUME_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
