/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutoMlJobV2Request extends SageMakerRequest implements
        ToCopyableBuilder<CreateAutoMlJobV2Request.Builder, CreateAutoMlJobV2Request> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobName").getter(getter(CreateAutoMlJobV2Request::autoMLJobName))
            .setter(setter(Builder::autoMLJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()).build();

    private static final SdkField<List<AutoMLJobChannel>> AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<AutoMLJobChannel>> builder(MarshallingType.LIST)
            .memberName("AutoMLJobInputDataConfig")
            .getter(getter(CreateAutoMlJobV2Request::autoMLJobInputDataConfig))
            .setter(setter(Builder::autoMLJobInputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobInputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLJobChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLJobChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<AutoMLOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(CreateAutoMlJobV2Request::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(AutoMLOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<AutoMLProblemTypeConfig> AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD = SdkField
            .<AutoMLProblemTypeConfig> builder(MarshallingType.SDK_POJO).memberName("AutoMLProblemTypeConfig")
            .getter(getter(CreateAutoMlJobV2Request::autoMLProblemTypeConfig)).setter(setter(Builder::autoMLProblemTypeConfig))
            .constructor(AutoMLProblemTypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLProblemTypeConfig").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateAutoMlJobV2Request::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAutoMlJobV2Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoMLSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<AutoMLSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(CreateAutoMlJobV2Request::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(AutoMLSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField
            .<AutoMLJobObjective> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobObjective")
            .getter(getter(CreateAutoMlJobV2Request::autoMLJobObjective)).setter(setter(Builder::autoMLJobObjective))
            .constructor(AutoMLJobObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build())
            .build();

    private static final SdkField<ModelDeployConfig> MODEL_DEPLOY_CONFIG_FIELD = SdkField
            .<ModelDeployConfig> builder(MarshallingType.SDK_POJO).memberName("ModelDeployConfig")
            .getter(getter(CreateAutoMlJobV2Request::modelDeployConfig)).setter(setter(Builder::modelDeployConfig))
            .constructor(ModelDeployConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDeployConfig").build()).build();

    private static final SdkField<AutoMLDataSplitConfig> DATA_SPLIT_CONFIG_FIELD = SdkField
            .<AutoMLDataSplitConfig> builder(MarshallingType.SDK_POJO).memberName("DataSplitConfig")
            .getter(getter(CreateAutoMlJobV2Request::dataSplitConfig)).setter(setter(Builder::dataSplitConfig))
            .constructor(AutoMLDataSplitConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSplitConfig").build()).build();

    private static final SdkField<AutoMLComputeConfig> AUTO_ML_COMPUTE_CONFIG_FIELD = SdkField
            .<AutoMLComputeConfig> builder(MarshallingType.SDK_POJO).memberName("AutoMLComputeConfig")
            .getter(getter(CreateAutoMlJobV2Request::autoMLComputeConfig)).setter(setter(Builder::autoMLComputeConfig))
            .constructor(AutoMLComputeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLComputeConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD,
            AUTO_ML_JOB_INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, AUTO_ML_PROBLEM_TYPE_CONFIG_FIELD, ROLE_ARN_FIELD,
            TAGS_FIELD, SECURITY_CONFIG_FIELD, AUTO_ML_JOB_OBJECTIVE_FIELD, MODEL_DEPLOY_CONFIG_FIELD, DATA_SPLIT_CONFIG_FIELD,
            AUTO_ML_COMPUTE_CONFIG_FIELD));

    private final String autoMLJobName;

    private final List<AutoMLJobChannel> autoMLJobInputDataConfig;

    private final AutoMLOutputDataConfig outputDataConfig;

    private final AutoMLProblemTypeConfig autoMLProblemTypeConfig;

    private final String roleArn;

    private final List<Tag> tags;

    private final AutoMLSecurityConfig securityConfig;

    private final AutoMLJobObjective autoMLJobObjective;

    private final ModelDeployConfig modelDeployConfig;

    private final AutoMLDataSplitConfig dataSplitConfig;

    private final AutoMLComputeConfig autoMLComputeConfig;

    private CreateAutoMlJobV2Request(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobInputDataConfig = builder.autoMLJobInputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.autoMLProblemTypeConfig = builder.autoMLProblemTypeConfig;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.securityConfig = builder.securityConfig;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.modelDeployConfig = builder.modelDeployConfig;
        this.dataSplitConfig = builder.dataSplitConfig;
        this.autoMLComputeConfig = builder.autoMLComputeConfig;
    }

    /**
     * <p>
     * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
     * </p>
     * 
     * @return Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
     */
    public final String autoMLJobName() {
        return autoMLJobName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoMLJobInputDataConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoMLJobInputDataConfig() {
        return autoMLJobInputDataConfig != null && !(autoMLJobInputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of channel objects describing the input data and their location. Each channel is a named input source.
     * Similar to the <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig"
     * >InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported formats depend
     * on the problem type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>, <code>AugmentedManifestFile</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For text classification: <code>S3Prefix</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For time-series forecasting: <code>S3Prefix</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For text generation (LLMs fine-tuning): <code>S3Prefix</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoMLJobInputDataConfig} method.
     * </p>
     * 
     * @return An array of channel objects describing the input data and their location. Each channel is a named input
     *         source. Similar to the <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig"
     *         >InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported
     *         formats depend on the problem type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>,
     *         <code>AugmentedManifestFile</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For text classification: <code>S3Prefix</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For time-series forecasting: <code>S3Prefix</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For text generation (LLMs fine-tuning): <code>S3Prefix</code>.
     *         </p>
     *         </li>
     */
    public final List<AutoMLJobChannel> autoMLJobInputDataConfig() {
        return autoMLJobInputDataConfig;
    }

    /**
     * <p>
     * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job.
     * </p>
     * 
     * @return Provides information about encryption and the Amazon S3 output path needed to store artifacts from an
     *         AutoML job.
     */
    public final AutoMLOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * Defines the configuration settings of one of the supported problem types.
     * </p>
     * 
     * @return Defines the configuration settings of one of the supported problem types.
     */
    public final AutoMLProblemTypeConfig autoMLProblemTypeConfig() {
        return autoMLProblemTypeConfig;
    }

    /**
     * <p>
     * The ARN of the role that is used to access the data.
     * </p>
     * 
     * @return The ARN of the role that is used to access the data.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * such as by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web ServicesResources</a>.
     * Tag keys must be unique per resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, such as by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
     *         ServicesResources</a>. Tag keys must be unique per resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The security configuration for traffic encryption or Amazon VPC settings.
     * </p>
     * 
     * @return The security configuration for traffic encryption or Amazon VPC settings.
     */
    public final AutoMLSecurityConfig securityConfig() {
        return securityConfig;
    }

    /**
     * <p>
     * Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective
     * metric depends on the problem type. For the list of default values per problem type, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html"
     * >AutoMLJobObjective</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * For tabular problem types: You must either provide both the <code>AutoMLJobObjective</code> and indicate the type
     * of supervised learning problem in <code>AutoMLProblemTypeConfig</code> (<code>TabularJobConfig.ProblemType</code>
     * ), or none at all.
     * </p>
     * </li>
     * <li>
     * <p>
     * For text generation problem types (LLMs fine-tuning): Fine-tuning language models in Autopilot does not require
     * setting the <code>AutoMLJobObjective</code> field. Autopilot fine-tunes LLMs without requiring multiple
     * candidates to be trained and evaluated. Instead, using your dataset, Autopilot directly fine-tunes your target
     * model to enhance a default objective metric, the cross-entropy loss. After fine-tuning a language model, you can
     * evaluate the quality of its generated text using different metrics. For a list of the available metrics, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html">Metrics for
     * fine-tuning LLMs in Autopilot</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default
     *         objective metric depends on the problem type. For the list of default values per problem type, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html">
     *         AutoMLJobObjective</a>.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         For tabular problem types: You must either provide both the <code>AutoMLJobObjective</code> and indicate
     *         the type of supervised learning problem in <code>AutoMLProblemTypeConfig</code> (
     *         <code>TabularJobConfig.ProblemType</code>), or none at all.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For text generation problem types (LLMs fine-tuning): Fine-tuning language models in Autopilot does not
     *         require setting the <code>AutoMLJobObjective</code> field. Autopilot fine-tunes LLMs without requiring
     *         multiple candidates to be trained and evaluated. Instead, using your dataset, Autopilot directly
     *         fine-tunes your target model to enhance a default objective metric, the cross-entropy loss. After
     *         fine-tuning a language model, you can evaluate the quality of its generated text using different metrics.
     *         For a list of the available metrics, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html">Metrics for
     *         fine-tuning LLMs in Autopilot</a>.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final AutoMLJobObjective autoMLJobObjective() {
        return autoMLJobObjective;
    }

    /**
     * <p>
     * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
     * </p>
     * 
     * @return Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
     */
    public final ModelDeployConfig modelDeployConfig() {
        return modelDeployConfig;
    }

    /**
     * <p>
     * This structure specifies how to split the data into train and validation datasets.
     * </p>
     * <p>
     * The validation and training datasets must contain the same headers. For jobs created by calling
     * <code>CreateAutoMLJob</code>, the validation dataset must be less than 2 GB in size.
     * </p>
     * <note>
     * <p>
     * This attribute must not be set for the time-series forecasting problem type, as Autopilot automatically splits
     * the input dataset into training and validation sets.
     * </p>
     * </note>
     * 
     * @return This structure specifies how to split the data into train and validation datasets.</p>
     *         <p>
     *         The validation and training datasets must contain the same headers. For jobs created by calling
     *         <code>CreateAutoMLJob</code>, the validation dataset must be less than 2 GB in size.
     *         </p>
     *         <note>
     *         <p>
     *         This attribute must not be set for the time-series forecasting problem type, as Autopilot automatically
     *         splits the input dataset into training and validation sets.
     *         </p>
     */
    public final AutoMLDataSplitConfig dataSplitConfig() {
        return dataSplitConfig;
    }

    /**
     * <p>
     * Specifies the compute configuration for the AutoML job V2.
     * </p>
     * 
     * @return Specifies the compute configuration for the AutoML job V2.
     */
    public final AutoMLComputeConfig autoMLComputeConfig() {
        return autoMLComputeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoMLJobInputDataConfig() ? autoMLJobInputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLProblemTypeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(modelDeployConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataSplitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLComputeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoMlJobV2Request)) {
            return false;
        }
        CreateAutoMlJobV2Request other = (CreateAutoMlJobV2Request) obj;
        return Objects.equals(autoMLJobName(), other.autoMLJobName())
                && hasAutoMLJobInputDataConfig() == other.hasAutoMLJobInputDataConfig()
                && Objects.equals(autoMLJobInputDataConfig(), other.autoMLJobInputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(autoMLProblemTypeConfig(), other.autoMLProblemTypeConfig())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(securityConfig(), other.securityConfig())
                && Objects.equals(autoMLJobObjective(), other.autoMLJobObjective())
                && Objects.equals(modelDeployConfig(), other.modelDeployConfig())
                && Objects.equals(dataSplitConfig(), other.dataSplitConfig())
                && Objects.equals(autoMLComputeConfig(), other.autoMLComputeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutoMlJobV2Request").add("AutoMLJobName", autoMLJobName())
                .add("AutoMLJobInputDataConfig", hasAutoMLJobInputDataConfig() ? autoMLJobInputDataConfig() : null)
                .add("OutputDataConfig", outputDataConfig()).add("AutoMLProblemTypeConfig", autoMLProblemTypeConfig())
                .add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).add("SecurityConfig", securityConfig())
                .add("AutoMLJobObjective", autoMLJobObjective()).add("ModelDeployConfig", modelDeployConfig())
                .add("DataSplitConfig", dataSplitConfig()).add("AutoMLComputeConfig", autoMLComputeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobName":
            return Optional.ofNullable(clazz.cast(autoMLJobName()));
        case "AutoMLJobInputDataConfig":
            return Optional.ofNullable(clazz.cast(autoMLJobInputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "AutoMLProblemTypeConfig":
            return Optional.ofNullable(clazz.cast(autoMLProblemTypeConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        case "AutoMLJobObjective":
            return Optional.ofNullable(clazz.cast(autoMLJobObjective()));
        case "ModelDeployConfig":
            return Optional.ofNullable(clazz.cast(modelDeployConfig()));
        case "DataSplitConfig":
            return Optional.ofNullable(clazz.cast(dataSplitConfig()));
        case "AutoMLComputeConfig":
            return Optional.ofNullable(clazz.cast(autoMLComputeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoMlJobV2Request, T> g) {
        return obj -> g.apply((CreateAutoMlJobV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAutoMlJobV2Request> {
        /**
         * <p>
         * Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
         * </p>
         * 
         * @param autoMLJobName
         *        Identifies an Autopilot job. The name must be unique to your account and is case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobName(String autoMLJobName);

        /**
         * <p>
         * An array of channel objects describing the input data and their location. Each channel is a named input
         * source. Similar to the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig"
         * >InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported formats
         * depend on the problem type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>,
         * <code>AugmentedManifestFile</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text classification: <code>S3Prefix</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For time-series forecasting: <code>S3Prefix</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text generation (LLMs fine-tuning): <code>S3Prefix</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoMLJobInputDataConfig
         *        An array of channel objects describing the input data and their location. Each channel is a named
         *        input source. Similar to the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig"
         *        >InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported
         *        formats depend on the problem type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>,
         *        <code>AugmentedManifestFile</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For text classification: <code>S3Prefix</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For time-series forecasting: <code>S3Prefix</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For text generation (LLMs fine-tuning): <code>S3Prefix</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> autoMLJobInputDataConfig);

        /**
         * <p>
         * An array of channel objects describing the input data and their location. Each channel is a named input
         * source. Similar to the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig"
         * >InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported formats
         * depend on the problem type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>,
         * <code>AugmentedManifestFile</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text classification: <code>S3Prefix</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For time-series forecasting: <code>S3Prefix</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text generation (LLMs fine-tuning): <code>S3Prefix</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoMLJobInputDataConfig
         *        An array of channel objects describing the input data and their location. Each channel is a named
         *        input source. Similar to the <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig"
         *        >InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported
         *        formats depend on the problem type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>,
         *        <code>AugmentedManifestFile</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For text classification: <code>S3Prefix</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For time-series forecasting: <code>S3Prefix</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For text generation (LLMs fine-tuning): <code>S3Prefix</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobInputDataConfig(AutoMLJobChannel... autoMLJobInputDataConfig);

        /**
         * <p>
         * An array of channel objects describing the input data and their location. Each channel is a named input
         * source. Similar to the <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig"
         * >InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported formats
         * depend on the problem type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>,
         * <code>AugmentedManifestFile</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text classification: <code>S3Prefix</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For time-series forecasting: <code>S3Prefix</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text generation (LLMs fine-tuning): <code>S3Prefix</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel.Builder#build()} is called
         * immediately and its result is passed to {@link #autoMLJobInputDataConfig(List<AutoMLJobChannel>)}.
         * 
         * @param autoMLJobInputDataConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLJobChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobInputDataConfig(java.util.Collection<AutoMLJobChannel>)
         */
        Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder>... autoMLJobInputDataConfig);

        /**
         * <p>
         * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML
         * job.
         * </p>
         * 
         * @param outputDataConfig
         *        Provides information about encryption and the Amazon S3 output path needed to store artifacts from an
         *        AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML
         * job.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLOutputDataConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLOutputDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outputDataConfig(AutoMLOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link AutoMLOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(AutoMLOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * Defines the configuration settings of one of the supported problem types.
         * </p>
         * 
         * @param autoMLProblemTypeConfig
         *        Defines the configuration settings of one of the supported problem types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig autoMLProblemTypeConfig);

        /**
         * <p>
         * Defines the configuration settings of one of the supported problem types.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLProblemTypeConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLProblemTypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLProblemTypeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #autoMLProblemTypeConfig(AutoMLProblemTypeConfig)}.
         * 
         * @param autoMLProblemTypeConfig
         *        a consumer that will call methods on {@link AutoMLProblemTypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLProblemTypeConfig(AutoMLProblemTypeConfig)
         */
        default Builder autoMLProblemTypeConfig(Consumer<AutoMLProblemTypeConfig.Builder> autoMLProblemTypeConfig) {
            return autoMLProblemTypeConfig(AutoMLProblemTypeConfig.builder().applyMutation(autoMLProblemTypeConfig).build());
        }

        /**
         * <p>
         * The ARN of the role that is used to access the data.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that is used to access the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, such as by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         * ServicesResources</a>. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, such as by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         *        ServicesResources</a>. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, such as by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         * ServicesResources</a>. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, such as by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         *        ServicesResources</a>. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, such as by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
         * ServicesResources</a>. Tag keys must be unique per resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * 
         * @param securityConfig
         *        The security configuration for traffic encryption or Amazon VPC settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(AutoMLSecurityConfig securityConfig);

        /**
         * <p>
         * The security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLSecurityConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLSecurityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #securityConfig(AutoMLSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link AutoMLSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(AutoMLSecurityConfig)
         */
        default Builder securityConfig(Consumer<AutoMLSecurityConfig.Builder> securityConfig) {
            return securityConfig(AutoMLSecurityConfig.builder().applyMutation(securityConfig).build());
        }

        /**
         * <p>
         * Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective
         * metric depends on the problem type. For the list of default values per problem type, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html"
         * >AutoMLJobObjective</a>.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * For tabular problem types: You must either provide both the <code>AutoMLJobObjective</code> and indicate the
         * type of supervised learning problem in <code>AutoMLProblemTypeConfig</code> (
         * <code>TabularJobConfig.ProblemType</code>), or none at all.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text generation problem types (LLMs fine-tuning): Fine-tuning language models in Autopilot does not
         * require setting the <code>AutoMLJobObjective</code> field. Autopilot fine-tunes LLMs without requiring
         * multiple candidates to be trained and evaluated. Instead, using your dataset, Autopilot directly fine-tunes
         * your target model to enhance a default objective metric, the cross-entropy loss. After fine-tuning a language
         * model, you can evaluate the quality of its generated text using different metrics. For a list of the
         * available metrics, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html">Metrics for
         * fine-tuning LLMs in Autopilot</a>.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param autoMLJobObjective
         *        Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default
         *        objective metric depends on the problem type. For the list of default values per problem type, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html">
         *        AutoMLJobObjective</a>.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        For tabular problem types: You must either provide both the <code>AutoMLJobObjective</code> and
         *        indicate the type of supervised learning problem in <code>AutoMLProblemTypeConfig</code> (
         *        <code>TabularJobConfig.ProblemType</code>), or none at all.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For text generation problem types (LLMs fine-tuning): Fine-tuning language models in Autopilot does
         *        not require setting the <code>AutoMLJobObjective</code> field. Autopilot fine-tunes LLMs without
         *        requiring multiple candidates to be trained and evaluated. Instead, using your dataset, Autopilot
         *        directly fine-tunes your target model to enhance a default objective metric, the cross-entropy loss.
         *        After fine-tuning a language model, you can evaluate the quality of its generated text using different
         *        metrics. For a list of the available metrics, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html">Metrics
         *        for fine-tuning LLMs in Autopilot</a>.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective);

        /**
         * <p>
         * Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective
         * metric depends on the problem type. For the list of default values per problem type, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html"
         * >AutoMLJobObjective</a>.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * For tabular problem types: You must either provide both the <code>AutoMLJobObjective</code> and indicate the
         * type of supervised learning problem in <code>AutoMLProblemTypeConfig</code> (
         * <code>TabularJobConfig.ProblemType</code>), or none at all.
         * </p>
         * </li>
         * <li>
         * <p>
         * For text generation problem types (LLMs fine-tuning): Fine-tuning language models in Autopilot does not
         * require setting the <code>AutoMLJobObjective</code> field. Autopilot fine-tunes LLMs without requiring
         * multiple candidates to be trained and evaluated. Instead, using your dataset, Autopilot directly fine-tunes
         * your target model to enhance a default objective metric, the cross-entropy loss. After fine-tuning a language
         * model, you can evaluate the quality of its generated text using different metrics. For a list of the
         * available metrics, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html">Metrics for
         * fine-tuning LLMs in Autopilot</a>.
         * </p>
         * </li>
         * </ul>
         * </note> This is a convenience method that creates an instance of the {@link AutoMLJobObjective.Builder}
         * avoiding the need to create one manually via {@link AutoMLJobObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobObjective.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobObjective(AutoMLJobObjective)}.
         * 
         * @param autoMLJobObjective
         *        a consumer that will call methods on {@link AutoMLJobObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobObjective(AutoMLJobObjective)
         */
        default Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return autoMLJobObjective(AutoMLJobObjective.builder().applyMutation(autoMLJobObjective).build());
        }

        /**
         * <p>
         * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         * </p>
         * 
         * @param modelDeployConfig
         *        Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDeployConfig(ModelDeployConfig modelDeployConfig);

        /**
         * <p>
         * Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDeployConfig.Builder} avoiding the
         * need to create one manually via {@link ModelDeployConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDeployConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDeployConfig(ModelDeployConfig)}.
         * 
         * @param modelDeployConfig
         *        a consumer that will call methods on {@link ModelDeployConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDeployConfig(ModelDeployConfig)
         */
        default Builder modelDeployConfig(Consumer<ModelDeployConfig.Builder> modelDeployConfig) {
            return modelDeployConfig(ModelDeployConfig.builder().applyMutation(modelDeployConfig).build());
        }

        /**
         * <p>
         * This structure specifies how to split the data into train and validation datasets.
         * </p>
         * <p>
         * The validation and training datasets must contain the same headers. For jobs created by calling
         * <code>CreateAutoMLJob</code>, the validation dataset must be less than 2 GB in size.
         * </p>
         * <note>
         * <p>
         * This attribute must not be set for the time-series forecasting problem type, as Autopilot automatically
         * splits the input dataset into training and validation sets.
         * </p>
         * </note>
         * 
         * @param dataSplitConfig
         *        This structure specifies how to split the data into train and validation datasets.</p>
         *        <p>
         *        The validation and training datasets must contain the same headers. For jobs created by calling
         *        <code>CreateAutoMLJob</code>, the validation dataset must be less than 2 GB in size.
         *        </p>
         *        <note>
         *        <p>
         *        This attribute must not be set for the time-series forecasting problem type, as Autopilot
         *        automatically splits the input dataset into training and validation sets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig);

        /**
         * <p>
         * This structure specifies how to split the data into train and validation datasets.
         * </p>
         * <p>
         * The validation and training datasets must contain the same headers. For jobs created by calling
         * <code>CreateAutoMLJob</code>, the validation dataset must be less than 2 GB in size.
         * </p>
         * <note>
         * <p>
         * This attribute must not be set for the time-series forecasting problem type, as Autopilot automatically
         * splits the input dataset into training and validation sets.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link AutoMLDataSplitConfig.Builder}
         * avoiding the need to create one manually via {@link AutoMLDataSplitConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLDataSplitConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSplitConfig(AutoMLDataSplitConfig)}.
         * 
         * @param dataSplitConfig
         *        a consumer that will call methods on {@link AutoMLDataSplitConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSplitConfig(AutoMLDataSplitConfig)
         */
        default Builder dataSplitConfig(Consumer<AutoMLDataSplitConfig.Builder> dataSplitConfig) {
            return dataSplitConfig(AutoMLDataSplitConfig.builder().applyMutation(dataSplitConfig).build());
        }

        /**
         * <p>
         * Specifies the compute configuration for the AutoML job V2.
         * </p>
         * 
         * @param autoMLComputeConfig
         *        Specifies the compute configuration for the AutoML job V2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLComputeConfig(AutoMLComputeConfig autoMLComputeConfig);

        /**
         * <p>
         * Specifies the compute configuration for the AutoML job V2.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLComputeConfig.Builder} avoiding the
         * need to create one manually via {@link AutoMLComputeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLComputeConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #autoMLComputeConfig(AutoMLComputeConfig)}.
         * 
         * @param autoMLComputeConfig
         *        a consumer that will call methods on {@link AutoMLComputeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLComputeConfig(AutoMLComputeConfig)
         */
        default Builder autoMLComputeConfig(Consumer<AutoMLComputeConfig.Builder> autoMLComputeConfig) {
            return autoMLComputeConfig(AutoMLComputeConfig.builder().applyMutation(autoMLComputeConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String autoMLJobName;

        private List<AutoMLJobChannel> autoMLJobInputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private AutoMLOutputDataConfig outputDataConfig;

        private AutoMLProblemTypeConfig autoMLProblemTypeConfig;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private AutoMLSecurityConfig securityConfig;

        private AutoMLJobObjective autoMLJobObjective;

        private ModelDeployConfig modelDeployConfig;

        private AutoMLDataSplitConfig dataSplitConfig;

        private AutoMLComputeConfig autoMLComputeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoMlJobV2Request model) {
            super(model);
            autoMLJobName(model.autoMLJobName);
            autoMLJobInputDataConfig(model.autoMLJobInputDataConfig);
            outputDataConfig(model.outputDataConfig);
            autoMLProblemTypeConfig(model.autoMLProblemTypeConfig);
            roleArn(model.roleArn);
            tags(model.tags);
            securityConfig(model.securityConfig);
            autoMLJobObjective(model.autoMLJobObjective);
            modelDeployConfig(model.modelDeployConfig);
            dataSplitConfig(model.dataSplitConfig);
            autoMLComputeConfig(model.autoMLComputeConfig);
        }

        public final String getAutoMLJobName() {
            return autoMLJobName;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final List<AutoMLJobChannel.Builder> getAutoMLJobInputDataConfig() {
            List<AutoMLJobChannel.Builder> result = AutoMLJobInputDataConfigCopier.copyToBuilder(this.autoMLJobInputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoMLJobInputDataConfig(Collection<AutoMLJobChannel.BuilderImpl> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copyFromBuilder(autoMLJobInputDataConfig);
        }

        @Override
        public final Builder autoMLJobInputDataConfig(Collection<AutoMLJobChannel> autoMLJobInputDataConfig) {
            this.autoMLJobInputDataConfig = AutoMLJobInputDataConfigCopier.copy(autoMLJobInputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(AutoMLJobChannel... autoMLJobInputDataConfig) {
            autoMLJobInputDataConfig(Arrays.asList(autoMLJobInputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoMLJobInputDataConfig(Consumer<AutoMLJobChannel.Builder>... autoMLJobInputDataConfig) {
            autoMLJobInputDataConfig(Stream.of(autoMLJobInputDataConfig)
                    .map(c -> AutoMLJobChannel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final AutoMLProblemTypeConfig.Builder getAutoMLProblemTypeConfig() {
            return autoMLProblemTypeConfig != null ? autoMLProblemTypeConfig.toBuilder() : null;
        }

        public final void setAutoMLProblemTypeConfig(AutoMLProblemTypeConfig.BuilderImpl autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig != null ? autoMLProblemTypeConfig.build() : null;
        }

        @Override
        public final Builder autoMLProblemTypeConfig(AutoMLProblemTypeConfig autoMLProblemTypeConfig) {
            this.autoMLProblemTypeConfig = autoMLProblemTypeConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoMLSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(AutoMLSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(AutoMLSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return autoMLJobObjective != null ? autoMLJobObjective.toBuilder() : null;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final ModelDeployConfig.Builder getModelDeployConfig() {
            return modelDeployConfig != null ? modelDeployConfig.toBuilder() : null;
        }

        public final void setModelDeployConfig(ModelDeployConfig.BuilderImpl modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig != null ? modelDeployConfig.build() : null;
        }

        @Override
        public final Builder modelDeployConfig(ModelDeployConfig modelDeployConfig) {
            this.modelDeployConfig = modelDeployConfig;
            return this;
        }

        public final AutoMLDataSplitConfig.Builder getDataSplitConfig() {
            return dataSplitConfig != null ? dataSplitConfig.toBuilder() : null;
        }

        public final void setDataSplitConfig(AutoMLDataSplitConfig.BuilderImpl dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig != null ? dataSplitConfig.build() : null;
        }

        @Override
        public final Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig;
            return this;
        }

        public final AutoMLComputeConfig.Builder getAutoMLComputeConfig() {
            return autoMLComputeConfig != null ? autoMLComputeConfig.toBuilder() : null;
        }

        public final void setAutoMLComputeConfig(AutoMLComputeConfig.BuilderImpl autoMLComputeConfig) {
            this.autoMLComputeConfig = autoMLComputeConfig != null ? autoMLComputeConfig.build() : null;
        }

        @Override
        public final Builder autoMLComputeConfig(AutoMLComputeConfig autoMLComputeConfig) {
            this.autoMLComputeConfig = autoMLComputeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoMlJobV2Request build() {
            return new CreateAutoMlJobV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
