/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This data type is intended for use exclusively by SageMaker Canvas and cannot be used in other contexts at the
 * moment.
 * </p>
 * </note>
 * <p>
 * Specifies the compute configuration for the EMR Serverless job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmrServerlessComputeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EmrServerlessComputeConfig.Builder, EmrServerlessComputeConfig> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleARN").getter(getter(EmrServerlessComputeConfig::executionRoleARN))
            .setter(setter(Builder::executionRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionRoleARN;

    private EmrServerlessComputeConfig(BuilderImpl builder) {
        this.executionRoleARN = builder.executionRoleARN;
    }

    /**
     * <p>
     * The ARN of the IAM role granting the AutoML job V2 the necessary permissions access policies to list, connect to,
     * or manage EMR Serverless jobs. For detailed information about the required permissions of this role, see
     * "How to configure AutoML to initiate a remote job on EMR Serverless for large datasets" in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html"
     * >Create a regression or classification job for tabular data using the AutoML API</a> or <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-timeseries-forecasting.html#timeseries-forecasting-api-optional-params"
     * >Create an AutoML job for time-series forecasting using the API</a>.
     * </p>
     * 
     * @return The ARN of the IAM role granting the AutoML job V2 the necessary permissions access policies to list,
     *         connect to, or manage EMR Serverless jobs. For detailed information about the required permissions of
     *         this role, see "How to configure AutoML to initiate a remote job on EMR Serverless for large datasets" in
     *         <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html"
     *         >Create a regression or classification job for tabular data using the AutoML API</a> or <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-timeseries-forecasting.html#timeseries-forecasting-api-optional-params"
     *         >Create an AutoML job for time-series forecasting using the API</a>.
     */
    public final String executionRoleARN() {
        return executionRoleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmrServerlessComputeConfig)) {
            return false;
        }
        EmrServerlessComputeConfig other = (EmrServerlessComputeConfig) obj;
        return Objects.equals(executionRoleARN(), other.executionRoleARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmrServerlessComputeConfig").add("ExecutionRoleARN", executionRoleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionRoleARN":
            return Optional.ofNullable(clazz.cast(executionRoleARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmrServerlessComputeConfig, T> g) {
        return obj -> g.apply((EmrServerlessComputeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmrServerlessComputeConfig> {
        /**
         * <p>
         * The ARN of the IAM role granting the AutoML job V2 the necessary permissions access policies to list, connect
         * to, or manage EMR Serverless jobs. For detailed information about the required permissions of this role, see
         * "How to configure AutoML to initiate a remote job on EMR Serverless for large datasets" in <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html"
         * >Create a regression or classification job for tabular data using the AutoML API</a> or <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-timeseries-forecasting.html#timeseries-forecasting-api-optional-params"
         * >Create an AutoML job for time-series forecasting using the API</a>.
         * </p>
         * 
         * @param executionRoleARN
         *        The ARN of the IAM role granting the AutoML job V2 the necessary permissions access policies to list,
         *        connect to, or manage EMR Serverless jobs. For detailed information about the required permissions of
         *        this role, see "How to configure AutoML to initiate a remote job on EMR Serverless for large datasets"
         *        in <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html"
         *        >Create a regression or classification job for tabular data using the AutoML API</a> or <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-timeseries-forecasting.html#timeseries-forecasting-api-optional-params"
         *        >Create an AutoML job for time-series forecasting using the API</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleARN(String executionRoleARN);
    }

    static final class BuilderImpl implements Builder {
        private String executionRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(EmrServerlessComputeConfig model) {
            executionRoleARN(model.executionRoleARN);
        }

        public final String getExecutionRoleARN() {
            return executionRoleARN;
        }

        public final void setExecutionRoleARN(String executionRoleARN) {
            this.executionRoleARN = executionRoleARN;
        }

        @Override
        public final Builder executionRoleARN(String executionRoleARN) {
            this.executionRoleARN = executionRoleARN;
            return this;
        }

        @Override
        public EmrServerlessComputeConfig build() {
            return new EmrServerlessComputeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
