/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for the JupyterLab application within a space.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceJupyterLabAppSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SpaceJupyterLabAppSettings.Builder, SpaceJupyterLabAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField
            .<ResourceSpec> builder(MarshallingType.SDK_POJO).memberName("DefaultResourceSpec")
            .getter(getter(SpaceJupyterLabAppSettings::defaultResourceSpec)).setter(setter(Builder::defaultResourceSpec))
            .constructor(ResourceSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build())
            .build();

    private static final SdkField<List<CodeRepository>> CODE_REPOSITORIES_FIELD = SdkField
            .<List<CodeRepository>> builder(MarshallingType.LIST)
            .memberName("CodeRepositories")
            .getter(getter(SpaceJupyterLabAppSettings::codeRepositories))
            .setter(setter(Builder::codeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeRepository> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeRepository::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SpaceAppLifecycleManagement> APP_LIFECYCLE_MANAGEMENT_FIELD = SdkField
            .<SpaceAppLifecycleManagement> builder(MarshallingType.SDK_POJO).memberName("AppLifecycleManagement")
            .getter(getter(SpaceJupyterLabAppSettings::appLifecycleManagement)).setter(setter(Builder::appLifecycleManagement))
            .constructor(SpaceAppLifecycleManagement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLifecycleManagement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD,
            CODE_REPOSITORIES_FIELD, APP_LIFECYCLE_MANAGEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceSpec defaultResourceSpec;

    private final List<CodeRepository> codeRepositories;

    private final SpaceAppLifecycleManagement appLifecycleManagement;

    private SpaceJupyterLabAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.codeRepositories = builder.codeRepositories;
        this.appLifecycleManagement = builder.appLifecycleManagement;
    }

    /**
     * Returns the value of the DefaultResourceSpec property for this object.
     * 
     * @return The value of the DefaultResourceSpec property for this object.
     */
    public final ResourceSpec defaultResourceSpec() {
        return defaultResourceSpec;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeRepositories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCodeRepositories() {
        return codeRepositories != null && !(codeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
     * application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeRepositories} method.
     * </p>
     * 
     * @return A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
     *         application.
     */
    public final List<CodeRepository> codeRepositories() {
        return codeRepositories;
    }

    /**
     * <p>
     * Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
     * </p>
     * 
     * @return Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
     */
    public final SpaceAppLifecycleManagement appLifecycleManagement() {
        return appLifecycleManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeRepositories() ? codeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appLifecycleManagement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceJupyterLabAppSettings)) {
            return false;
        }
        SpaceJupyterLabAppSettings other = (SpaceJupyterLabAppSettings) obj;
        return Objects.equals(defaultResourceSpec(), other.defaultResourceSpec())
                && hasCodeRepositories() == other.hasCodeRepositories()
                && Objects.equals(codeRepositories(), other.codeRepositories())
                && Objects.equals(appLifecycleManagement(), other.appLifecycleManagement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceJupyterLabAppSettings").add("DefaultResourceSpec", defaultResourceSpec())
                .add("CodeRepositories", hasCodeRepositories() ? codeRepositories() : null)
                .add("AppLifecycleManagement", appLifecycleManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultResourceSpec":
            return Optional.ofNullable(clazz.cast(defaultResourceSpec()));
        case "CodeRepositories":
            return Optional.ofNullable(clazz.cast(codeRepositories()));
        case "AppLifecycleManagement":
            return Optional.ofNullable(clazz.cast(appLifecycleManagement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpaceJupyterLabAppSettings, T> g) {
        return obj -> g.apply((SpaceJupyterLabAppSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceJupyterLabAppSettings> {
        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * @param defaultResourceSpec
         *        The new value for the DefaultResourceSpec property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResourceSpec(ResourceSpec defaultResourceSpec);

        /**
         * Sets the value of the DefaultResourceSpec property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceSpec.Builder} avoiding the need
         * to create one manually via {@link ResourceSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultResourceSpec(ResourceSpec)}.
         * 
         * @param defaultResourceSpec
         *        a consumer that will call methods on {@link ResourceSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResourceSpec(ResourceSpec)
         */
        default Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return defaultResourceSpec(ResourceSpec.builder().applyMutation(defaultResourceSpec).build());
        }

        /**
         * <p>
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
         * application.
         * </p>
         * 
         * @param codeRepositories
         *        A list of Git repositories that SageMaker automatically displays to users for cloning in the
         *        JupyterLab application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositories(Collection<CodeRepository> codeRepositories);

        /**
         * <p>
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
         * application.
         * </p>
         * 
         * @param codeRepositories
         *        A list of Git repositories that SageMaker automatically displays to users for cloning in the
         *        JupyterLab application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositories(CodeRepository... codeRepositories);

        /**
         * <p>
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab
         * application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository.Builder#build()} is called immediately
         * and its result is passed to {@link #codeRepositories(List<CodeRepository>)}.
         * 
         * @param codeRepositories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.CodeRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeRepositories(java.util.Collection<CodeRepository>)
         */
        Builder codeRepositories(Consumer<CodeRepository.Builder>... codeRepositories);

        /**
         * <p>
         * Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
         * </p>
         * 
         * @param appLifecycleManagement
         *        Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appLifecycleManagement(SpaceAppLifecycleManagement appLifecycleManagement);

        /**
         * <p>
         * Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceAppLifecycleManagement.Builder}
         * avoiding the need to create one manually via {@link SpaceAppLifecycleManagement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceAppLifecycleManagement.Builder#build()} is called
         * immediately and its result is passed to {@link #appLifecycleManagement(SpaceAppLifecycleManagement)}.
         * 
         * @param appLifecycleManagement
         *        a consumer that will call methods on {@link SpaceAppLifecycleManagement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appLifecycleManagement(SpaceAppLifecycleManagement)
         */
        default Builder appLifecycleManagement(Consumer<SpaceAppLifecycleManagement.Builder> appLifecycleManagement) {
            return appLifecycleManagement(SpaceAppLifecycleManagement.builder().applyMutation(appLifecycleManagement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceSpec defaultResourceSpec;

        private List<CodeRepository> codeRepositories = DefaultSdkAutoConstructList.getInstance();

        private SpaceAppLifecycleManagement appLifecycleManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceJupyterLabAppSettings model) {
            defaultResourceSpec(model.defaultResourceSpec);
            codeRepositories(model.codeRepositories);
            appLifecycleManagement(model.appLifecycleManagement);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return defaultResourceSpec != null ? defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final List<CodeRepository.Builder> getCodeRepositories() {
            List<CodeRepository.Builder> result = CodeRepositoriesCopier.copyToBuilder(this.codeRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeRepositories(Collection<CodeRepository.BuilderImpl> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copyFromBuilder(codeRepositories);
        }

        @Override
        public final Builder codeRepositories(Collection<CodeRepository> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copy(codeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(CodeRepository... codeRepositories) {
            codeRepositories(Arrays.asList(codeRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(Consumer<CodeRepository.Builder>... codeRepositories) {
            codeRepositories(Stream.of(codeRepositories).map(c -> CodeRepository.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SpaceAppLifecycleManagement.Builder getAppLifecycleManagement() {
            return appLifecycleManagement != null ? appLifecycleManagement.toBuilder() : null;
        }

        public final void setAppLifecycleManagement(SpaceAppLifecycleManagement.BuilderImpl appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement != null ? appLifecycleManagement.build() : null;
        }

        @Override
        public final Builder appLifecycleManagement(SpaceAppLifecycleManagement appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement;
            return this;
        }

        @Override
        public SpaceJupyterLabAppSettings build() {
            return new SpaceJupyterLabAppSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
