/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SageMaker Canvas application settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanvasAppSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CanvasAppSettings.Builder, CanvasAppSettings> {
    private static final SdkField<TimeSeriesForecastingSettings> TIME_SERIES_FORECASTING_SETTINGS_FIELD = SdkField
            .<TimeSeriesForecastingSettings> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSeriesForecastingSettings")
            .getter(getter(CanvasAppSettings::timeSeriesForecastingSettings))
            .setter(setter(Builder::timeSeriesForecastingSettings))
            .constructor(TimeSeriesForecastingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesForecastingSettings")
                    .build()).build();

    private static final SdkField<ModelRegisterSettings> MODEL_REGISTER_SETTINGS_FIELD = SdkField
            .<ModelRegisterSettings> builder(MarshallingType.SDK_POJO).memberName("ModelRegisterSettings")
            .getter(getter(CanvasAppSettings::modelRegisterSettings)).setter(setter(Builder::modelRegisterSettings))
            .constructor(ModelRegisterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelRegisterSettings").build())
            .build();

    private static final SdkField<WorkspaceSettings> WORKSPACE_SETTINGS_FIELD = SdkField
            .<WorkspaceSettings> builder(MarshallingType.SDK_POJO).memberName("WorkspaceSettings")
            .getter(getter(CanvasAppSettings::workspaceSettings)).setter(setter(Builder::workspaceSettings))
            .constructor(WorkspaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSettings").build()).build();

    private static final SdkField<List<IdentityProviderOAuthSetting>> IDENTITY_PROVIDER_O_AUTH_SETTINGS_FIELD = SdkField
            .<List<IdentityProviderOAuthSetting>> builder(MarshallingType.LIST)
            .memberName("IdentityProviderOAuthSettings")
            .getter(getter(CanvasAppSettings::identityProviderOAuthSettings))
            .setter(setter(Builder::identityProviderOAuthSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderOAuthSettings")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityProviderOAuthSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityProviderOAuthSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DirectDeploySettings> DIRECT_DEPLOY_SETTINGS_FIELD = SdkField
            .<DirectDeploySettings> builder(MarshallingType.SDK_POJO).memberName("DirectDeploySettings")
            .getter(getter(CanvasAppSettings::directDeploySettings)).setter(setter(Builder::directDeploySettings))
            .constructor(DirectDeploySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectDeploySettings").build())
            .build();

    private static final SdkField<KendraSettings> KENDRA_SETTINGS_FIELD = SdkField
            .<KendraSettings> builder(MarshallingType.SDK_POJO).memberName("KendraSettings")
            .getter(getter(CanvasAppSettings::kendraSettings)).setter(setter(Builder::kendraSettings))
            .constructor(KendraSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KendraSettings").build()).build();

    private static final SdkField<GenerativeAiSettings> GENERATIVE_AI_SETTINGS_FIELD = SdkField
            .<GenerativeAiSettings> builder(MarshallingType.SDK_POJO).memberName("GenerativeAiSettings")
            .getter(getter(CanvasAppSettings::generativeAiSettings)).setter(setter(Builder::generativeAiSettings))
            .constructor(GenerativeAiSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerativeAiSettings").build())
            .build();

    private static final SdkField<EmrServerlessSettings> EMR_SERVERLESS_SETTINGS_FIELD = SdkField
            .<EmrServerlessSettings> builder(MarshallingType.SDK_POJO).memberName("EmrServerlessSettings")
            .getter(getter(CanvasAppSettings::emrServerlessSettings)).setter(setter(Builder::emrServerlessSettings))
            .constructor(EmrServerlessSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrServerlessSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIME_SERIES_FORECASTING_SETTINGS_FIELD, MODEL_REGISTER_SETTINGS_FIELD, WORKSPACE_SETTINGS_FIELD,
            IDENTITY_PROVIDER_O_AUTH_SETTINGS_FIELD, DIRECT_DEPLOY_SETTINGS_FIELD, KENDRA_SETTINGS_FIELD,
            GENERATIVE_AI_SETTINGS_FIELD, EMR_SERVERLESS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TimeSeriesForecastingSettings timeSeriesForecastingSettings;

    private final ModelRegisterSettings modelRegisterSettings;

    private final WorkspaceSettings workspaceSettings;

    private final List<IdentityProviderOAuthSetting> identityProviderOAuthSettings;

    private final DirectDeploySettings directDeploySettings;

    private final KendraSettings kendraSettings;

    private final GenerativeAiSettings generativeAiSettings;

    private final EmrServerlessSettings emrServerlessSettings;

    private CanvasAppSettings(BuilderImpl builder) {
        this.timeSeriesForecastingSettings = builder.timeSeriesForecastingSettings;
        this.modelRegisterSettings = builder.modelRegisterSettings;
        this.workspaceSettings = builder.workspaceSettings;
        this.identityProviderOAuthSettings = builder.identityProviderOAuthSettings;
        this.directDeploySettings = builder.directDeploySettings;
        this.kendraSettings = builder.kendraSettings;
        this.generativeAiSettings = builder.generativeAiSettings;
        this.emrServerlessSettings = builder.emrServerlessSettings;
    }

    /**
     * <p>
     * Time series forecast settings for the SageMaker Canvas application.
     * </p>
     * 
     * @return Time series forecast settings for the SageMaker Canvas application.
     */
    public final TimeSeriesForecastingSettings timeSeriesForecastingSettings() {
        return timeSeriesForecastingSettings;
    }

    /**
     * <p>
     * The model registry settings for the SageMaker Canvas application.
     * </p>
     * 
     * @return The model registry settings for the SageMaker Canvas application.
     */
    public final ModelRegisterSettings modelRegisterSettings() {
        return modelRegisterSettings;
    }

    /**
     * <p>
     * The workspace settings for the SageMaker Canvas application.
     * </p>
     * 
     * @return The workspace settings for the SageMaker Canvas application.
     */
    public final WorkspaceSettings workspaceSettings() {
        return workspaceSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityProviderOAuthSettings property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityProviderOAuthSettings() {
        return identityProviderOAuthSettings != null && !(identityProviderOAuthSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings for connecting to an external data source with OAuth.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityProviderOAuthSettings} method.
     * </p>
     * 
     * @return The settings for connecting to an external data source with OAuth.
     */
    public final List<IdentityProviderOAuthSetting> identityProviderOAuthSettings() {
        return identityProviderOAuthSettings;
    }

    /**
     * <p>
     * The model deployment settings for the SageMaker Canvas application.
     * </p>
     * 
     * @return The model deployment settings for the SageMaker Canvas application.
     */
    public final DirectDeploySettings directDeploySettings() {
        return directDeploySettings;
    }

    /**
     * <p>
     * The settings for document querying.
     * </p>
     * 
     * @return The settings for document querying.
     */
    public final KendraSettings kendraSettings() {
        return kendraSettings;
    }

    /**
     * <p>
     * The generative AI settings for the SageMaker Canvas application.
     * </p>
     * 
     * @return The generative AI settings for the SageMaker Canvas application.
     */
    public final GenerativeAiSettings generativeAiSettings() {
        return generativeAiSettings;
    }

    /**
     * <p>
     * The settings for running Amazon EMR Serverless data processing jobs in SageMaker Canvas.
     * </p>
     * 
     * @return The settings for running Amazon EMR Serverless data processing jobs in SageMaker Canvas.
     */
    public final EmrServerlessSettings emrServerlessSettings() {
        return emrServerlessSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesForecastingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(modelRegisterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityProviderOAuthSettings() ? identityProviderOAuthSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directDeploySettings());
        hashCode = 31 * hashCode + Objects.hashCode(kendraSettings());
        hashCode = 31 * hashCode + Objects.hashCode(generativeAiSettings());
        hashCode = 31 * hashCode + Objects.hashCode(emrServerlessSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanvasAppSettings)) {
            return false;
        }
        CanvasAppSettings other = (CanvasAppSettings) obj;
        return Objects.equals(timeSeriesForecastingSettings(), other.timeSeriesForecastingSettings())
                && Objects.equals(modelRegisterSettings(), other.modelRegisterSettings())
                && Objects.equals(workspaceSettings(), other.workspaceSettings())
                && hasIdentityProviderOAuthSettings() == other.hasIdentityProviderOAuthSettings()
                && Objects.equals(identityProviderOAuthSettings(), other.identityProviderOAuthSettings())
                && Objects.equals(directDeploySettings(), other.directDeploySettings())
                && Objects.equals(kendraSettings(), other.kendraSettings())
                && Objects.equals(generativeAiSettings(), other.generativeAiSettings())
                && Objects.equals(emrServerlessSettings(), other.emrServerlessSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CanvasAppSettings")
                .add("TimeSeriesForecastingSettings", timeSeriesForecastingSettings())
                .add("ModelRegisterSettings", modelRegisterSettings())
                .add("WorkspaceSettings", workspaceSettings())
                .add("IdentityProviderOAuthSettings", hasIdentityProviderOAuthSettings() ? identityProviderOAuthSettings() : null)
                .add("DirectDeploySettings", directDeploySettings()).add("KendraSettings", kendraSettings())
                .add("GenerativeAiSettings", generativeAiSettings()).add("EmrServerlessSettings", emrServerlessSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeSeriesForecastingSettings":
            return Optional.ofNullable(clazz.cast(timeSeriesForecastingSettings()));
        case "ModelRegisterSettings":
            return Optional.ofNullable(clazz.cast(modelRegisterSettings()));
        case "WorkspaceSettings":
            return Optional.ofNullable(clazz.cast(workspaceSettings()));
        case "IdentityProviderOAuthSettings":
            return Optional.ofNullable(clazz.cast(identityProviderOAuthSettings()));
        case "DirectDeploySettings":
            return Optional.ofNullable(clazz.cast(directDeploySettings()));
        case "KendraSettings":
            return Optional.ofNullable(clazz.cast(kendraSettings()));
        case "GenerativeAiSettings":
            return Optional.ofNullable(clazz.cast(generativeAiSettings()));
        case "EmrServerlessSettings":
            return Optional.ofNullable(clazz.cast(emrServerlessSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanvasAppSettings, T> g) {
        return obj -> g.apply((CanvasAppSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanvasAppSettings> {
        /**
         * <p>
         * Time series forecast settings for the SageMaker Canvas application.
         * </p>
         * 
         * @param timeSeriesForecastingSettings
         *        Time series forecast settings for the SageMaker Canvas application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings timeSeriesForecastingSettings);

        /**
         * <p>
         * Time series forecast settings for the SageMaker Canvas application.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSeriesForecastingSettings.Builder}
         * avoiding the need to create one manually via {@link TimeSeriesForecastingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesForecastingSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #timeSeriesForecastingSettings(TimeSeriesForecastingSettings)}.
         * 
         * @param timeSeriesForecastingSettings
         *        a consumer that will call methods on {@link TimeSeriesForecastingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesForecastingSettings(TimeSeriesForecastingSettings)
         */
        default Builder timeSeriesForecastingSettings(
                Consumer<TimeSeriesForecastingSettings.Builder> timeSeriesForecastingSettings) {
            return timeSeriesForecastingSettings(TimeSeriesForecastingSettings.builder()
                    .applyMutation(timeSeriesForecastingSettings).build());
        }

        /**
         * <p>
         * The model registry settings for the SageMaker Canvas application.
         * </p>
         * 
         * @param modelRegisterSettings
         *        The model registry settings for the SageMaker Canvas application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelRegisterSettings(ModelRegisterSettings modelRegisterSettings);

        /**
         * <p>
         * The model registry settings for the SageMaker Canvas application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelRegisterSettings.Builder} avoiding
         * the need to create one manually via {@link ModelRegisterSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelRegisterSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #modelRegisterSettings(ModelRegisterSettings)}.
         * 
         * @param modelRegisterSettings
         *        a consumer that will call methods on {@link ModelRegisterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelRegisterSettings(ModelRegisterSettings)
         */
        default Builder modelRegisterSettings(Consumer<ModelRegisterSettings.Builder> modelRegisterSettings) {
            return modelRegisterSettings(ModelRegisterSettings.builder().applyMutation(modelRegisterSettings).build());
        }

        /**
         * <p>
         * The workspace settings for the SageMaker Canvas application.
         * </p>
         * 
         * @param workspaceSettings
         *        The workspace settings for the SageMaker Canvas application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceSettings(WorkspaceSettings workspaceSettings);

        /**
         * <p>
         * The workspace settings for the SageMaker Canvas application.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceSettings.Builder} avoiding the
         * need to create one manually via {@link WorkspaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #workspaceSettings(WorkspaceSettings)}.
         * 
         * @param workspaceSettings
         *        a consumer that will call methods on {@link WorkspaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceSettings(WorkspaceSettings)
         */
        default Builder workspaceSettings(Consumer<WorkspaceSettings.Builder> workspaceSettings) {
            return workspaceSettings(WorkspaceSettings.builder().applyMutation(workspaceSettings).build());
        }

        /**
         * <p>
         * The settings for connecting to an external data source with OAuth.
         * </p>
         * 
         * @param identityProviderOAuthSettings
         *        The settings for connecting to an external data source with OAuth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderOAuthSettings(Collection<IdentityProviderOAuthSetting> identityProviderOAuthSettings);

        /**
         * <p>
         * The settings for connecting to an external data source with OAuth.
         * </p>
         * 
         * @param identityProviderOAuthSettings
         *        The settings for connecting to an external data source with OAuth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderOAuthSettings(IdentityProviderOAuthSetting... identityProviderOAuthSettings);

        /**
         * <p>
         * The settings for connecting to an external data source with OAuth.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #identityProviderOAuthSettings(List<IdentityProviderOAuthSetting>)}.
         * 
         * @param identityProviderOAuthSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderOAuthSettings(java.util.Collection<IdentityProviderOAuthSetting>)
         */
        Builder identityProviderOAuthSettings(Consumer<IdentityProviderOAuthSetting.Builder>... identityProviderOAuthSettings);

        /**
         * <p>
         * The model deployment settings for the SageMaker Canvas application.
         * </p>
         * 
         * @param directDeploySettings
         *        The model deployment settings for the SageMaker Canvas application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directDeploySettings(DirectDeploySettings directDeploySettings);

        /**
         * <p>
         * The model deployment settings for the SageMaker Canvas application.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectDeploySettings.Builder} avoiding
         * the need to create one manually via {@link DirectDeploySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectDeploySettings.Builder#build()} is called immediately and
         * its result is passed to {@link #directDeploySettings(DirectDeploySettings)}.
         * 
         * @param directDeploySettings
         *        a consumer that will call methods on {@link DirectDeploySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directDeploySettings(DirectDeploySettings)
         */
        default Builder directDeploySettings(Consumer<DirectDeploySettings.Builder> directDeploySettings) {
            return directDeploySettings(DirectDeploySettings.builder().applyMutation(directDeploySettings).build());
        }

        /**
         * <p>
         * The settings for document querying.
         * </p>
         * 
         * @param kendraSettings
         *        The settings for document querying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraSettings(KendraSettings kendraSettings);

        /**
         * <p>
         * The settings for document querying.
         * </p>
         * This is a convenience method that creates an instance of the {@link KendraSettings.Builder} avoiding the need
         * to create one manually via {@link KendraSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KendraSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #kendraSettings(KendraSettings)}.
         * 
         * @param kendraSettings
         *        a consumer that will call methods on {@link KendraSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraSettings(KendraSettings)
         */
        default Builder kendraSettings(Consumer<KendraSettings.Builder> kendraSettings) {
            return kendraSettings(KendraSettings.builder().applyMutation(kendraSettings).build());
        }

        /**
         * <p>
         * The generative AI settings for the SageMaker Canvas application.
         * </p>
         * 
         * @param generativeAiSettings
         *        The generative AI settings for the SageMaker Canvas application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeAiSettings(GenerativeAiSettings generativeAiSettings);

        /**
         * <p>
         * The generative AI settings for the SageMaker Canvas application.
         * </p>
         * This is a convenience method that creates an instance of the {@link GenerativeAiSettings.Builder} avoiding
         * the need to create one manually via {@link GenerativeAiSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeAiSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #generativeAiSettings(GenerativeAiSettings)}.
         * 
         * @param generativeAiSettings
         *        a consumer that will call methods on {@link GenerativeAiSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeAiSettings(GenerativeAiSettings)
         */
        default Builder generativeAiSettings(Consumer<GenerativeAiSettings.Builder> generativeAiSettings) {
            return generativeAiSettings(GenerativeAiSettings.builder().applyMutation(generativeAiSettings).build());
        }

        /**
         * <p>
         * The settings for running Amazon EMR Serverless data processing jobs in SageMaker Canvas.
         * </p>
         * 
         * @param emrServerlessSettings
         *        The settings for running Amazon EMR Serverless data processing jobs in SageMaker Canvas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emrServerlessSettings(EmrServerlessSettings emrServerlessSettings);

        /**
         * <p>
         * The settings for running Amazon EMR Serverless data processing jobs in SageMaker Canvas.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmrServerlessSettings.Builder} avoiding
         * the need to create one manually via {@link EmrServerlessSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmrServerlessSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #emrServerlessSettings(EmrServerlessSettings)}.
         * 
         * @param emrServerlessSettings
         *        a consumer that will call methods on {@link EmrServerlessSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emrServerlessSettings(EmrServerlessSettings)
         */
        default Builder emrServerlessSettings(Consumer<EmrServerlessSettings.Builder> emrServerlessSettings) {
            return emrServerlessSettings(EmrServerlessSettings.builder().applyMutation(emrServerlessSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeSeriesForecastingSettings timeSeriesForecastingSettings;

        private ModelRegisterSettings modelRegisterSettings;

        private WorkspaceSettings workspaceSettings;

        private List<IdentityProviderOAuthSetting> identityProviderOAuthSettings = DefaultSdkAutoConstructList.getInstance();

        private DirectDeploySettings directDeploySettings;

        private KendraSettings kendraSettings;

        private GenerativeAiSettings generativeAiSettings;

        private EmrServerlessSettings emrServerlessSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CanvasAppSettings model) {
            timeSeriesForecastingSettings(model.timeSeriesForecastingSettings);
            modelRegisterSettings(model.modelRegisterSettings);
            workspaceSettings(model.workspaceSettings);
            identityProviderOAuthSettings(model.identityProviderOAuthSettings);
            directDeploySettings(model.directDeploySettings);
            kendraSettings(model.kendraSettings);
            generativeAiSettings(model.generativeAiSettings);
            emrServerlessSettings(model.emrServerlessSettings);
        }

        public final TimeSeriesForecastingSettings.Builder getTimeSeriesForecastingSettings() {
            return timeSeriesForecastingSettings != null ? timeSeriesForecastingSettings.toBuilder() : null;
        }

        public final void setTimeSeriesForecastingSettings(TimeSeriesForecastingSettings.BuilderImpl timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings != null ? timeSeriesForecastingSettings.build()
                    : null;
        }

        @Override
        public final Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings;
            return this;
        }

        public final ModelRegisterSettings.Builder getModelRegisterSettings() {
            return modelRegisterSettings != null ? modelRegisterSettings.toBuilder() : null;
        }

        public final void setModelRegisterSettings(ModelRegisterSettings.BuilderImpl modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings != null ? modelRegisterSettings.build() : null;
        }

        @Override
        public final Builder modelRegisterSettings(ModelRegisterSettings modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings;
            return this;
        }

        public final WorkspaceSettings.Builder getWorkspaceSettings() {
            return workspaceSettings != null ? workspaceSettings.toBuilder() : null;
        }

        public final void setWorkspaceSettings(WorkspaceSettings.BuilderImpl workspaceSettings) {
            this.workspaceSettings = workspaceSettings != null ? workspaceSettings.build() : null;
        }

        @Override
        public final Builder workspaceSettings(WorkspaceSettings workspaceSettings) {
            this.workspaceSettings = workspaceSettings;
            return this;
        }

        public final List<IdentityProviderOAuthSetting.Builder> getIdentityProviderOAuthSettings() {
            List<IdentityProviderOAuthSetting.Builder> result = IdentityProviderOAuthSettingsCopier
                    .copyToBuilder(this.identityProviderOAuthSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityProviderOAuthSettings(
                Collection<IdentityProviderOAuthSetting.BuilderImpl> identityProviderOAuthSettings) {
            this.identityProviderOAuthSettings = IdentityProviderOAuthSettingsCopier
                    .copyFromBuilder(identityProviderOAuthSettings);
        }

        @Override
        public final Builder identityProviderOAuthSettings(Collection<IdentityProviderOAuthSetting> identityProviderOAuthSettings) {
            this.identityProviderOAuthSettings = IdentityProviderOAuthSettingsCopier.copy(identityProviderOAuthSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderOAuthSettings(IdentityProviderOAuthSetting... identityProviderOAuthSettings) {
            identityProviderOAuthSettings(Arrays.asList(identityProviderOAuthSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderOAuthSettings(
                Consumer<IdentityProviderOAuthSetting.Builder>... identityProviderOAuthSettings) {
            identityProviderOAuthSettings(Stream.of(identityProviderOAuthSettings)
                    .map(c -> IdentityProviderOAuthSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DirectDeploySettings.Builder getDirectDeploySettings() {
            return directDeploySettings != null ? directDeploySettings.toBuilder() : null;
        }

        public final void setDirectDeploySettings(DirectDeploySettings.BuilderImpl directDeploySettings) {
            this.directDeploySettings = directDeploySettings != null ? directDeploySettings.build() : null;
        }

        @Override
        public final Builder directDeploySettings(DirectDeploySettings directDeploySettings) {
            this.directDeploySettings = directDeploySettings;
            return this;
        }

        public final KendraSettings.Builder getKendraSettings() {
            return kendraSettings != null ? kendraSettings.toBuilder() : null;
        }

        public final void setKendraSettings(KendraSettings.BuilderImpl kendraSettings) {
            this.kendraSettings = kendraSettings != null ? kendraSettings.build() : null;
        }

        @Override
        public final Builder kendraSettings(KendraSettings kendraSettings) {
            this.kendraSettings = kendraSettings;
            return this;
        }

        public final GenerativeAiSettings.Builder getGenerativeAiSettings() {
            return generativeAiSettings != null ? generativeAiSettings.toBuilder() : null;
        }

        public final void setGenerativeAiSettings(GenerativeAiSettings.BuilderImpl generativeAiSettings) {
            this.generativeAiSettings = generativeAiSettings != null ? generativeAiSettings.build() : null;
        }

        @Override
        public final Builder generativeAiSettings(GenerativeAiSettings generativeAiSettings) {
            this.generativeAiSettings = generativeAiSettings;
            return this;
        }

        public final EmrServerlessSettings.Builder getEmrServerlessSettings() {
            return emrServerlessSettings != null ? emrServerlessSettings.toBuilder() : null;
        }

        public final void setEmrServerlessSettings(EmrServerlessSettings.BuilderImpl emrServerlessSettings) {
            this.emrServerlessSettings = emrServerlessSettings != null ? emrServerlessSettings.build() : null;
        }

        @Override
        public final Builder emrServerlessSettings(EmrServerlessSettings emrServerlessSettings) {
            this.emrServerlessSettings = emrServerlessSettings;
            return this;
        }

        @Override
        public CanvasAppSettings build() {
            return new CanvasAppSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
