/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for an optimization technique that you apply with a model optimization job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OptimizationConfig.Builder, OptimizationConfig> {
    private static final SdkField<ModelQuantizationConfig> MODEL_QUANTIZATION_CONFIG_FIELD = SdkField
            .<ModelQuantizationConfig> builder(MarshallingType.SDK_POJO).memberName("ModelQuantizationConfig")
            .getter(getter(OptimizationConfig::modelQuantizationConfig)).setter(setter(Builder::modelQuantizationConfig))
            .constructor(ModelQuantizationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuantizationConfig").build())
            .build();

    private static final SdkField<ModelCompilationConfig> MODEL_COMPILATION_CONFIG_FIELD = SdkField
            .<ModelCompilationConfig> builder(MarshallingType.SDK_POJO).memberName("ModelCompilationConfig")
            .getter(getter(OptimizationConfig::modelCompilationConfig)).setter(setter(Builder::modelCompilationConfig))
            .constructor(ModelCompilationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCompilationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_QUANTIZATION_CONFIG_FIELD, MODEL_COMPILATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final ModelQuantizationConfig modelQuantizationConfig;

    private final ModelCompilationConfig modelCompilationConfig;

    private final Type type;

    private OptimizationConfig(BuilderImpl builder) {
        this.modelQuantizationConfig = builder.modelQuantizationConfig;
        this.modelCompilationConfig = builder.modelCompilationConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Settings for the model quantization technique that's applied by a model optimization job.
     * </p>
     * 
     * @return Settings for the model quantization technique that's applied by a model optimization job.
     */
    public final ModelQuantizationConfig modelQuantizationConfig() {
        return modelQuantizationConfig;
    }

    /**
     * <p>
     * Settings for the model compilation technique that's applied by a model optimization job.
     * </p>
     * 
     * @return Settings for the model compilation technique that's applied by a model optimization job.
     */
    public final ModelCompilationConfig modelCompilationConfig() {
        return modelCompilationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelQuantizationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelCompilationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationConfig)) {
            return false;
        }
        OptimizationConfig other = (OptimizationConfig) obj;
        return Objects.equals(modelQuantizationConfig(), other.modelQuantizationConfig())
                && Objects.equals(modelCompilationConfig(), other.modelCompilationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizationConfig").add("ModelQuantizationConfig", modelQuantizationConfig())
                .add("ModelCompilationConfig", modelCompilationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelQuantizationConfig":
            return Optional.ofNullable(clazz.cast(modelQuantizationConfig()));
        case "ModelCompilationConfig":
            return Optional.ofNullable(clazz.cast(modelCompilationConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #modelQuantizationConfig()} initialized to the given value.
     *
     * <p>
     * Settings for the model quantization technique that's applied by a model optimization job.
     * </p>
     * 
     * @param modelQuantizationConfig
     *        Settings for the model quantization technique that's applied by a model optimization job.
     */
    public static OptimizationConfig fromModelQuantizationConfig(ModelQuantizationConfig modelQuantizationConfig) {
        return builder().modelQuantizationConfig(modelQuantizationConfig).build();
    }

    /**
     * Create an instance of this class with {@link #modelQuantizationConfig()} initialized to the given value.
     *
     * <p>
     * Settings for the model quantization technique that's applied by a model optimization job.
     * </p>
     * 
     * @param modelQuantizationConfig
     *        Settings for the model quantization technique that's applied by a model optimization job.
     */
    public static OptimizationConfig fromModelQuantizationConfig(Consumer<ModelQuantizationConfig.Builder> modelQuantizationConfig) {
        ModelQuantizationConfig.Builder builder = ModelQuantizationConfig.builder();
        modelQuantizationConfig.accept(builder);
        return fromModelQuantizationConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #modelCompilationConfig()} initialized to the given value.
     *
     * <p>
     * Settings for the model compilation technique that's applied by a model optimization job.
     * </p>
     * 
     * @param modelCompilationConfig
     *        Settings for the model compilation technique that's applied by a model optimization job.
     */
    public static OptimizationConfig fromModelCompilationConfig(ModelCompilationConfig modelCompilationConfig) {
        return builder().modelCompilationConfig(modelCompilationConfig).build();
    }

    /**
     * Create an instance of this class with {@link #modelCompilationConfig()} initialized to the given value.
     *
     * <p>
     * Settings for the model compilation technique that's applied by a model optimization job.
     * </p>
     * 
     * @param modelCompilationConfig
     *        Settings for the model compilation technique that's applied by a model optimization job.
     */
    public static OptimizationConfig fromModelCompilationConfig(Consumer<ModelCompilationConfig.Builder> modelCompilationConfig) {
        ModelCompilationConfig.Builder builder = ModelCompilationConfig.builder();
        modelCompilationConfig.accept(builder);
        return fromModelCompilationConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptimizationConfig, T> g) {
        return obj -> g.apply((OptimizationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizationConfig> {
        /**
         * <p>
         * Settings for the model quantization technique that's applied by a model optimization job.
         * </p>
         * 
         * @param modelQuantizationConfig
         *        Settings for the model quantization technique that's applied by a model optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQuantizationConfig(ModelQuantizationConfig modelQuantizationConfig);

        /**
         * <p>
         * Settings for the model quantization technique that's applied by a model optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelQuantizationConfig.Builder} avoiding
         * the need to create one manually via {@link ModelQuantizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelQuantizationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #modelQuantizationConfig(ModelQuantizationConfig)}.
         * 
         * @param modelQuantizationConfig
         *        a consumer that will call methods on {@link ModelQuantizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQuantizationConfig(ModelQuantizationConfig)
         */
        default Builder modelQuantizationConfig(Consumer<ModelQuantizationConfig.Builder> modelQuantizationConfig) {
            return modelQuantizationConfig(ModelQuantizationConfig.builder().applyMutation(modelQuantizationConfig).build());
        }

        /**
         * <p>
         * Settings for the model compilation technique that's applied by a model optimization job.
         * </p>
         * 
         * @param modelCompilationConfig
         *        Settings for the model compilation technique that's applied by a model optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCompilationConfig(ModelCompilationConfig modelCompilationConfig);

        /**
         * <p>
         * Settings for the model compilation technique that's applied by a model optimization job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelCompilationConfig.Builder} avoiding
         * the need to create one manually via {@link ModelCompilationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelCompilationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #modelCompilationConfig(ModelCompilationConfig)}.
         * 
         * @param modelCompilationConfig
         *        a consumer that will call methods on {@link ModelCompilationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelCompilationConfig(ModelCompilationConfig)
         */
        default Builder modelCompilationConfig(Consumer<ModelCompilationConfig.Builder> modelCompilationConfig) {
            return modelCompilationConfig(ModelCompilationConfig.builder().applyMutation(modelCompilationConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModelQuantizationConfig modelQuantizationConfig;

        private ModelCompilationConfig modelCompilationConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationConfig model) {
            modelQuantizationConfig(model.modelQuantizationConfig);
            modelCompilationConfig(model.modelCompilationConfig);
        }

        public final ModelQuantizationConfig.Builder getModelQuantizationConfig() {
            return modelQuantizationConfig != null ? modelQuantizationConfig.toBuilder() : null;
        }

        public final void setModelQuantizationConfig(ModelQuantizationConfig.BuilderImpl modelQuantizationConfig) {
            Object oldValue = this.modelQuantizationConfig;
            this.modelQuantizationConfig = modelQuantizationConfig != null ? modelQuantizationConfig.build() : null;
            handleUnionValueChange(Type.MODEL_QUANTIZATION_CONFIG, oldValue, this.modelQuantizationConfig);
        }

        @Override
        public final Builder modelQuantizationConfig(ModelQuantizationConfig modelQuantizationConfig) {
            Object oldValue = this.modelQuantizationConfig;
            this.modelQuantizationConfig = modelQuantizationConfig;
            handleUnionValueChange(Type.MODEL_QUANTIZATION_CONFIG, oldValue, this.modelQuantizationConfig);
            return this;
        }

        public final ModelCompilationConfig.Builder getModelCompilationConfig() {
            return modelCompilationConfig != null ? modelCompilationConfig.toBuilder() : null;
        }

        public final void setModelCompilationConfig(ModelCompilationConfig.BuilderImpl modelCompilationConfig) {
            Object oldValue = this.modelCompilationConfig;
            this.modelCompilationConfig = modelCompilationConfig != null ? modelCompilationConfig.build() : null;
            handleUnionValueChange(Type.MODEL_COMPILATION_CONFIG, oldValue, this.modelCompilationConfig);
        }

        @Override
        public final Builder modelCompilationConfig(ModelCompilationConfig modelCompilationConfig) {
            Object oldValue = this.modelCompilationConfig;
            this.modelCompilationConfig = modelCompilationConfig;
            handleUnionValueChange(Type.MODEL_COMPILATION_CONFIG, oldValue, this.modelCompilationConfig);
            return this;
        }

        @Override
        public OptimizationConfig build() {
            return new OptimizationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OptimizationConfig#type()
     */
    public enum Type {
        MODEL_QUANTIZATION_CONFIG,

        MODEL_COMPILATION_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
