/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 location of a source model to optimize with an optimization job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizationJobModelSourceS3 implements SdkPojo, Serializable,
        ToCopyableBuilder<OptimizationJobModelSourceS3.Builder, OptimizationJobModelSourceS3> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(OptimizationJobModelSourceS3::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<OptimizationModelAccessConfig> MODEL_ACCESS_CONFIG_FIELD = SdkField
            .<OptimizationModelAccessConfig> builder(MarshallingType.SDK_POJO).memberName("ModelAccessConfig")
            .getter(getter(OptimizationJobModelSourceS3::modelAccessConfig)).setter(setter(Builder::modelAccessConfig))
            .constructor(OptimizationModelAccessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelAccessConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            MODEL_ACCESS_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final OptimizationModelAccessConfig modelAccessConfig;

    private OptimizationJobModelSourceS3(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.modelAccessConfig = builder.modelAccessConfig;
    }

    /**
     * <p>
     * An Amazon S3 URI that locates a source model to optimize with an optimization job.
     * </p>
     * 
     * @return An Amazon S3 URI that locates a source model to optimize with an optimization job.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The access configuration settings for the source ML model for an optimization job, where you can accept the model
     * end-user license agreement (EULA).
     * </p>
     * 
     * @return The access configuration settings for the source ML model for an optimization job, where you can accept
     *         the model end-user license agreement (EULA).
     */
    public final OptimizationModelAccessConfig modelAccessConfig() {
        return modelAccessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(modelAccessConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobModelSourceS3)) {
            return false;
        }
        OptimizationJobModelSourceS3 other = (OptimizationJobModelSourceS3) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(modelAccessConfig(), other.modelAccessConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizationJobModelSourceS3").add("S3Uri", s3Uri())
                .add("ModelAccessConfig", modelAccessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "ModelAccessConfig":
            return Optional.ofNullable(clazz.cast(modelAccessConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobModelSourceS3, T> g) {
        return obj -> g.apply((OptimizationJobModelSourceS3) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizationJobModelSourceS3> {
        /**
         * <p>
         * An Amazon S3 URI that locates a source model to optimize with an optimization job.
         * </p>
         * 
         * @param s3Uri
         *        An Amazon S3 URI that locates a source model to optimize with an optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The access configuration settings for the source ML model for an optimization job, where you can accept the
         * model end-user license agreement (EULA).
         * </p>
         * 
         * @param modelAccessConfig
         *        The access configuration settings for the source ML model for an optimization job, where you can
         *        accept the model end-user license agreement (EULA).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelAccessConfig(OptimizationModelAccessConfig modelAccessConfig);

        /**
         * <p>
         * The access configuration settings for the source ML model for an optimization job, where you can accept the
         * model end-user license agreement (EULA).
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizationModelAccessConfig.Builder}
         * avoiding the need to create one manually via {@link OptimizationModelAccessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizationModelAccessConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #modelAccessConfig(OptimizationModelAccessConfig)}.
         * 
         * @param modelAccessConfig
         *        a consumer that will call methods on {@link OptimizationModelAccessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelAccessConfig(OptimizationModelAccessConfig)
         */
        default Builder modelAccessConfig(Consumer<OptimizationModelAccessConfig.Builder> modelAccessConfig) {
            return modelAccessConfig(OptimizationModelAccessConfig.builder().applyMutation(modelAccessConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private OptimizationModelAccessConfig modelAccessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobModelSourceS3 model) {
            s3Uri(model.s3Uri);
            modelAccessConfig(model.modelAccessConfig);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final OptimizationModelAccessConfig.Builder getModelAccessConfig() {
            return modelAccessConfig != null ? modelAccessConfig.toBuilder() : null;
        }

        public final void setModelAccessConfig(OptimizationModelAccessConfig.BuilderImpl modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig != null ? modelAccessConfig.build() : null;
        }

        @Override
        public final Builder modelAccessConfig(OptimizationModelAccessConfig modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig;
            return this;
        }

        @Override
        public OptimizationJobModelSourceS3 build() {
            return new OptimizationJobModelSourceS3(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
