/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopOptimizationJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<StopOptimizationJobRequest.Builder, StopOptimizationJobRequest> {
    private static final SdkField<String> OPTIMIZATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobName").getter(getter(StopOptimizationJobRequest::optimizationJobName))
            .setter(setter(Builder::optimizationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_NAME_FIELD));

    private final String optimizationJobName;

    private StopOptimizationJobRequest(BuilderImpl builder) {
        super(builder);
        this.optimizationJobName = builder.optimizationJobName;
    }

    /**
     * <p>
     * The name that you assigned to the optimization job.
     * </p>
     * 
     * @return The name that you assigned to the optimization job.
     */
    public final String optimizationJobName() {
        return optimizationJobName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopOptimizationJobRequest)) {
            return false;
        }
        StopOptimizationJobRequest other = (StopOptimizationJobRequest) obj;
        return Objects.equals(optimizationJobName(), other.optimizationJobName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopOptimizationJobRequest").add("OptimizationJobName", optimizationJobName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptimizationJobName":
            return Optional.ofNullable(clazz.cast(optimizationJobName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopOptimizationJobRequest, T> g) {
        return obj -> g.apply((StopOptimizationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopOptimizationJobRequest> {
        /**
         * <p>
         * The name that you assigned to the optimization job.
         * </p>
         * 
         * @param optimizationJobName
         *        The name that you assigned to the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobName(String optimizationJobName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String optimizationJobName;

        private BuilderImpl() {
        }

        private BuilderImpl(StopOptimizationJobRequest model) {
            super(model);
            optimizationJobName(model.optimizationJobName);
        }

        public final String getOptimizationJobName() {
            return optimizationJobName;
        }

        public final void setOptimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
        }

        @Override
        public final Builder optimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopOptimizationJobRequest build() {
            return new StopOptimizationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
