/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration parameters that specify the IAM roles assumed by the execution role of SageMaker (assumable roles)
 * and the cluster instances or job execution environments (execution roles or runtime roles) to manage and access
 * resources required for running Amazon EMR clusters or Amazon EMR Serverless applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmrSettings implements SdkPojo, Serializable, ToCopyableBuilder<EmrSettings.Builder, EmrSettings> {
    private static final SdkField<List<String>> ASSUMABLE_ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssumableRoleArns")
            .getter(getter(EmrSettings::assumableRoleArns))
            .setter(setter(Builder::assumableRoleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumableRoleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXECUTION_ROLE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExecutionRoleArns")
            .getter(getter(EmrSettings::executionRoleArns))
            .setter(setter(Builder::executionRoleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSUMABLE_ROLE_ARNS_FIELD,
            EXECUTION_ROLE_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> assumableRoleArns;

    private final List<String> executionRoleArns;

    private EmrSettings(BuilderImpl builder) {
        this.assumableRoleArns = builder.assumableRoleArns;
        this.executionRoleArns = builder.executionRoleArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssumableRoleArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssumableRoleArns() {
        return assumableRoleArns != null && !(assumableRoleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can assume for
     * performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless applications. These roles
     * define the permissions and access policies required when performing Amazon EMR-related operations, such as
     * listing, connecting to, or terminating Amazon EMR clusters or Amazon EMR Serverless applications. They are
     * typically used in cross-account access scenarios, where the Amazon EMR resources (clusters or serverless
     * applications) are located in a different Amazon Web Services account than the SageMaker domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssumableRoleArns} method.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can assume
     *         for performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless applications.
     *         These roles define the permissions and access policies required when performing Amazon EMR-related
     *         operations, such as listing, connecting to, or terminating Amazon EMR clusters or Amazon EMR Serverless
     *         applications. They are typically used in cross-account access scenarios, where the Amazon EMR resources
     *         (clusters or serverless applications) are located in a different Amazon Web Services account than the
     *         SageMaker domain.
     */
    public final List<String> assumableRoleArns() {
        return assumableRoleArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionRoleArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionRoleArns() {
        return executionRoleArns != null && !(executionRoleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or job
     * execution environments to access other Amazon Web Services services and resources needed during the runtime of
     * your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access, Amazon CloudWatch for
     * logging, or other Amazon Web Services services based on the particular workload requirements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionRoleArns} method.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or job
     *         execution environments to access other Amazon Web Services services and resources needed during the
     *         runtime of your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access, Amazon
     *         CloudWatch for logging, or other Amazon Web Services services based on the particular workload
     *         requirements.
     */
    public final List<String> executionRoleArns() {
        return executionRoleArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssumableRoleArns() ? assumableRoleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionRoleArns() ? executionRoleArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmrSettings)) {
            return false;
        }
        EmrSettings other = (EmrSettings) obj;
        return hasAssumableRoleArns() == other.hasAssumableRoleArns()
                && Objects.equals(assumableRoleArns(), other.assumableRoleArns())
                && hasExecutionRoleArns() == other.hasExecutionRoleArns()
                && Objects.equals(executionRoleArns(), other.executionRoleArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmrSettings").add("AssumableRoleArns", hasAssumableRoleArns() ? assumableRoleArns() : null)
                .add("ExecutionRoleArns", hasExecutionRoleArns() ? executionRoleArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssumableRoleArns":
            return Optional.ofNullable(clazz.cast(assumableRoleArns()));
        case "ExecutionRoleArns":
            return Optional.ofNullable(clazz.cast(executionRoleArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmrSettings, T> g) {
        return obj -> g.apply((EmrSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmrSettings> {
        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can assume for
         * performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless applications. These
         * roles define the permissions and access policies required when performing Amazon EMR-related operations, such
         * as listing, connecting to, or terminating Amazon EMR clusters or Amazon EMR Serverless applications. They are
         * typically used in cross-account access scenarios, where the Amazon EMR resources (clusters or serverless
         * applications) are located in a different Amazon Web Services account than the SageMaker domain.
         * </p>
         * 
         * @param assumableRoleArns
         *        An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can
         *        assume for performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless
         *        applications. These roles define the permissions and access policies required when performing Amazon
         *        EMR-related operations, such as listing, connecting to, or terminating Amazon EMR clusters or Amazon
         *        EMR Serverless applications. They are typically used in cross-account access scenarios, where the
         *        Amazon EMR resources (clusters or serverless applications) are located in a different Amazon Web
         *        Services account than the SageMaker domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumableRoleArns(Collection<String> assumableRoleArns);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can assume for
         * performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless applications. These
         * roles define the permissions and access policies required when performing Amazon EMR-related operations, such
         * as listing, connecting to, or terminating Amazon EMR clusters or Amazon EMR Serverless applications. They are
         * typically used in cross-account access scenarios, where the Amazon EMR resources (clusters or serverless
         * applications) are located in a different Amazon Web Services account than the SageMaker domain.
         * </p>
         * 
         * @param assumableRoleArns
         *        An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can
         *        assume for performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless
         *        applications. These roles define the permissions and access policies required when performing Amazon
         *        EMR-related operations, such as listing, connecting to, or terminating Amazon EMR clusters or Amazon
         *        EMR Serverless applications. They are typically used in cross-account access scenarios, where the
         *        Amazon EMR resources (clusters or serverless applications) are located in a different Amazon Web
         *        Services account than the SageMaker domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumableRoleArns(String... assumableRoleArns);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or job
         * execution environments to access other Amazon Web Services services and resources needed during the runtime
         * of your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access, Amazon CloudWatch
         * for logging, or other Amazon Web Services services based on the particular workload requirements.
         * </p>
         * 
         * @param executionRoleArns
         *        An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or
         *        job execution environments to access other Amazon Web Services services and resources needed during
         *        the runtime of your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access,
         *        Amazon CloudWatch for logging, or other Amazon Web Services services based on the particular workload
         *        requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArns(Collection<String> executionRoleArns);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or job
         * execution environments to access other Amazon Web Services services and resources needed during the runtime
         * of your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access, Amazon CloudWatch
         * for logging, or other Amazon Web Services services based on the particular workload requirements.
         * </p>
         * 
         * @param executionRoleArns
         *        An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or
         *        job execution environments to access other Amazon Web Services services and resources needed during
         *        the runtime of your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access,
         *        Amazon CloudWatch for logging, or other Amazon Web Services services based on the particular workload
         *        requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArns(String... executionRoleArns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> assumableRoleArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> executionRoleArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmrSettings model) {
            assumableRoleArns(model.assumableRoleArns);
            executionRoleArns(model.executionRoleArns);
        }

        public final Collection<String> getAssumableRoleArns() {
            if (assumableRoleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return assumableRoleArns;
        }

        public final void setAssumableRoleArns(Collection<String> assumableRoleArns) {
            this.assumableRoleArns = AssumableRoleArnsCopier.copy(assumableRoleArns);
        }

        @Override
        public final Builder assumableRoleArns(Collection<String> assumableRoleArns) {
            this.assumableRoleArns = AssumableRoleArnsCopier.copy(assumableRoleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assumableRoleArns(String... assumableRoleArns) {
            assumableRoleArns(Arrays.asList(assumableRoleArns));
            return this;
        }

        public final Collection<String> getExecutionRoleArns() {
            if (executionRoleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return executionRoleArns;
        }

        public final void setExecutionRoleArns(Collection<String> executionRoleArns) {
            this.executionRoleArns = ExecutionRoleArnsCopier.copy(executionRoleArns);
        }

        @Override
        public final Builder executionRoleArns(Collection<String> executionRoleArns) {
            this.executionRoleArns = ExecutionRoleArnsCopier.copy(executionRoleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionRoleArns(String... executionRoleArns) {
            executionRoleArns(Arrays.asList(executionRoleArns));
            return this;
        }

        @Override
        public EmrSettings build() {
            return new EmrSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
