/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListClustersRequest.Builder, ListClustersRequest> {
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListClustersRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListClustersRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListClustersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListClustersRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClustersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListClustersRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListClustersRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, MAX_RESULTS_FIELD, NAME_CONTAINS_FIELD,
                    NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Integer maxResults;

    private final String nameContains;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListClustersRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Set a start time for the time range during which you want to list SageMaker HyperPod clusters. Timestamps are
     * formatted according to the ISO 8601 standard.
     * </p>
     * <p>
     * Acceptable formats include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (UTC), for example, <code>2014-10-01T20:30:00.000Z</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (with offset), for example, <code>2014-10-01T12:30:00.000-08:00</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DD</code>, for example, <code>2014-10-01</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Unix time in seconds, for example, <code>1412195400</code>. This is also referred to as Unix Epoch time and
     * represents the number of seconds since midnight, January 1, 1970 UTC.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about the timestamp format, see <a href=
     * "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
     * >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
     * </p>
     * 
     * @return Set a start time for the time range during which you want to list SageMaker HyperPod clusters. Timestamps
     *         are formatted according to the ISO 8601 standard. </p>
     *         <p>
     *         Acceptable formats include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (UTC), for example, <code>2014-10-01T20:30:00.000Z</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (with offset), for example,
     *         <code>2014-10-01T12:30:00.000-08:00</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DD</code>, for example, <code>2014-10-01</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Unix time in seconds, for example, <code>1412195400</code>. This is also referred to as Unix Epoch time
     *         and represents the number of seconds since midnight, January 1, 1970 UTC.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about the timestamp format, see <a href=
     *         "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
     *         >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Set an end time for the time range during which you want to list SageMaker HyperPod clusters. A filter that
     * returns nodes in a SageMaker HyperPod cluster created before the specified time. The acceptable formats are the
     * same as the timestamp formats for <code>CreationTimeAfter</code>. For more information about the timestamp
     * format, see <a href=
     * "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
     * >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
     * </p>
     * 
     * @return Set an end time for the time range during which you want to list SageMaker HyperPod clusters. A filter
     *         that returns nodes in a SageMaker HyperPod cluster created before the specified time. The acceptable
     *         formats are the same as the timestamp formats for <code>CreationTimeAfter</code>. For more information
     *         about the timestamp format, see <a href=
     *         "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
     *         >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Set the maximum number of SageMaker HyperPod clusters to list.
     * </p>
     * 
     * @return Set the maximum number of SageMaker HyperPod clusters to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Set the maximum number of instances to print in the list.
     * </p>
     * 
     * @return Set the maximum number of instances to print in the list.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Set the next token to retrieve the list of SageMaker HyperPod clusters.
     * </p>
     * 
     * @return Set the next token to retrieve the list of SageMaker HyperPod clusters.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The field by which to sort results. The default value is <code>CREATION_TIME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ClusterSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort results. The default value is <code>CREATION_TIME</code>.
     * @see ClusterSortBy
     */
    public final ClusterSortBy sortBy() {
        return ClusterSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The field by which to sort results. The default value is <code>CREATION_TIME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ClusterSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort results. The default value is <code>CREATION_TIME</code>.
     * @see ClusterSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results. The default value is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default value is <code>Ascending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results. The default value is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default value is <code>Ascending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest) obj;
        return Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersRequest").add("CreationTimeAfter", creationTimeAfter())
                .add("CreationTimeBefore", creationTimeBefore()).add("MaxResults", maxResults())
                .add("NameContains", nameContains()).add("NextToken", nextToken()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersRequest, T> g) {
        return obj -> g.apply((ListClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersRequest> {
        /**
         * <p>
         * Set a start time for the time range during which you want to list SageMaker HyperPod clusters. Timestamps are
         * formatted according to the ISO 8601 standard.
         * </p>
         * <p>
         * Acceptable formats include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (UTC), for example, <code>2014-10-01T20:30:00.000Z</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (with offset), for example,
         * <code>2014-10-01T12:30:00.000-08:00</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DD</code>, for example, <code>2014-10-01</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Unix time in seconds, for example, <code>1412195400</code>. This is also referred to as Unix Epoch time and
         * represents the number of seconds since midnight, January 1, 1970 UTC.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about the timestamp format, see <a href=
         * "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
         * >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
         * </p>
         * 
         * @param creationTimeAfter
         *        Set a start time for the time range during which you want to list SageMaker HyperPod clusters.
         *        Timestamps are formatted according to the ISO 8601 standard. </p>
         *        <p>
         *        Acceptable formats include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (UTC), for example, <code>2014-10-01T20:30:00.000Z</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDThh:mm:ss.sssTZD</code> (with offset), for example,
         *        <code>2014-10-01T12:30:00.000-08:00</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DD</code>, for example, <code>2014-10-01</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Unix time in seconds, for example, <code>1412195400</code>. This is also referred to as Unix Epoch
         *        time and represents the number of seconds since midnight, January 1, 1970 UTC.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about the timestamp format, see <a href=
         *        "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
         *        >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Set an end time for the time range during which you want to list SageMaker HyperPod clusters. A filter that
         * returns nodes in a SageMaker HyperPod cluster created before the specified time. The acceptable formats are
         * the same as the timestamp formats for <code>CreationTimeAfter</code>. For more information about the
         * timestamp format, see <a href=
         * "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
         * >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
         * </p>
         * 
         * @param creationTimeBefore
         *        Set an end time for the time range during which you want to list SageMaker HyperPod clusters. A filter
         *        that returns nodes in a SageMaker HyperPod cluster created before the specified time. The acceptable
         *        formats are the same as the timestamp formats for <code>CreationTimeAfter</code>. For more information
         *        about the timestamp format, see <a href=
         *        "https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
         *        >Timestamp</a> in the <i>Amazon Web Services Command Line Interface User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Set the maximum number of SageMaker HyperPod clusters to list.
         * </p>
         * 
         * @param maxResults
         *        Set the maximum number of SageMaker HyperPod clusters to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Set the maximum number of instances to print in the list.
         * </p>
         * 
         * @param nameContains
         *        Set the maximum number of instances to print in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Set the next token to retrieve the list of SageMaker HyperPod clusters.
         * </p>
         * 
         * @param nextToken
         *        Set the next token to retrieve the list of SageMaker HyperPod clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The field by which to sort results. The default value is <code>CREATION_TIME</code>.
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort results. The default value is <code>CREATION_TIME</code>.
         * @see ClusterSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field by which to sort results. The default value is <code>CREATION_TIME</code>.
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort results. The default value is <code>CREATION_TIME</code>.
         * @see ClusterSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterSortBy
         */
        Builder sortBy(ClusterSortBy sortBy);

        /**
         * <p>
         * The sort order for results. The default value is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default value is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results. The default value is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default value is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Integer maxResults;

        private String nameContains;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersRequest model) {
            super(model);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ClusterSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClustersRequest build() {
            return new ListClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
