/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityOffering;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityOfferingsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResourceName;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResourceNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingPlanOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingPlanOffering> {
    private static final SdkField<String> TRAINING_PLAN_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingPlanOfferingId").getter(TrainingPlanOffering.getter(TrainingPlanOffering::trainingPlanOfferingId)).setter(TrainingPlanOffering.setter(Builder::trainingPlanOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanOfferingId").build()}).build();
    private static final SdkField<List<String>> TARGET_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetResources").getter(TrainingPlanOffering.getter(TrainingPlanOffering::targetResourcesAsStrings)).setter(TrainingPlanOffering.setter(Builder::targetResourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> REQUESTED_START_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestedStartTimeAfter").getter(TrainingPlanOffering.getter(TrainingPlanOffering::requestedStartTimeAfter)).setter(TrainingPlanOffering.setter(Builder::requestedStartTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedStartTimeAfter").build()}).build();
    private static final SdkField<Instant> REQUESTED_END_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestedEndTimeBefore").getter(TrainingPlanOffering.getter(TrainingPlanOffering::requestedEndTimeBefore)).setter(TrainingPlanOffering.setter(Builder::requestedEndTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedEndTimeBefore").build()}).build();
    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationHours").getter(TrainingPlanOffering.getter(TrainingPlanOffering::durationHours)).setter(TrainingPlanOffering.setter(Builder::durationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()}).build();
    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMinutes").getter(TrainingPlanOffering.getter(TrainingPlanOffering::durationMinutes)).setter(TrainingPlanOffering.setter(Builder::durationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()}).build();
    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontFee").getter(TrainingPlanOffering.getter(TrainingPlanOffering::upfrontFee)).setter(TrainingPlanOffering.setter(Builder::upfrontFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(TrainingPlanOffering.getter(TrainingPlanOffering::currencyCode)).setter(TrainingPlanOffering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<List<ReservedCapacityOffering>> RESERVED_CAPACITY_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedCapacityOfferings").getter(TrainingPlanOffering.getter(TrainingPlanOffering::reservedCapacityOfferings)).setter(TrainingPlanOffering.setter(Builder::reservedCapacityOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityOfferings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedCapacityOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_PLAN_OFFERING_ID_FIELD, TARGET_RESOURCES_FIELD, REQUESTED_START_TIME_AFTER_FIELD, REQUESTED_END_TIME_BEFORE_FIELD, DURATION_HOURS_FIELD, DURATION_MINUTES_FIELD, UPFRONT_FEE_FIELD, CURRENCY_CODE_FIELD, RESERVED_CAPACITY_OFFERINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrainingPlanOfferingId", TRAINING_PLAN_OFFERING_ID_FIELD);
            this.put("TargetResources", TARGET_RESOURCES_FIELD);
            this.put("RequestedStartTimeAfter", REQUESTED_START_TIME_AFTER_FIELD);
            this.put("RequestedEndTimeBefore", REQUESTED_END_TIME_BEFORE_FIELD);
            this.put("DurationHours", DURATION_HOURS_FIELD);
            this.put("DurationMinutes", DURATION_MINUTES_FIELD);
            this.put("UpfrontFee", UPFRONT_FEE_FIELD);
            this.put("CurrencyCode", CURRENCY_CODE_FIELD);
            this.put("ReservedCapacityOfferings", RESERVED_CAPACITY_OFFERINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String trainingPlanOfferingId;
    private final List<String> targetResources;
    private final Instant requestedStartTimeAfter;
    private final Instant requestedEndTimeBefore;
    private final Long durationHours;
    private final Long durationMinutes;
    private final String upfrontFee;
    private final String currencyCode;
    private final List<ReservedCapacityOffering> reservedCapacityOfferings;

    private TrainingPlanOffering(BuilderImpl builder) {
        this.trainingPlanOfferingId = builder.trainingPlanOfferingId;
        this.targetResources = builder.targetResources;
        this.requestedStartTimeAfter = builder.requestedStartTimeAfter;
        this.requestedEndTimeBefore = builder.requestedEndTimeBefore;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
        this.reservedCapacityOfferings = builder.reservedCapacityOfferings;
    }

    public final String trainingPlanOfferingId() {
        return this.trainingPlanOfferingId;
    }

    public final List<SageMakerResourceName> targetResources() {
        return SageMakerResourceNamesCopier.copyStringToEnum(this.targetResources);
    }

    public final boolean hasTargetResources() {
        return this.targetResources != null && !(this.targetResources instanceof SdkAutoConstructList);
    }

    public final List<String> targetResourcesAsStrings() {
        return this.targetResources;
    }

    public final Instant requestedStartTimeAfter() {
        return this.requestedStartTimeAfter;
    }

    public final Instant requestedEndTimeBefore() {
        return this.requestedEndTimeBefore;
    }

    public final Long durationHours() {
        return this.durationHours;
    }

    public final Long durationMinutes() {
        return this.durationMinutes;
    }

    public final String upfrontFee() {
        return this.upfrontFee;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final boolean hasReservedCapacityOfferings() {
        return this.reservedCapacityOfferings != null && !(this.reservedCapacityOfferings instanceof SdkAutoConstructList);
    }

    public final List<ReservedCapacityOffering> reservedCapacityOfferings() {
        return this.reservedCapacityOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingPlanOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResources() ? this.targetResourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedStartTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedEndTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedCapacityOfferings() ? this.reservedCapacityOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingPlanOffering)) {
            return false;
        }
        TrainingPlanOffering other = (TrainingPlanOffering)obj;
        return Objects.equals(this.trainingPlanOfferingId(), other.trainingPlanOfferingId()) && this.hasTargetResources() == other.hasTargetResources() && Objects.equals(this.targetResourcesAsStrings(), other.targetResourcesAsStrings()) && Objects.equals(this.requestedStartTimeAfter(), other.requestedStartTimeAfter()) && Objects.equals(this.requestedEndTimeBefore(), other.requestedEndTimeBefore()) && Objects.equals(this.durationHours(), other.durationHours()) && Objects.equals(this.durationMinutes(), other.durationMinutes()) && Objects.equals(this.upfrontFee(), other.upfrontFee()) && Objects.equals(this.currencyCode(), other.currencyCode()) && this.hasReservedCapacityOfferings() == other.hasReservedCapacityOfferings() && Objects.equals(this.reservedCapacityOfferings(), other.reservedCapacityOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingPlanOffering").add("TrainingPlanOfferingId", (Object)this.trainingPlanOfferingId()).add("TargetResources", this.hasTargetResources() ? this.targetResourcesAsStrings() : null).add("RequestedStartTimeAfter", (Object)this.requestedStartTimeAfter()).add("RequestedEndTimeBefore", (Object)this.requestedEndTimeBefore()).add("DurationHours", (Object)this.durationHours()).add("DurationMinutes", (Object)this.durationMinutes()).add("UpfrontFee", (Object)this.upfrontFee()).add("CurrencyCode", (Object)this.currencyCode()).add("ReservedCapacityOfferings", this.hasReservedCapacityOfferings() ? this.reservedCapacityOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingPlanOfferingId": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanOfferingId()));
            }
            case "TargetResources": {
                return Optional.ofNullable(clazz.cast(this.targetResourcesAsStrings()));
            }
            case "RequestedStartTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.requestedStartTimeAfter()));
            }
            case "RequestedEndTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.requestedEndTimeBefore()));
            }
            case "DurationHours": {
                return Optional.ofNullable(clazz.cast(this.durationHours()));
            }
            case "DurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.durationMinutes()));
            }
            case "UpfrontFee": {
                return Optional.ofNullable(clazz.cast(this.upfrontFee()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "ReservedCapacityOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedCapacityOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrainingPlanOffering, T> g) {
        return obj -> g.apply((TrainingPlanOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingPlanOfferingId;
        private List<String> targetResources = DefaultSdkAutoConstructList.getInstance();
        private Instant requestedStartTimeAfter;
        private Instant requestedEndTimeBefore;
        private Long durationHours;
        private Long durationMinutes;
        private String upfrontFee;
        private String currencyCode;
        private List<ReservedCapacityOffering> reservedCapacityOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingPlanOffering model) {
            this.trainingPlanOfferingId(model.trainingPlanOfferingId);
            this.targetResourcesWithStrings(model.targetResources);
            this.requestedStartTimeAfter(model.requestedStartTimeAfter);
            this.requestedEndTimeBefore(model.requestedEndTimeBefore);
            this.durationHours(model.durationHours);
            this.durationMinutes(model.durationMinutes);
            this.upfrontFee(model.upfrontFee);
            this.currencyCode(model.currencyCode);
            this.reservedCapacityOfferings(model.reservedCapacityOfferings);
        }

        public final String getTrainingPlanOfferingId() {
            return this.trainingPlanOfferingId;
        }

        public final void setTrainingPlanOfferingId(String trainingPlanOfferingId) {
            this.trainingPlanOfferingId = trainingPlanOfferingId;
        }

        @Override
        public final Builder trainingPlanOfferingId(String trainingPlanOfferingId) {
            this.trainingPlanOfferingId = trainingPlanOfferingId;
            return this;
        }

        public final Collection<String> getTargetResources() {
            if (this.targetResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetResources;
        }

        public final void setTargetResources(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
        }

        @Override
        public final Builder targetResourcesWithStrings(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourcesWithStrings(String ... targetResources) {
            this.targetResourcesWithStrings(Arrays.asList(targetResources));
            return this;
        }

        @Override
        public final Builder targetResources(Collection<SageMakerResourceName> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copyEnumToString(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResources(SageMakerResourceName ... targetResources) {
            this.targetResources(Arrays.asList(targetResources));
            return this;
        }

        public final Instant getRequestedStartTimeAfter() {
            return this.requestedStartTimeAfter;
        }

        public final void setRequestedStartTimeAfter(Instant requestedStartTimeAfter) {
            this.requestedStartTimeAfter = requestedStartTimeAfter;
        }

        @Override
        public final Builder requestedStartTimeAfter(Instant requestedStartTimeAfter) {
            this.requestedStartTimeAfter = requestedStartTimeAfter;
            return this;
        }

        public final Instant getRequestedEndTimeBefore() {
            return this.requestedEndTimeBefore;
        }

        public final void setRequestedEndTimeBefore(Instant requestedEndTimeBefore) {
            this.requestedEndTimeBefore = requestedEndTimeBefore;
        }

        @Override
        public final Builder requestedEndTimeBefore(Instant requestedEndTimeBefore) {
            this.requestedEndTimeBefore = requestedEndTimeBefore;
            return this;
        }

        public final Long getDurationHours() {
            return this.durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return this.durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final String getUpfrontFee() {
            return this.upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final List<ReservedCapacityOffering.Builder> getReservedCapacityOfferings() {
            List<ReservedCapacityOffering.Builder> result = ReservedCapacityOfferingsCopier.copyToBuilder(this.reservedCapacityOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedCapacityOfferings(Collection<ReservedCapacityOffering.BuilderImpl> reservedCapacityOfferings) {
            this.reservedCapacityOfferings = ReservedCapacityOfferingsCopier.copyFromBuilder(reservedCapacityOfferings);
        }

        @Override
        public final Builder reservedCapacityOfferings(Collection<ReservedCapacityOffering> reservedCapacityOfferings) {
            this.reservedCapacityOfferings = ReservedCapacityOfferingsCopier.copy(reservedCapacityOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCapacityOfferings(ReservedCapacityOffering ... reservedCapacityOfferings) {
            this.reservedCapacityOfferings(Arrays.asList(reservedCapacityOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCapacityOfferings(Consumer<ReservedCapacityOffering.Builder> ... reservedCapacityOfferings) {
            this.reservedCapacityOfferings(Stream.of(reservedCapacityOfferings).map(c -> (ReservedCapacityOffering)((ReservedCapacityOffering.Builder)ReservedCapacityOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TrainingPlanOffering build() {
            return new TrainingPlanOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingPlanOffering> {
        public Builder trainingPlanOfferingId(String var1);

        public Builder targetResourcesWithStrings(Collection<String> var1);

        public Builder targetResourcesWithStrings(String ... var1);

        public Builder targetResources(Collection<SageMakerResourceName> var1);

        public Builder targetResources(SageMakerResourceName ... var1);

        public Builder requestedStartTimeAfter(Instant var1);

        public Builder requestedEndTimeBefore(Instant var1);

        public Builder durationHours(Long var1);

        public Builder durationMinutes(Long var1);

        public Builder upfrontFee(String var1);

        public Builder currencyCode(String var1);

        public Builder reservedCapacityOfferings(Collection<ReservedCapacityOffering> var1);

        public Builder reservedCapacityOfferings(ReservedCapacityOffering ... var1);

        public Builder reservedCapacityOfferings(Consumer<ReservedCapacityOffering.Builder> ... var1);
    }
}

