/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.TransformJobSummary;

public class ListTransformJobsIterable
implements SdkIterable<ListTransformJobsResponse> {
    private final SageMakerClient client;
    private final ListTransformJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTransformJobsIterable(SageMakerClient client, ListTransformJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTransformJobsResponseFetcher();
    }

    public Iterator<ListTransformJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransformJobSummary> transformJobSummaries() {
        Function<ListTransformJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transformJobSummaries() != null) {
                return response.transformJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTransformJobsResponseFetcher
    implements SyncPageFetcher<ListTransformJobsResponse> {
        private ListTransformJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransformJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTransformJobsResponse nextPage(ListTransformJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTransformJobsIterable.this.client.listTransformJobs(ListTransformJobsIterable.this.firstRequest);
            }
            return ListTransformJobsIterable.this.client.listTransformJobs((ListTransformJobsRequest)((Object)ListTransformJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

