/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure of additional Inference Specification. Additional Inference Specification specifies details about
 * inference jobs that can be run with models based on this model package
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalInferenceSpecificationDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalInferenceSpecificationDefinition.Builder, AdditionalInferenceSpecificationDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AdditionalInferenceSpecificationDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AdditionalInferenceSpecificationDefinition::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<ModelPackageContainerDefinition>> CONTAINERS_FIELD = SdkField
            .<List<ModelPackageContainerDefinition>> builder(MarshallingType.LIST)
            .memberName("Containers")
            .getter(getter(AdditionalInferenceSpecificationDefinition::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackageContainerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackageContainerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_TRANSFORM_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedTransformInstanceTypes")
            .getter(getter(AdditionalInferenceSpecificationDefinition::supportedTransformInstanceTypesAsStrings))
            .setter(setter(Builder::supportedTransformInstanceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTransformInstanceTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_REALTIME_INFERENCE_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedRealtimeInferenceInstanceTypes")
            .getter(getter(AdditionalInferenceSpecificationDefinition::supportedRealtimeInferenceInstanceTypesAsStrings))
            .setter(setter(Builder::supportedRealtimeInferenceInstanceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SupportedRealtimeInferenceInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedContentTypes")
            .getter(getter(AdditionalInferenceSpecificationDefinition::supportedContentTypes))
            .setter(setter(Builder::supportedContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_RESPONSE_MIME_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedResponseMIMETypes")
            .getter(getter(AdditionalInferenceSpecificationDefinition::supportedResponseMIMETypes))
            .setter(setter(Builder::supportedResponseMIMETypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedResponseMIMETypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONTAINERS_FIELD, SUPPORTED_TRANSFORM_INSTANCE_TYPES_FIELD, SUPPORTED_REALTIME_INFERENCE_INSTANCE_TYPES_FIELD,
            SUPPORTED_CONTENT_TYPES_FIELD, SUPPORTED_RESPONSE_MIME_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("Containers", CONTAINERS_FIELD);
                    put("SupportedTransformInstanceTypes", SUPPORTED_TRANSFORM_INSTANCE_TYPES_FIELD);
                    put("SupportedRealtimeInferenceInstanceTypes", SUPPORTED_REALTIME_INFERENCE_INSTANCE_TYPES_FIELD);
                    put("SupportedContentTypes", SUPPORTED_CONTENT_TYPES_FIELD);
                    put("SupportedResponseMIMETypes", SUPPORTED_RESPONSE_MIME_TYPES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final List<ModelPackageContainerDefinition> containers;

    private final List<String> supportedTransformInstanceTypes;

    private final List<String> supportedRealtimeInferenceInstanceTypes;

    private final List<String> supportedContentTypes;

    private final List<String> supportedResponseMIMETypes;

    private AdditionalInferenceSpecificationDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.containers = builder.containers;
        this.supportedTransformInstanceTypes = builder.supportedTransformInstanceTypes;
        this.supportedRealtimeInferenceInstanceTypes = builder.supportedRealtimeInferenceInstanceTypes;
        this.supportedContentTypes = builder.supportedContentTypes;
        this.supportedResponseMIMETypes = builder.supportedResponseMIMETypes;
    }

    /**
     * <p>
     * A unique name to identify the additional inference specification. The name must be unique within the list of your
     * additional inference specifications for a particular model package.
     * </p>
     * 
     * @return A unique name to identify the additional inference specification. The name must be unique within the list
     *         of your additional inference specifications for a particular model package.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the additional Inference specification
     * </p>
     * 
     * @return A description of the additional Inference specification
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon ECR registry path of the Docker image that contains the inference code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The Amazon ECR registry path of the Docker image that contains the inference code.
     */
    public final List<ModelPackageContainerDefinition> containers() {
        return containers;
    }

    /**
     * <p>
     * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedTransformInstanceTypes}
     * method.
     * </p>
     * 
     * @return A list of the instance types on which a transformation job can be run or on which an endpoint can be
     *         deployed.
     */
    public final List<TransformInstanceType> supportedTransformInstanceTypes() {
        return TransformInstanceTypesCopier.copyStringToEnum(supportedTransformInstanceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedTransformInstanceTypes
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSupportedTransformInstanceTypes() {
        return supportedTransformInstanceTypes != null && !(supportedTransformInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedTransformInstanceTypes}
     * method.
     * </p>
     * 
     * @return A list of the instance types on which a transformation job can be run or on which an endpoint can be
     *         deployed.
     */
    public final List<String> supportedTransformInstanceTypesAsStrings() {
        return supportedTransformInstanceTypes;
    }

    /**
     * <p>
     * A list of the instance types that are used to generate inferences in real-time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasSupportedRealtimeInferenceInstanceTypes} method.
     * </p>
     * 
     * @return A list of the instance types that are used to generate inferences in real-time.
     */
    public final List<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes() {
        return RealtimeInferenceInstanceTypesCopier.copyStringToEnum(supportedRealtimeInferenceInstanceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedRealtimeInferenceInstanceTypes
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSupportedRealtimeInferenceInstanceTypes() {
        return supportedRealtimeInferenceInstanceTypes != null
                && !(supportedRealtimeInferenceInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the instance types that are used to generate inferences in real-time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasSupportedRealtimeInferenceInstanceTypes} method.
     * </p>
     * 
     * @return A list of the instance types that are used to generate inferences in real-time.
     */
    public final List<String> supportedRealtimeInferenceInstanceTypesAsStrings() {
        return supportedRealtimeInferenceInstanceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedContentTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedContentTypes() {
        return supportedContentTypes != null && !(supportedContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported MIME types for the input data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedContentTypes} method.
     * </p>
     * 
     * @return The supported MIME types for the input data.
     */
    public final List<String> supportedContentTypes() {
        return supportedContentTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedResponseMIMETypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedResponseMIMETypes() {
        return supportedResponseMIMETypes != null && !(supportedResponseMIMETypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported MIME types for the output data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedResponseMIMETypes} method.
     * </p>
     * 
     * @return The supported MIME types for the output data.
     */
    public final List<String> supportedResponseMIMETypes() {
        return supportedResponseMIMETypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedTransformInstanceTypes() ? supportedTransformInstanceTypesAsStrings() : null);
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasSupportedRealtimeInferenceInstanceTypes() ? supportedRealtimeInferenceInstanceTypesAsStrings()
                                : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedContentTypes() ? supportedContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedResponseMIMETypes() ? supportedResponseMIMETypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalInferenceSpecificationDefinition)) {
            return false;
        }
        AdditionalInferenceSpecificationDefinition other = (AdditionalInferenceSpecificationDefinition) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && hasContainers() == other.hasContainers()
                && Objects.equals(containers(), other.containers())
                && hasSupportedTransformInstanceTypes() == other.hasSupportedTransformInstanceTypes()
                && Objects.equals(supportedTransformInstanceTypesAsStrings(), other.supportedTransformInstanceTypesAsStrings())
                && hasSupportedRealtimeInferenceInstanceTypes() == other.hasSupportedRealtimeInferenceInstanceTypes()
                && Objects.equals(supportedRealtimeInferenceInstanceTypesAsStrings(),
                        other.supportedRealtimeInferenceInstanceTypesAsStrings())
                && hasSupportedContentTypes() == other.hasSupportedContentTypes()
                && Objects.equals(supportedContentTypes(), other.supportedContentTypes())
                && hasSupportedResponseMIMETypes() == other.hasSupportedResponseMIMETypes()
                && Objects.equals(supportedResponseMIMETypes(), other.supportedResponseMIMETypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AdditionalInferenceSpecificationDefinition")
                .add("Name", name())
                .add("Description", description())
                .add("Containers", hasContainers() ? containers() : null)
                .add("SupportedTransformInstanceTypes",
                        hasSupportedTransformInstanceTypes() ? supportedTransformInstanceTypesAsStrings() : null)
                .add("SupportedRealtimeInferenceInstanceTypes",
                        hasSupportedRealtimeInferenceInstanceTypes() ? supportedRealtimeInferenceInstanceTypesAsStrings() : null)
                .add("SupportedContentTypes", hasSupportedContentTypes() ? supportedContentTypes() : null)
                .add("SupportedResponseMIMETypes", hasSupportedResponseMIMETypes() ? supportedResponseMIMETypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "SupportedTransformInstanceTypes":
            return Optional.ofNullable(clazz.cast(supportedTransformInstanceTypesAsStrings()));
        case "SupportedRealtimeInferenceInstanceTypes":
            return Optional.ofNullable(clazz.cast(supportedRealtimeInferenceInstanceTypesAsStrings()));
        case "SupportedContentTypes":
            return Optional.ofNullable(clazz.cast(supportedContentTypes()));
        case "SupportedResponseMIMETypes":
            return Optional.ofNullable(clazz.cast(supportedResponseMIMETypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalInferenceSpecificationDefinition, T> g) {
        return obj -> g.apply((AdditionalInferenceSpecificationDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalInferenceSpecificationDefinition> {
        /**
         * <p>
         * A unique name to identify the additional inference specification. The name must be unique within the list of
         * your additional inference specifications for a particular model package.
         * </p>
         * 
         * @param name
         *        A unique name to identify the additional inference specification. The name must be unique within the
         *        list of your additional inference specifications for a particular model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the additional Inference specification
         * </p>
         * 
         * @param description
         *        A description of the additional Inference specification
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         * </p>
         * 
         * @param containers
         *        The Amazon ECR registry path of the Docker image that contains the inference code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<ModelPackageContainerDefinition> containers);

        /**
         * <p>
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         * </p>
         * 
         * @param containers
         *        The Amazon ECR registry path of the Docker image that contains the inference code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(ModelPackageContainerDefinition... containers);

        /**
         * <p>
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition.Builder#build()} is
         * called immediately and its result is passed to {@link #containers(List<ModelPackageContainerDefinition>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelPackageContainerDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<ModelPackageContainerDefinition>)
         */
        Builder containers(Consumer<ModelPackageContainerDefinition.Builder>... containers);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypesWithStrings(Collection<String> supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypesWithStrings(String... supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypes(Collection<TransformInstanceType> supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be
         * deployed.
         * </p>
         * 
         * @param supportedTransformInstanceTypes
         *        A list of the instance types on which a transformation job can be run or on which an endpoint can be
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTransformInstanceTypes(TransformInstanceType... supportedTransformInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypesWithStrings(Collection<String> supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypesWithStrings(String... supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypes(
                Collection<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * A list of the instance types that are used to generate inferences in real-time.
         * </p>
         * 
         * @param supportedRealtimeInferenceInstanceTypes
         *        A list of the instance types that are used to generate inferences in real-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRealtimeInferenceInstanceTypes(ProductionVariantInstanceType... supportedRealtimeInferenceInstanceTypes);

        /**
         * <p>
         * The supported MIME types for the input data.
         * </p>
         * 
         * @param supportedContentTypes
         *        The supported MIME types for the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedContentTypes(Collection<String> supportedContentTypes);

        /**
         * <p>
         * The supported MIME types for the input data.
         * </p>
         * 
         * @param supportedContentTypes
         *        The supported MIME types for the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedContentTypes(String... supportedContentTypes);

        /**
         * <p>
         * The supported MIME types for the output data.
         * </p>
         * 
         * @param supportedResponseMIMETypes
         *        The supported MIME types for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes);

        /**
         * <p>
         * The supported MIME types for the output data.
         * </p>
         * 
         * @param supportedResponseMIMETypes
         *        The supported MIME types for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedResponseMIMETypes(String... supportedResponseMIMETypes);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<ModelPackageContainerDefinition> containers = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedTransformInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedRealtimeInferenceInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedContentTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedResponseMIMETypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalInferenceSpecificationDefinition model) {
            name(model.name);
            description(model.description);
            containers(model.containers);
            supportedTransformInstanceTypesWithStrings(model.supportedTransformInstanceTypes);
            supportedRealtimeInferenceInstanceTypesWithStrings(model.supportedRealtimeInferenceInstanceTypes);
            supportedContentTypes(model.supportedContentTypes);
            supportedResponseMIMETypes(model.supportedResponseMIMETypes);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ModelPackageContainerDefinition.Builder> getContainers() {
            List<ModelPackageContainerDefinition.Builder> result = ModelPackageContainerDefinitionListCopier
                    .copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<ModelPackageContainerDefinition.BuilderImpl> containers) {
            this.containers = ModelPackageContainerDefinitionListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<ModelPackageContainerDefinition> containers) {
            this.containers = ModelPackageContainerDefinitionListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ModelPackageContainerDefinition... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ModelPackageContainerDefinition.Builder>... containers) {
            containers(Stream.of(containers).map(c -> ModelPackageContainerDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedTransformInstanceTypes() {
            if (supportedTransformInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedTransformInstanceTypes;
        }

        public final void setSupportedTransformInstanceTypes(Collection<String> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copy(supportedTransformInstanceTypes);
        }

        @Override
        public final Builder supportedTransformInstanceTypesWithStrings(Collection<String> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copy(supportedTransformInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTransformInstanceTypesWithStrings(String... supportedTransformInstanceTypes) {
            supportedTransformInstanceTypesWithStrings(Arrays.asList(supportedTransformInstanceTypes));
            return this;
        }

        @Override
        public final Builder supportedTransformInstanceTypes(Collection<TransformInstanceType> supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes = TransformInstanceTypesCopier.copyEnumToString(supportedTransformInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTransformInstanceTypes(TransformInstanceType... supportedTransformInstanceTypes) {
            supportedTransformInstanceTypes(Arrays.asList(supportedTransformInstanceTypes));
            return this;
        }

        public final Collection<String> getSupportedRealtimeInferenceInstanceTypes() {
            if (supportedRealtimeInferenceInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedRealtimeInferenceInstanceTypes;
        }

        public final void setSupportedRealtimeInferenceInstanceTypes(Collection<String> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier
                    .copy(supportedRealtimeInferenceInstanceTypes);
        }

        @Override
        public final Builder supportedRealtimeInferenceInstanceTypesWithStrings(
                Collection<String> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier
                    .copy(supportedRealtimeInferenceInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRealtimeInferenceInstanceTypesWithStrings(String... supportedRealtimeInferenceInstanceTypes) {
            supportedRealtimeInferenceInstanceTypesWithStrings(Arrays.asList(supportedRealtimeInferenceInstanceTypes));
            return this;
        }

        @Override
        public final Builder supportedRealtimeInferenceInstanceTypes(
                Collection<ProductionVariantInstanceType> supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes = RealtimeInferenceInstanceTypesCopier
                    .copyEnumToString(supportedRealtimeInferenceInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRealtimeInferenceInstanceTypes(
                ProductionVariantInstanceType... supportedRealtimeInferenceInstanceTypes) {
            supportedRealtimeInferenceInstanceTypes(Arrays.asList(supportedRealtimeInferenceInstanceTypes));
            return this;
        }

        public final Collection<String> getSupportedContentTypes() {
            if (supportedContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedContentTypes;
        }

        public final void setSupportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
        }

        @Override
        public final Builder supportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedContentTypes(String... supportedContentTypes) {
            supportedContentTypes(Arrays.asList(supportedContentTypes));
            return this;
        }

        public final Collection<String> getSupportedResponseMIMETypes() {
            if (supportedResponseMIMETypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedResponseMIMETypes;
        }

        public final void setSupportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes = ResponseMIMETypesCopier.copy(supportedResponseMIMETypes);
        }

        @Override
        public final Builder supportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes = ResponseMIMETypesCopier.copy(supportedResponseMIMETypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedResponseMIMETypes(String... supportedResponseMIMETypes) {
            supportedResponseMIMETypes(Arrays.asList(supportedResponseMIMETypes));
            return this;
        }

        @Override
        public AdditionalInferenceSpecificationDefinition build() {
            return new AdditionalInferenceSpecificationDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
