/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data sources that are available to your model in addition to the one that you specify for
 * <code>ModelDataSource</code> when you use the <code>CreateModel</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalModelDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalModelDataSource.Builder, AdditionalModelDataSource> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(AdditionalModelDataSource::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<S3ModelDataSource> S3_DATA_SOURCE_FIELD = SdkField
            .<S3ModelDataSource> builder(MarshallingType.SDK_POJO).memberName("S3DataSource")
            .getter(getter(AdditionalModelDataSource::s3DataSource)).setter(setter(Builder::s3DataSource))
            .constructor(S3ModelDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            S3_DATA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ChannelName", CHANNEL_NAME_FIELD);
                    put("S3DataSource", S3_DATA_SOURCE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String channelName;

    private final S3ModelDataSource s3DataSource;

    private AdditionalModelDataSource(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.s3DataSource = builder.s3DataSource;
    }

    /**
     * <p>
     * A custom name for this <code>AdditionalModelDataSource</code> object.
     * </p>
     * 
     * @return A custom name for this <code>AdditionalModelDataSource</code> object.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * Returns the value of the S3DataSource property for this object.
     * 
     * @return The value of the S3DataSource property for this object.
     */
    public final S3ModelDataSource s3DataSource() {
        return s3DataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalModelDataSource)) {
            return false;
        }
        AdditionalModelDataSource other = (AdditionalModelDataSource) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(s3DataSource(), other.s3DataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalModelDataSource").add("ChannelName", channelName())
                .add("S3DataSource", s3DataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "S3DataSource":
            return Optional.ofNullable(clazz.cast(s3DataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalModelDataSource, T> g) {
        return obj -> g.apply((AdditionalModelDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalModelDataSource> {
        /**
         * <p>
         * A custom name for this <code>AdditionalModelDataSource</code> object.
         * </p>
         * 
         * @param channelName
         *        A custom name for this <code>AdditionalModelDataSource</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * Sets the value of the S3DataSource property for this object.
         *
         * @param s3DataSource
         *        The new value for the S3DataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSource(S3ModelDataSource s3DataSource);

        /**
         * Sets the value of the S3DataSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3ModelDataSource.Builder} avoiding the
         * need to create one manually via {@link S3ModelDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ModelDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataSource(S3ModelDataSource)}.
         * 
         * @param s3DataSource
         *        a consumer that will call methods on {@link S3ModelDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataSource(S3ModelDataSource)
         */
        default Builder s3DataSource(Consumer<S3ModelDataSource.Builder> s3DataSource) {
            return s3DataSource(S3ModelDataSource.builder().applyMutation(s3DataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String channelName;

        private S3ModelDataSource s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalModelDataSource model) {
            channelName(model.channelName);
            s3DataSource(model.s3DataSource);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final S3ModelDataSource.Builder getS3DataSource() {
            return s3DataSource != null ? s3DataSource.toBuilder() : null;
        }

        public final void setS3DataSource(S3ModelDataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public final Builder s3DataSource(S3ModelDataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        @Override
        public AdditionalModelDataSource build() {
            return new AdditionalModelDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
