/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an algorithm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlgorithmSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AlgorithmSummary.Builder, AlgorithmSummary> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmName").getter(getter(AlgorithmSummary::algorithmName)).setter(setter(Builder::algorithmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()).build();

    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmArn").getter(getter(AlgorithmSummary::algorithmArn)).setter(setter(Builder::algorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()).build();

    private static final SdkField<String> ALGORITHM_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmDescription").getter(getter(AlgorithmSummary::algorithmDescription))
            .setter(setter(Builder::algorithmDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AlgorithmSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ALGORITHM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmStatus").getter(getter(AlgorithmSummary::algorithmStatusAsString))
            .setter(setter(Builder::algorithmStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD,
            ALGORITHM_ARN_FIELD, ALGORITHM_DESCRIPTION_FIELD, CREATION_TIME_FIELD, ALGORITHM_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AlgorithmName", ALGORITHM_NAME_FIELD);
                    put("AlgorithmArn", ALGORITHM_ARN_FIELD);
                    put("AlgorithmDescription", ALGORITHM_DESCRIPTION_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("AlgorithmStatus", ALGORITHM_STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String algorithmName;

    private final String algorithmArn;

    private final String algorithmDescription;

    private final Instant creationTime;

    private final String algorithmStatus;

    private AlgorithmSummary(BuilderImpl builder) {
        this.algorithmName = builder.algorithmName;
        this.algorithmArn = builder.algorithmArn;
        this.algorithmDescription = builder.algorithmDescription;
        this.creationTime = builder.creationTime;
        this.algorithmStatus = builder.algorithmStatus;
    }

    /**
     * <p>
     * The name of the algorithm that is described by the summary.
     * </p>
     * 
     * @return The name of the algorithm that is described by the summary.
     */
    public final String algorithmName() {
        return algorithmName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the algorithm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the algorithm.
     */
    public final String algorithmArn() {
        return algorithmArn;
    }

    /**
     * <p>
     * A brief description of the algorithm.
     * </p>
     * 
     * @return A brief description of the algorithm.
     */
    public final String algorithmDescription() {
        return algorithmDescription;
    }

    /**
     * <p>
     * A timestamp that shows when the algorithm was created.
     * </p>
     * 
     * @return A timestamp that shows when the algorithm was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The overall status of the algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmStatus}
     * will return {@link AlgorithmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmStatusAsString}.
     * </p>
     * 
     * @return The overall status of the algorithm.
     * @see AlgorithmStatus
     */
    public final AlgorithmStatus algorithmStatus() {
        return AlgorithmStatus.fromValue(algorithmStatus);
    }

    /**
     * <p>
     * The overall status of the algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmStatus}
     * will return {@link AlgorithmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmStatusAsString}.
     * </p>
     * 
     * @return The overall status of the algorithm.
     * @see AlgorithmStatus
     */
    public final String algorithmStatusAsString() {
        return algorithmStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmName());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSummary)) {
            return false;
        }
        AlgorithmSummary other = (AlgorithmSummary) obj;
        return Objects.equals(algorithmName(), other.algorithmName()) && Objects.equals(algorithmArn(), other.algorithmArn())
                && Objects.equals(algorithmDescription(), other.algorithmDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(algorithmStatusAsString(), other.algorithmStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlgorithmSummary").add("AlgorithmName", algorithmName()).add("AlgorithmArn", algorithmArn())
                .add("AlgorithmDescription", algorithmDescription()).add("CreationTime", creationTime())
                .add("AlgorithmStatus", algorithmStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlgorithmName":
            return Optional.ofNullable(clazz.cast(algorithmName()));
        case "AlgorithmArn":
            return Optional.ofNullable(clazz.cast(algorithmArn()));
        case "AlgorithmDescription":
            return Optional.ofNullable(clazz.cast(algorithmDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "AlgorithmStatus":
            return Optional.ofNullable(clazz.cast(algorithmStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmSummary, T> g) {
        return obj -> g.apply((AlgorithmSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlgorithmSummary> {
        /**
         * <p>
         * The name of the algorithm that is described by the summary.
         * </p>
         * 
         * @param algorithmName
         *        The name of the algorithm that is described by the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmName(String algorithmName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the algorithm.
         * </p>
         * 
         * @param algorithmArn
         *        The Amazon Resource Name (ARN) of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmArn(String algorithmArn);

        /**
         * <p>
         * A brief description of the algorithm.
         * </p>
         * 
         * @param algorithmDescription
         *        A brief description of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmDescription(String algorithmDescription);

        /**
         * <p>
         * A timestamp that shows when the algorithm was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the algorithm was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The overall status of the algorithm.
         * </p>
         * 
         * @param algorithmStatus
         *        The overall status of the algorithm.
         * @see AlgorithmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmStatus
         */
        Builder algorithmStatus(String algorithmStatus);

        /**
         * <p>
         * The overall status of the algorithm.
         * </p>
         * 
         * @param algorithmStatus
         *        The overall status of the algorithm.
         * @see AlgorithmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmStatus
         */
        Builder algorithmStatus(AlgorithmStatus algorithmStatus);
    }

    static final class BuilderImpl implements Builder {
        private String algorithmName;

        private String algorithmArn;

        private String algorithmDescription;

        private Instant creationTime;

        private String algorithmStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmSummary model) {
            algorithmName(model.algorithmName);
            algorithmArn(model.algorithmArn);
            algorithmDescription(model.algorithmDescription);
            creationTime(model.creationTime);
            algorithmStatus(model.algorithmStatus);
        }

        public final String getAlgorithmName() {
            return algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final String getAlgorithmArn() {
            return algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final String getAlgorithmDescription() {
            return algorithmDescription;
        }

        public final void setAlgorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
        }

        @Override
        public final Builder algorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlgorithmStatus() {
            return algorithmStatus;
        }

        public final void setAlgorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
        }

        @Override
        public final Builder algorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
            return this;
        }

        @Override
        public final Builder algorithmStatus(AlgorithmStatus algorithmStatus) {
            this.algorithmStatus(algorithmStatus == null ? null : algorithmStatus.toString());
            return this;
        }

        @Override
        public AlgorithmSummary build() {
            return new AlgorithmSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
